/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.browsecontexts;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContextRequest;
import org.simantics.browsing.ui.model.browsecontexts.ContributedBrowseContexts;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;

public class ResolveBrowseContext
extends UnaryRead<NodeContext, BrowseContext> {
    public ResolveBrowseContext(NodeContext parameter) {
        super((Object)parameter);
    }

    private Resource getPossibleResource(ReadGraph graph) throws DatabaseException {
        Object input = ((NodeContext)this.parameter).getConstant(BuiltinKeys.INPUT);
        if (input instanceof Resource) {
            return (Resource)input;
        }
        if (input instanceof Variable) {
            return ((Variable)input).getPossibleRepresents(graph);
        }
        return null;
    }

    private String getPossibleUIContext() {
        return (String)((NodeContext)this.parameter).getConstant(BuiltinKeys.UI_CONTEXT);
    }

    public BrowseContext perform(ReadGraph graph) throws DatabaseException {
        Resource resource = this.getPossibleResource(graph);
        if (resource == null) {
            return null;
        }
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        if (indexRoot == null) {
            return null;
        }
        Collection contexts = (Collection)graph.syncRequest((Read)new ContributedBrowseContexts(indexRoot, resource, this.getPossibleUIContext()));
        if (contexts.isEmpty()) {
            return null;
        }
        return (BrowseContext)graph.syncRequest((Read)new BrowseContextRequest(contexts));
    }
}

