package org.simantics.browsing.ui.model.tests;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A visual contribution rule test that checks whether the input content is an
 * instance of a Java class. The class is specified by identifying the source
 * bundle and the class name.
 * 
 * @author Tuukka Lehtonen
 */
public class InstanceOfTest implements Test {

    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceOfTest.class);
    String   bundleName;
    String   className;
    Class<?> clazz;
    boolean  failed;

    public InstanceOfTest(String bundle, String className) {
        this.bundleName = bundle;
        this.className = className;
    }

    public InstanceOfTest(ReadGraph graph, Resource test) throws DatabaseException {
        ViewpointResource VP = ViewpointResource.getInstance(graph);
        this.bundleName = graph.getRelatedValue(test, VP.InstanceOfTest_bundleName, Bindings.STRING);
        this.className = graph.getRelatedValue(test, VP.InstanceOfTest_className, Bindings.STRING);
    }

    private Class<?> resolveClass() {
        if (failed)
            return null;
        if (clazz != null)
            return clazz;
        Bundle b = Platform.getBundle(bundleName);
        if (b == null) {
            LOGGER.error(getClass() + " could not resolve class " + className + ", bundle " + bundleName + " not found in platform");
            failed = true;
            return null;
        }
        try {
            this.clazz = b.loadClass(className);
            return clazz;
        } catch (ClassNotFoundException e) {
            LOGGER.error(getClass() + " could not resolve class " + className + ", from bundle " + bundleName, e);
            failed = true;
            return null;
        }
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        Class<?> clazz = resolveClass();
        return clazz != null && clazz.equals(contentType);
    }

    @Override
    public boolean test(ReadGraph graph, Object content)
            throws DatabaseException {
        Class<?> clazz = resolveClass();
        return clazz != null && clazz.isInstance(content);
    }

}
