/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.tests;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 * @since 1.30.0
 */
public enum HasURITest implements Test {
    INSTANCE;

    public static HasURITest get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        if (content instanceof Resource) {
            return graph.getPossibleURI((Resource) content) != null;
        } else if (content instanceof Variable) {
            try {
                Variable v = (Variable) content;
                return v.getURI(graph) != null;
            } catch (InvalidVariableException e) {
                return false;
            }
        }
        return false;
    }

}
