/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.sorters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class LinkedListSorter implements Sorter {

    public static final LinkedListSorter INSTANCE = new LinkedListSorter();
    
    private LinkedListSorter() {}

	@Override
	public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		Set<Resource> parents = new HashSet<Resource>();
		Map<Resource, NodeContext> map = new HashMap<Resource, NodeContext>();
		for(NodeContext node : nodes) {
			Resource r = (Resource)node.getConstant(BuiltinKeys.INPUT);
			Resource parent = graph.getPossibleObject(r, L0.PartOf);
			parents.add(parent);
			map.put(r, node);
		}
		
		if(parents.contains(null)) return;
		if(parents.size() != 1) return;

		Resource parent = parents.iterator().next();
		nodes.clear();
		for(Resource r : ListUtils.toList(graph, parent))  {
			NodeContext ctx = map.get(r);
			if(ctx != null) nodes.add(ctx);
		}
    	
    }

}
