/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.nodetypes;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.HierarchyMultiMap;

/**
 * HierarchyMultiMap specialized for NodeType keys.
 * 
 * @author Hannu Niemistö
 */
public class NodeTypeMultiMap<T> extends HierarchyMultiMap<NodeType, T> {

    @Override
    protected Collection<NodeType> getImmediateSuperelements(ReadGraph g, NodeType a) throws DatabaseException {
        return a.getSuper(g);
    }

}
