/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public enum NoModifierRule implements ModifierRule {

    INSTANCE;

    /**
     * This modifier is fixed to indicate that there shall be no modifier. It is
     * processed in
     * {@link BrowseContext#getModifier(ReadGraph, org.simantics.browsing.ui.NodeContext, String)}
     * .
     */
    public static Modifier NO_MODIFIER = new Modifier() {
        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
        @Override
        public String isValid(String label) {
            throw new UnsupportedOperationException();
        }
        @Override
        public void modify(String label) {
            throw new UnsupportedOperationException();
        }
    };

    public static NoModifierRule get() {
        return INSTANCE;
    }

    /**
     * Compatible with any content type.
     */
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public Modifier getModifier(ReadGraph graph, Object content,
            String columnKey) throws DatabaseException {
        return NO_MODIFIER;
    }

}
