/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.content.Labeler.DeniedModifier;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class ModifierContribution extends VisualsContribution {
    ModifierRule modifierRule;
    
    public ModifierContribution(NodeType nodeType, Test test, ModifierRule modifierRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if(!modifierRule.isCompatible(
                nodeType.getContentType()
                ))
            throw new InvalidContribution("Label rule is not compatible with the content type.");
        this.modifierRule = modifierRule;
    }
       
    public Modifier getModifier(ReadGraph graph, NodeContext context, String columnKey) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if(test == null || test.test(graph, content))            
                return modifierRule.getModifier(graph, content, columnKey);
            else
                return null;
        } catch(DatabaseException e) {
        	return new DeniedModifier(e.getMessage());
        }
    }    
}
