/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.labels;

import java.util.Collections;
import java.util.Map;

import org.simantics.db.ReadGraph;

/**
 * Constant label rule gives a fixed label to a node.
 * @author Hannu Niemistö
 */
public class ConstantLabelRule implements LabelRule {
    String label;
    String column;

    public ConstantLabelRule(String label, String column) {    
        this.label = label;
        this.column = column;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) {
        return Collections.singletonMap(column, label);
    }
}
