/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.imagedecorators;

import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.model.visuals.VisualsRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Image decoration rule gives an image decorators to a node.
 * @author Hannu Niemist&ouml;
 * 
 * @see org.simantics.utils.ui.gfx.DecorationOverlayIcon
 * @see org.simantics.utils.ui.gfx.AlphaAdjustmentImageDescriptor
 * @see org.simantics.utils.ui.gfx.HSVAdjustmentImageDescriptor
 */
public interface ImageDecorationRule extends VisualsRule {
    ImageDecorator getImageDecorator(ReadGraph graph, Object content) throws DatabaseException;
}
