/*******************************************************************************
 * Copyright (c) 2010, 2021 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - hasChildren
 *******************************************************************************/
package org.simantics.browsing.ui.model.children;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;

/**
 * A child rule that says that there is exactly one child node whose content 
 * is equal to the content of the parent.
 * @author Hannu Niemistö
 */
public class RelationStatementRule implements ChildRule {

    Resource relation;

    public RelationStatementRule(Resource relation, Test test) {
        this.relation = relation;
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for(Resource property : graph.getPredicates((Resource)parent)) {
            if(graph.isSubrelationOf(property, relation)) {
                result.addAll(graph.getStatements((Resource)parent, property));
            }
        }
        return result;
    }

    @Override
    public boolean hasChildren(ReadGraph graph, Object parent) throws DatabaseException {
        for(Resource property : graph.getPredicates((Resource)parent)) {
            if(graph.isSubrelationOf(property, relation)) {
                if (graph.hasStatement((Resource)parent, property))
                    return true;
            }
        }
        return false;
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child)
            throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }
}
