/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.check;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Produces images for nodes of given node type.
 * @author Hannu Niemistö
 */
public class CheckedStateContribution extends VisualsContribution {
	
    CheckedStateRule stateRule;
    
    public CheckedStateContribution(NodeType nodeType, Test test, CheckedStateRule stateRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if(!stateRule.isCompatible(
                nodeType.getContentType()
                ))
            throw new InvalidContribution("image rule is not compatible with the content type.");
        this.stateRule = stateRule;
    }   
    
    /**
     * Returns a image for the node or null, if contribution is
     * not suitable for the input.
     */
    public CheckedState getCheckedState(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if(test == null || test.test(graph, content))
                return stateRule.getCheckedState(graph, content);
            else
                return null;
        } catch(DatabaseException e) {
            // TODO reconsider
            return null;
        }
    }
}
