/*******************************************************************************
 * Copyright (c) 2015, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.browsecontexts;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.actions.ActionBrowseContextRequest;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class ResolveActionBrowseContext extends BinaryRead<Resource,String,ActionBrowseContext> {

    public ResolveActionBrowseContext(ReadGraph graph, NodeContext context) throws DatabaseException {
        super(getPossibleResource(graph, context), getPossibleUIContext(context));
    }

    public ResolveActionBrowseContext(Resource resource, String uiContext) {
        super(resource,uiContext);
    }

    private static Resource getPossibleResource(ReadGraph graph, NodeContext parameter) throws DatabaseException {
        Object input = parameter.getConstant(BuiltinKeys.INPUT);
        if(input instanceof Resource) return (Resource)input;
        else if (input instanceof Variable) return ((Variable)input).getPossibleRepresents(graph);
        else return null;
    }
    
    private static String getPossibleUIContext(NodeContext parameter) {
        return parameter.getConstant(BuiltinKeys.UI_CONTEXT);
    }
    
    @Override
    public ActionBrowseContext perform(ReadGraph graph) throws DatabaseException {
        
        if(parameter == null)
        	return null;
        
        Resource indexRoot = graph.syncRequest(new PossibleIndexRoot(parameter));
        if(indexRoot == null)
        	return null;

        Collection<Resource> contexts = graph.syncRequest(new ContributedActionBrowseContexts(indexRoot, parameter, parameter2));
        
        if(contexts.isEmpty()) return null;
        
        return graph.syncRequest(new ActionBrowseContextRequest(contexts));
        
    }

}
