package org.simantics.browsing.ui.model.browsecontexts;

import java.util.Collection;

import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;

public class BrowseContextRequest extends UnaryRead<Collection<Resource>,BrowseContext> {

    public BrowseContextRequest(Collection<Resource> parameter) {
        super(parameter);
    }

    @Override
    public BrowseContext perform(ReadGraph graph) throws DatabaseException {
        
        try {
            return BrowseContext.create(graph, parameter);
        } catch (InvalidContribution e) {
            Logger.defaultLogError(e);
            return null;
        }
        
    }

}
