/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.pythonlink.variable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.RecordType;
import org.simantics.pythonlink.NDArray;
import org.simantics.pythonlink.PythonContext;
import org.simantics.pythonlink.variable.PythonNode;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.simulator.variable.impl.AbstractNodeManager;

public class PythonNodeManager
extends AbstractNodeManager<PythonNode> {
    PythonContext context;
    static Realm realm = new Realm(){

        public void asyncExec(Runnable runnable) {
            runnable.run();
        }

        public void syncExec(Runnable runnable) {
            runnable.run();
        }
    };
    Map<String, Set<Runnable>> listeners = new HashMap<String, Set<Runnable>>();
    Map<String, PythonNode> nodes = new HashMap<String, PythonNode>();
    PythonNode root = new PythonNode("/");
    static Pattern namePattern = Pattern.compile("/?([a-zA-Z_][a-zA-Z_0-9]*)");
    static MapType dictionaryType = new MapType((Datatype)Datatypes.VARIANT, (Datatype)Datatypes.VARIANT);
    static RecordType ndarrayType = (RecordType)Bindings.getBindingUnchecked(NDArray.class).type();

    public PythonNodeManager(PythonContext context) {
        this.context = context;
        context.addListener(new PythonContext.Listener(){

            @Override
            public void updated(String variableName) {
                block6: {
                    block5: {
                        if (variableName == null) break block5;
                        Set<Runnable> lis = PythonNodeManager.this.listeners.get(variableName);
                        if (lis != null) {
                            for (Runnable runnable : lis) {
                                runnable.run();
                            }
                        }
                        if ((lis = PythonNodeManager.this.listeners.get("/")) == null) break block6;
                        for (Runnable runnable : lis) {
                            runnable.run();
                        }
                        break block6;
                    }
                    HashSet allRunnables = new HashSet();
                    for (Collection collection : PythonNodeManager.this.listeners.values()) {
                        allRunnables.addAll(collection);
                    }
                    for (Runnable runnable : allRunnables) {
                        runnable.run();
                    }
                }
            }

            @Override
            public void closed() {
                PythonNodeManager.this.nodes.clear();
                HashSet allRunnables = new HashSet();
                for (Collection collection : PythonNodeManager.this.listeners.values()) {
                    allRunnables.addAll(collection);
                }
                for (Runnable runnable : allRunnables) {
                    runnable.run();
                }
            }
        });
    }

    public Realm getRealm() {
        return realm;
    }

    public String getName(PythonNode node) {
        return node.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeListener(PythonNode node, Runnable listener) {
        Map<String, Set<Runnable>> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.containsKey(node.getName())) {
                this.listeners.put(node.getName(), new HashSet());
            }
            this.listeners.get(node.getName()).add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeListener(PythonNode node, Runnable listener) {
        Map<String, Set<Runnable>> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.containsKey(node.getName())) {
                this.listeners.get(node.getName()).remove(listener);
            }
        }
    }

    public PythonNode getNode(String path) throws NodeManagerException {
        if (!this.context.isOpen()) {
            return null;
        }
        if ("/".equals(path)) {
            return this.root;
        }
        Matcher match = namePattern.matcher(path);
        if (!match.matches()) {
            return null;
        }
        String name = match.group(1);
        if (this.nodes.containsKey(name)) {
            return this.nodes.get(name);
        }
        PythonContext.VariableType type = this.context.getPythonVariableType(name);
        if (type == PythonContext.VariableType.NO_VARIABLE) {
            return null;
        }
        PythonNode node = new PythonNode(name);
        this.nodes.put(path, node);
        return node;
    }

    public PythonNode getChild(PythonNode node, String name) throws NodeManagerException {
        return null;
    }

    public PythonNode getProperty(PythonNode node, String name) throws NodeManagerException {
        if (node != this.root || !this.context.isOpen()) {
            return null;
        }
        return this.getNode(name);
    }

    public List<String> getChildNames(PythonNode node) throws NodeManagerException {
        return Collections.emptyList();
    }

    public List<PythonNode> getChildren(PythonNode node) throws NodeManagerException {
        return Collections.emptyList();
    }

    public List<String> getPropertyNames(PythonNode node) throws NodeManagerException {
        if (node != this.root || !this.context.isOpen()) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.context.getPythonVariableNames());
    }

    public List<PythonNode> getProperties(PythonNode node) throws NodeManagerException {
        if (node != this.root || !this.context.isOpen()) {
            return Collections.emptyList();
        }
        String[] names = this.context.getPythonVariableNames();
        ArrayList<PythonNode> result = new ArrayList<PythonNode>(names.length);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result.add(this.getNode(name));
            ++n2;
        }
        return result;
    }

    public Datatype getDatatype(PythonNode node) throws NodeManagerException {
        PythonContext.VariableType type;
        String name = node.getName();
        try {
            type = this.context.getPythonVariableType(name);
        }
        catch (RuntimeException e) {
            throw new NodeManagerException("Failed to get type of variable " + name, (Throwable)e);
        }
        switch (type) {
            case NO_VARIABLE: {
                return Datatypes.VOID;
            }
            case BOOLEAN: {
                return Datatypes.BOOLEAN;
            }
            case LONG: {
                return Datatypes.LONG;
            }
            case FLOAT: {
                return Datatypes.DOUBLE;
            }
            case STRING: {
                return Datatypes.STRING;
            }
            case BYTEARRAY: {
                return Datatypes.BYTE_ARRAY;
            }
            case DICTIONARY: {
                return dictionaryType;
            }
            case NDARRAY: {
                return ndarrayType;
            }
            case SEQUENCE: {
                return Datatypes.VARIANT_ARRAY;
            }
            case UNKNOWN: {
                return Datatypes.VOID;
            }
        }
        throw new RuntimeException("Unknown python variable type");
    }

    public Variant getValue(PythonNode node, String propertyName) throws NodeManagerException {
        if (node == this.root && this.context.isOpen()) {
            return this.context.getPythonVariantVariable(propertyName);
        }
        throw new NodeManagerException("No value available for " + node.getName() + "#" + propertyName);
    }

    public Object getValue(PythonNode node, String propertyName, Binding binding) throws NodeManagerException, BindingException {
        Variant value = this.getValue(node, propertyName);
        try {
            return value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public Variant getValue(PythonNode node) throws NodeManagerException {
        if (node == this.root || !this.context.isOpen()) {
            throw new NodeManagerException("No value available for " + node.getName());
        }
        String name = node.getName();
        try {
            return this.context.getPythonVariantVariable(name);
        }
        catch (RuntimeException e) {
            throw new NodeManagerException("Failed to get value of variable " + name, (Throwable)e);
        }
    }

    public Object getValue(PythonNode node, Binding binding) throws NodeManagerException, BindingException {
        Variant value = this.getValue(node);
        try {
            return value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public void setValue(PythonNode node, String propertyName, Object value, Binding binding) throws NodeManagerException, BindingException {
        if (node != this.root || !this.context.isOpen()) {
            throw new NodeManagerException("No property " + node.getName() + "#" + propertyName);
        }
        this.context.setPythonVariantVariable(propertyName, value, binding);
    }

    public void setValue(PythonNode node, Object value, Binding binding) throws NodeManagerException, BindingException {
        if (node == this.root || !this.context.isOpen()) {
            throw new NodeManagerException("No property " + node.getName());
        }
        String name = node.getName();
        this.context.setPythonVariantVariable(name, value, binding);
    }

    public Set<String> getClassifications(PythonNode node) throws NodeManagerException {
        return Collections.emptySet();
    }
}

