/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph.controlpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.scenegraph.G3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import vtk.vtkRenderer;

public class PipeControlPoint
extends G3DNode
implements IP3DNode {
    private static boolean DEBUG = false;
    private PipelineComponent component;
    private PointType type;
    private boolean isFixed = true;
    private boolean isMod = false;
    private boolean isRotate = false;
    private boolean isReverse = false;
    private boolean isDeletable = true;
    private boolean isSizeChange = false;
    private boolean isSub = false;
    private boolean disposed = false;
    private PipeControlPoint next;
    private PipeControlPoint previous;
    public PipeControlPoint parent;
    public List<PipeControlPoint> children = new ArrayList<PipeControlPoint>();
    private double length;
    private Double turnAngle;
    private Vector3d turnAxis;
    private Double offset;
    private Double rotationAngle;
    private Boolean reversed;

    public PipeControlPoint(PipelineComponent component) {
        this.component = component;
        if (component.getPipeRun() != null) {
            component.getPipeRun().addChild(this);
        }
    }

    public PipeControlPoint(PipelineComponent component, PipeRun piperun) {
        this.component = component;
        piperun.addChild(this);
    }

    @Override
    public void update(vtkRenderer ren) {
        try {
            this.requestUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PipeRun getPipeRun() {
        return (PipeRun)this.getParent();
    }

    public PipelineComponent getPipelineComponent() {
        return this.component;
    }

    public PointType getType() {
        return this.type;
    }

    public void setType(PointType type) {
        this.type = type;
    }

    @GetPropertyValue(name="Fixed", tabId="Debug", value="fixed")
    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean fixed) {
        this.isFixed = fixed;
    }

    @GetPropertyValue(name="Mod", tabId="Debug", value="mod")
    public boolean isMod() {
        return this.isMod;
    }

    public void setMod(boolean isMod) {
        this.isMod = isMod;
    }

    @GetPropertyValue(name="Rotate", tabId="Debug", value="rotate")
    public boolean isRotate() {
        return this.isRotate;
    }

    public void setRotate(boolean rotate) {
        this.isRotate = rotate;
    }

    @GetPropertyValue(name="Reverse", tabId="Debug", value="reverse")
    public boolean isReverse() {
        return this.isReverse;
    }

    public void setReverse(boolean reverse) {
        this.isReverse = reverse;
    }

    public void setSub(boolean sub) {
        this.isSub = sub;
    }

    @GetPropertyValue(name="Deletable", tabId="Debug", value="deletable")
    public boolean isDeletable() {
        return this.isDeletable;
    }

    public void setDeletable(boolean deletable) {
        this.isDeletable = deletable;
    }

    public boolean isPathLegEnd() {
        return this.type != PointType.INLINE;
    }

    public boolean isEnd() {
        return this.type == PointType.END;
    }

    public boolean isTurn() {
        return this.type == PointType.TURN;
    }

    public boolean isInline() {
        return this.type == PointType.INLINE;
    }

    public boolean asPathLegEnd() {
        return this.isPathLegEnd() || this.getNext() == null || this.getPrevious() == null;
    }

    public boolean isDirected() {
        return this.isFixed && this.isEnd();
    }

    public boolean isNonDirected() {
        return !this.isFixed && this.isEnd();
    }

    public boolean isVariableLength() {
        return !this.isFixed && this.isInline();
    }

    public boolean isFixedLength() {
        return this.isFixed && this.isInline();
    }

    public boolean isVariableAngle() {
        return !this.isFixed && this.isTurn();
    }

    public boolean isFixedAngle() {
        return this.isFixed && this.isTurn();
    }

    public boolean asFixedAngle() {
        return this.isTurn() && (this.isFixed || this.next == null || this.previous == null);
    }

    public boolean isBranchEnd() {
        return this.isDeletable && this.isEnd();
    }

    public boolean isOffset() {
        return this.offset != null;
    }

    public boolean isDualSub() {
        return this.parent != null && this.isSub;
    }

    public boolean isDualInline() {
        return this.children.size() == 1 && this.children.get(0).isDualSub();
    }

    public boolean isAxial() {
        return this.isInline() && !this.isDualInline();
    }

    public boolean isSizeChange() {
        return this.isSizeChange;
    }

    public void setSizeChange(boolean isSizeChange) {
        this.isSizeChange = isSizeChange;
    }

    public PipeControlPoint getNext() {
        return this.next;
    }

    public PipeControlPoint getPrevious() {
        return this.previous;
    }

    public void setNext(PipeControlPoint next) {
        if (this.isSub) {
            if (this.getParentPoint() != null) {
                this.getParentPoint().setNext(next);
            }
            return;
        }
        if (next != null && next.isDualSub()) {
            next = next.parent;
        }
        if (this._setNext(next)) {
            for (PipeControlPoint pcp : this.children) {
                if (!pcp.isSub) continue;
                pcp._setNext(next);
            }
            this.updateSubPoint();
        }
    }

    public void setPrevious(PipeControlPoint prev) {
        if (this.isSub) {
            if (this.getParentPoint() != null) {
                this.getParentPoint().setPrevious(prev);
            }
            return;
        }
        if (prev != null && prev.isDualInline()) {
            prev = prev.children.get(0);
        }
        if (this._setPrevious(prev)) {
            for (PipeControlPoint pcp : this.children) {
                if (!pcp.isSub) continue;
                pcp._setPrevious(prev);
            }
            this.updateSubPoint();
        }
    }

    protected boolean _setNext(PipeControlPoint next) {
        if (this.isEnd() && this.previous != null && next != null) {
            throw new RuntimeException("End control points are allowed to have only one connection");
        }
        if (next == this) {
            throw new RuntimeException("Cannot connect to self");
        }
        if (this.next == next) {
            return false;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + " next " + String.valueOf(next));
        }
        if (next == null && this.isVariableAngle() && this.previous != null && !this.isRemoved()) {
            this.convertVariableAngleToFixed(Direction.NEXT);
        }
        this.next = next;
        if (this.component != null) {
            PipelineComponent nextComp;
            PipelineComponent pipelineComponent = nextComp = next != null ? next.component : null;
            if (this.parent == null || this.isSub) {
                if (this.component.getNext() != nextComp) {
                    this.component.setNext(nextComp);
                }
            } else if (this.component.getBranch0() != nextComp) {
                this.component.setBranch0(nextComp);
            }
        }
        return true;
    }

    protected boolean _setPrevious(PipeControlPoint previous) {
        if (this.isEnd() && this.next != null && previous != null) {
            throw new RuntimeException("End control points are allowed to have only one connection");
        }
        if (previous == this) {
            throw new RuntimeException("Cannot connect to self");
        }
        if (this.previous == previous) {
            return false;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + " previous " + String.valueOf(previous));
        }
        if (previous == null && this.isVariableAngle() && this.next != null && !this.isRemoved()) {
            this.convertVariableAngleToFixed(Direction.PREVIOUS);
        }
        this.previous = previous;
        if (this.component != null) {
            PipelineComponent prevComp;
            PipelineComponent pipelineComponent = prevComp = previous != null ? previous.component : null;
            if (this.parent == null || this.isSub) {
                if (this.component.getPrevious() != prevComp) {
                    this.component.setPrevious(prevComp);
                }
            } else if (this.component.getBranch0() != prevComp) {
                this.component.setBranch0(prevComp);
            }
            this.updateSubPoint();
        }
        return true;
    }

    private boolean convertVariableAngleToFixed(Direction direction) {
        Vector3d dirOut = this.getPathLegDirection(direction == Direction.NEXT ? Direction.NEXT : Direction.PREVIOUS);
        Vector3d dir = this.getPathLegDirection(direction == Direction.NEXT ? Direction.PREVIOUS : Direction.NEXT);
        if (dir == null || dirOut == null) {
            return false;
        }
        dir.negate();
        double angle = dir.angle(dirOut);
        if (direction == Direction.NEXT) {
            this.next = null;
        } else {
            this.previous = null;
        }
        Double rot = this.getRotationAngle();
        Boolean reversed = this.getReversed();
        this.setRotationAngle(0.0);
        this.setReversed(direction != Direction.NEXT);
        Vector3d dirOutN = this.getPathLegDirection(direction == Direction.NEXT ? Direction.NEXT : Direction.PREVIOUS);
        if (dirOutN == null) {
            this.setRotationAngle(rot);
            this.setReversed(reversed);
            return false;
        }
        dirOutN.normalize();
        AxisAngle4d aa = new AxisAngle4d();
        if (MathTools.createRotation((Vector3d)dirOutN, (Vector3d)dirOut, (Vector3d)dir, (AxisAngle4d)aa)) {
            this.setRotationAngle(aa.angle);
            this.setTurnAngle(angle);
            if (DEBUG) {
                System.out.println("convertToFixed " + String.valueOf((Object)direction) + " dir " + String.valueOf(dir) + " out " + String.valueOf(dirOut) + " N " + String.valueOf(dirOutN) + " rot " + angle + " turn " + aa.angle);
            }
            return true;
        }
        return false;
    }

    public List<PipeControlPoint> getChildPoints() {
        return this.children;
    }

    public PipeControlPoint getParentPoint() {
        return this.parent;
    }

    @GetPropertyValue(name="Length", tabId="Debug", value="length")
    public double getLength() {
        return this.length;
    }

    public void setLength(double l) {
        if (this.length == l) {
            return;
        }
        if (Double.isInfinite(l) || Double.isNaN(l)) {
            return;
        }
        if (Math.abs(this.length - l) < MathTools.NEAR_ZERO) {
            return;
        }
        this.length = l;
        this.firePropertyChanged("length");
        if (this.isDualInline()) {
            this.getDualSub().setLength(l);
        }
    }

    @GetPropertyValue(name="Turn Angle", tabId="Debug", value="turnAngle")
    public Double getTurnAngle() {
        return this.turnAngle;
    }

    @GetPropertyValue(name="Turn Axis", tabId="Debug", value="turnAxis")
    public Vector3d getTurnAxis() {
        return this.turnAxis;
    }

    @GetPropertyValue(name="Offset", tabId="Debug", value="offset")
    public Double getOffset() {
        return this.offset;
    }

    @GetPropertyValue(name="Rotation Angle", tabId="Debug", value="rotationAngle")
    public Double getRotationAngle() {
        if (this.isRotate || this.asFixedAngle()) {
            return this.rotationAngle;
        }
        return null;
    }

    @GetPropertyValue(name="Reversed", tabId="Debug", value="reversed")
    public Boolean getReversed() {
        return this.reversed;
    }

    public boolean _getReversed() {
        if (this.reversed == null) {
            return false;
        }
        return this.reversed;
    }

    public void setTurnAngle(Double turnAngle) {
        if (turnAngle == null || Double.isInfinite(turnAngle) || Double.isNaN(turnAngle)) {
            return;
        }
        if (this.turnAngle != null && Math.abs(this.turnAngle - turnAngle) < MathTools.NEAR_ZERO) {
            return;
        }
        if (Objects.equals(this.turnAngle, turnAngle)) {
            return;
        }
        this.turnAngle = turnAngle;
        this.firePropertyChanged("turnAngle");
    }

    public void setTurnAxis(Vector3d turnAxis) {
        if (this.turnAxis != null && MathTools.equals((Tuple3d)turnAxis, (Tuple3d)this.turnAxis)) {
            return;
        }
        this.turnAxis = turnAxis;
        this.firePropertyChanged("turnAxis");
    }

    public void setOffset(Double offset) {
        if (Double.isInfinite(offset) || Double.isNaN(offset)) {
            return;
        }
        if (this.offset != null && Math.abs(this.offset - offset) < MathTools.NEAR_ZERO) {
            return;
        }
        if (Objects.equals(this.offset, offset)) {
            return;
        }
        this.offset = offset;
        this.firePropertyChanged("offset");
    }

    public void setRotationAngle(Double rotationAngle) {
        if (Double.isInfinite(rotationAngle) || Double.isNaN(rotationAngle)) {
            return;
        }
        if (this.rotationAngle != null && Math.abs(this.rotationAngle - rotationAngle) < MathTools.NEAR_ZERO) {
            return;
        }
        if (Objects.equals(this.rotationAngle, rotationAngle)) {
            return;
        }
        this.rotationAngle = rotationAngle;
        this.firePropertyChanged("rotationAngle");
    }

    public void setReversed(Boolean reversed) {
        if (this.reversed == reversed) {
            return;
        }
        this.reversed = reversed;
        this.firePropertyChanged("reversed");
    }

    public Vector3d getSizeChangeOffsetVector(Vector3d dir) {
        return this.getSizeChangeOffsetVector(dir, null);
    }

    public Vector3d getSizeChangeOffsetVector(Vector3d dir, Vector3d leg) {
        Quat4d q = this.rotationAngle == null ? this.getControlPointOrientationQuatWithLeg(dir, leg, 0.0) : this.getControlPointOrientationQuatWithLeg(dir, leg, this.rotationAngle);
        Vector3d v = new Vector3d(0.0, -this.offset.doubleValue(), 0.0);
        Vector3d offset = new Vector3d();
        MathTools.rotate((Quat4d)q, (Tuple3d)v, (Tuple3d)offset);
        return offset;
    }

    public Vector3d getSizeChangeOffsetVector() {
        Quat4d q = this.getOrientation();
        Vector3d v = new Vector3d(0.0, -this.offset.doubleValue(), 0.0);
        Vector3d offset = new Vector3d();
        MathTools.rotate((Quat4d)q, (Tuple3d)v, (Tuple3d)offset);
        return offset;
    }

    @GetPropertyValue(name="Next", tabId="Debug", value="next")
    private String getNextString() {
        if (this.next == null) {
            return null;
        }
        return this.next.toString();
    }

    @GetPropertyValue(name="Previous", tabId="Debug", value="previous")
    private String getPrevString() {
        if (this.previous == null) {
            return null;
        }
        return this.previous.toString();
    }

    @GetPropertyValue(name="Sub", tabId="Debug", value="sub")
    private String getSubString() {
        if (this.children.size() == 0) {
            return "";
        }
        return Arrays.toString(this.children.toArray());
    }

    @GetPropertyValue(name="Type", tabId="Debug", value="type")
    public String getTypeString() {
        return this.type.name();
    }

    public Vector3d getPathLegDirection() {
        if (this.turnAxis == null) {
            return this.getPathLegDirection(Direction.NEXT);
        }
        Vector3d dir = this.getPathLegDirection(Direction.PREVIOUS);
        if (dir != null) {
            dir.negate();
        }
        return dir;
    }

    @Deprecated
    public Quat4d getControlPointOrientationQuat(double angle) {
        Vector3d dir = this.getPathLegDirection();
        if (this.turnAxis == null) {
            return this.getControlPointOrientationQuat(dir, angle);
        }
        return PipeControlPoint.getControlPointOrientationQuat(dir, this.turnAxis, angle);
    }

    public Quat4d getControlPointOrientationQuat(Vector3d dir, Vector3d leg, double angle, boolean reversed) {
        if (this.turnAxis == null) {
            if (dir.lengthSquared() > MathTools.NEAR_ZERO) {
                dir.normalize();
            }
            Quat4d q = this.getControlPointOrientationQuatWithLeg(dir, leg, angle);
            if (reversed) {
                Quat4d q2 = new Quat4d();
                q2.set(new AxisAngle4d(MathTools.Y_AXIS, Math.PI));
                q.mulInverse(q2);
            }
            return q;
        }
        if (dir.lengthSquared() > MathTools.NEAR_ZERO) {
            dir.normalize();
        }
        return PipeControlPoint.getControlPointOrientationQuat(dir, this.turnAxis, angle);
    }

    public Quat4d getControlPointOrientationQuat(double angle, boolean reversed) {
        Vector3d dir = this.getPathLegDirection();
        return this.getControlPointOrientationQuat(dir, null, angle, reversed);
    }

    public Quat4d getControlPointOrientationQuat(Vector3d dir, double angle) {
        return this.getControlPointOrientationQuatWithLeg(dir, null, angle);
    }

    public Vector3d getUp() {
        P3DRootNode root = this.getRoot();
        Vector3d up = root != null ? new Vector3d(root.getUpVector()) : new Vector3d(0.0, 1.0, 0.0);
        return up;
    }

    public Quat4d getControlPointOrientationQuatWithLeg(Vector3d dir, Vector3d legDir, double angle) {
        if (dir == null || dir.lengthSquared() < MathTools.NEAR_ZERO) {
            return MathTools.getIdentityQuat();
        }
        Vector3d up = this.getUp();
        if (legDir == null) {
            double a = up.angle(dir);
            if (a < 0.1 || Math.PI - a < 0.1) {
                up.set(up.getY(), up.getZ(), up.getX());
            }
            return PipeControlPoint.getControlPointOrientationQuat(dir, up, angle);
        }
        double a = up.angle(legDir);
        if (a < 0.1 || Math.PI - a < 0.1) {
            up.set(up.getY(), up.getZ(), up.getX());
        }
        MathTools.mad((Tuple3d)up, (Tuple3d)legDir, (double)(-legDir.dot(up) / legDir.lengthSquared()));
        up.normalize();
        return PipeControlPoint.getControlPointOrientationQuat(dir, up, angle);
    }

    public P3DRootNode getRoot() {
        ParentNode n = this.getParent();
        while (n != null && !(n instanceof P3DRootNode)) {
            n = n.getParent();
        }
        return (P3DRootNode)n;
    }

    public static Quat4d getControlPointOrientationQuat(Vector3d dir, Vector3d up, double angle) {
        if (dir == null || dir.lengthSquared() < MathTools.NEAR_ZERO) {
            return MathTools.getIdentityQuat();
        }
        Vector3d front = new Vector3d(1.0, 0.0, 0.0);
        Quat4d q1 = new Quat4d();
        Vector3d right = new Vector3d();
        up = new Vector3d(up);
        right.cross(dir, up);
        up.cross(right, dir);
        right.normalize();
        up.normalize();
        Matrix3d m = new Matrix3d();
        m.m00 = dir.x;
        m.m10 = dir.y;
        m.m20 = dir.z;
        m.m01 = up.x;
        m.m11 = up.y;
        m.m21 = up.z;
        m.m02 = right.x;
        m.m12 = right.y;
        m.m22 = right.z;
        MathTools.getQuat((Matrix3d)m, (Quat4d)q1);
        Quat4d q2 = new Quat4d();
        q2.set(new AxisAngle4d(front, angle));
        q1.mul(q2);
        return q1;
    }

    public void insert(PipeControlPoint previous, PipeControlPoint next) {
        if (this.isDualSub()) {
            throw new RuntimeException("Dual sub points cannot be inserted.");
        }
        PipeRun piperun = previous.getPipeRun();
        if (this.getPipeRun() != null) {
            if (piperun != this.getPipeRun() || piperun != next.getPipeRun()) {
                throw new RuntimeException("All controls points must be located on the same pipe run");
            }
        } else {
            piperun.addChild(this);
        }
        PipeControlPoint previousNext = previous.getNext();
        PipeControlPoint previousPrevious = previous.getPrevious();
        PipeControlPoint offsetCP = null;
        if (this.isOffset()) {
            offsetCP = this.getDualSub();
        }
        if (previousNext != null && previousNext == next) {
            if (previous.isDualInline()) {
                throw new RuntimeException();
            }
            if (next.isDualSub()) {
                throw new RuntimeException();
            }
            previous.setNext(this);
            this.setPrevious(previous);
            if (previous.isDualSub()) {
                previous.getParentPoint().setNext(this);
            }
            this.setNext(next);
            if (offsetCP == null) {
                next.setPrevious(this);
            } else {
                next.setPrevious(offsetCP);
                offsetCP.setNext(next);
                offsetCP.setPrevious(previous);
            }
            if (next.isDualInline()) {
                next.getDualSub().setPrevious(this);
            }
        } else if (previousPrevious != null && previousPrevious == next) {
            if (next.isDualInline()) {
                throw new RuntimeException();
            }
            if (previous.isDualSub()) {
                throw new RuntimeException();
            }
            this.setNext(previous);
            if (offsetCP == null) {
                previous.setNext(this);
            } else {
                previous.setPrevious(offsetCP);
                offsetCP.setNext(previous);
                offsetCP.setPrevious(next);
            }
            if (previous.isDualInline()) {
                previous.getDualSub().setPrevious(this);
            }
            this.setPrevious(next);
            next.setNext(this);
            if (next.isDualSub()) {
                next.getParentPoint().setNext(this);
            }
        } else {
            throw new RuntimeException();
        }
        this.getRoot().validate(piperun);
    }

    public void insert(PipeControlPoint pcp, Direction direction) {
        if (this.isDualSub()) {
            throw new RuntimeException();
        }
        if (direction == Direction.NEXT) {
            if (pcp.isDualInline()) {
                throw new RuntimeException();
            }
            pcp.setNext(this);
            this.setPrevious(pcp);
            if (pcp.isDualSub()) {
                pcp.getParentPoint().setNext(this);
            }
        } else {
            if (pcp.isDualSub()) {
                throw new RuntimeException();
            }
            PipeControlPoint nocp = null;
            if (this.isDualInline()) {
                nocp = this.getDualSub();
                nocp.setNext(pcp);
            }
            if (nocp == null) {
                pcp.setPrevious(this);
            } else {
                pcp.setPrevious(nocp);
            }
            this.setNext(pcp);
            if (pcp.isDualInline()) {
                PipeControlPoint ocp = pcp.getDualSub();
                if (nocp == null) {
                    ocp.setPrevious(this);
                } else {
                    ocp.setPrevious(nocp);
                }
            }
        }
        this.getRoot().validate(this.getPipeRun());
    }

    public Vector3d getDirectedControlPointDirection() {
        assert (this.isDirected());
        Vector3d dir = new Vector3d();
        MathTools.rotate((Quat4d)this.getWorldOrientation(), (Tuple3d)new Vector3d(1.0, 0.0, 0.0), (Tuple3d)dir);
        dir.normalize();
        return dir;
    }

    public Vector3d getDirection(Direction direction) {
        if (this.isDirected()) {
            return this.getDirectedControlPointDirection();
        }
        if (this.isTurn() && this.asFixedAngle()) {
            if (direction == Direction.NEXT) {
                if (this.previous != null) {
                    PipeControlPoint pcp = this;
                    Vector3d dir = new Vector3d();
                    dir.sub((Tuple3d)pcp.getWorldPosition(), (Tuple3d)this.previous.getWorldPosition());
                    if (!(dir.lengthSquared() > MathTools.NEAR_ZERO)) {
                        return null;
                    }
                    dir.normalize();
                    Quat4d q = this.getControlPointOrientationQuat(dir, pcp.getRotationAngle() != null ? pcp.getRotationAngle() : 0.0);
                    AxisAngle4d aa = new AxisAngle4d(MathTools.Y_AXIS, pcp.getTurnAngle() == null ? 0.0 : pcp.getTurnAngle());
                    Quat4d q2 = MathTools.getQuat((AxisAngle4d)aa);
                    Vector3d v = new Vector3d(1.0, 0.0, 0.0);
                    Vector3d offset = new Vector3d();
                    MathTools.rotate((Quat4d)q2, (Tuple3d)v, (Tuple3d)offset);
                    MathTools.rotate((Quat4d)q, (Tuple3d)offset, (Tuple3d)dir);
                    dir.normalize();
                    return dir;
                }
            } else if (this.next != null) {
                PipeControlPoint pcp = this;
                Vector3d dir = new Vector3d();
                dir.sub((Tuple3d)this.next.getWorldPosition(), (Tuple3d)pcp.getWorldPosition());
                if (!(dir.lengthSquared() > MathTools.NEAR_ZERO)) {
                    return null;
                }
                dir.normalize();
                Quat4d q = this.getControlPointOrientationQuat(dir, pcp.getRotationAngle() != null ? pcp.getRotationAngle() : 0.0);
                AxisAngle4d aa = new AxisAngle4d(MathTools.Y_AXIS, pcp.getTurnAngle() == null ? 0.0 : pcp.getTurnAngle());
                Quat4d q2 = MathTools.getQuat((AxisAngle4d)aa);
                Vector3d v = new Vector3d(1.0, 0.0, 0.0);
                Vector3d offset = new Vector3d();
                MathTools.rotate((Quat4d)q2, (Tuple3d)v, (Tuple3d)offset);
                MathTools.rotate((Quat4d)q, (Tuple3d)offset, (Tuple3d)dir);
                dir.negate();
                dir.normalize();
                return dir;
            }
        }
        return null;
    }

    public Vector3d getPathLegDirection(Direction direction) {
        if (direction == Direction.NEXT) {
            return this.getPathLegDirectionNext();
        }
        return this.getPathLegDirectionPrevious();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector3d getPathLegDirectionPrevious() {
        if (this.previous != null) {
            PipeControlPoint pcp = this;
            if (this.isDualSub()) {
                pcp = this.getParentPoint();
            }
            Vector3d v = new Vector3d();
            v.sub((Tuple3d)this.previous.getWorldPosition(), (Tuple3d)pcp.getWorldPosition());
            if (v.lengthSquared() > MathTools.NEAR_ZERO) {
                v.normalize();
                return v;
            } else {
                if (this.next == null) return null;
                v.sub((Tuple3d)pcp.getWorldPosition(), (Tuple3d)this.next.getWorldPosition());
                if (!(v.lengthSquared() > MathTools.NEAR_ZERO)) return null;
                v.normalize();
            }
            return v;
        }
        if (this.isDirected()) {
            Vector3d v = this.getDirectedControlPointDirection();
            v.negate();
            return v;
        }
        if (this.next == null) {
            throw new RuntimeException("Cannot calculate path leg direction for unconnected control point " + String.valueOf(this));
        }
        if (this.isVariableAngle() && !this.asFixedAngle()) {
            throw new RuntimeException("Cannot calculate path leg direction for unconnected variable angle control point " + String.valueOf(this));
        }
        if (this.isInline() || this.isEnd()) {
            Vector3d v = this.getPathLegDirectionNext();
            if (v == null) return v;
            v.negate();
            return v;
        }
        if (!this.isTurn() || !this.asFixedAngle() || !this._getReversed()) return null;
        return this.getDirection(Direction.PREVIOUS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector3d getPathLegDirectionNext() {
        if (this.next != null) {
            PipeControlPoint pcp = this;
            if (pcp.isDualInline()) {
                pcp = pcp.getDualSub();
            }
            Vector3d v = new Vector3d();
            v.sub((Tuple3d)this.next.getWorldPosition(), (Tuple3d)pcp.getWorldPosition());
            if (v.lengthSquared() > MathTools.NEAR_ZERO) {
                v.normalize();
                return v;
            } else {
                if (this.previous == null) return null;
                v.sub((Tuple3d)pcp.getWorldPosition(), (Tuple3d)this.previous.getWorldPosition());
                if (!(v.lengthSquared() > MathTools.NEAR_ZERO)) return null;
                v.normalize();
            }
            return v;
        }
        if (this.isDirected()) {
            return this.getDirectedControlPointDirection();
        }
        if (this.previous == null) {
            throw new RuntimeException("Cannot calculate path leg direction for unconnected control point " + String.valueOf(this));
        }
        if (this.isVariableAngle() && !this.asFixedAngle()) {
            throw new RuntimeException("Cannot calculate path leg direction for unconnected variable angle control point " + String.valueOf(this));
        }
        if (this.isInline() || this.isEnd()) {
            Vector3d v = this.getPathLegDirectionPrevious();
            if (v == null) return v;
            v.negate();
            return v;
        }
        if (!this.isTurn() || !this.asFixedAngle() || this._getReversed()) return null;
        return this.getDirection(Direction.NEXT);
    }

    public void getInlineControlPointEnds(Tuple3d p1, Tuple3d p2) {
        assert (this.isInline());
        PipeControlPoint sub = this.isAxial() ? this : this.getDualSub();
        Vector3d pos = this.getWorldPosition();
        Vector3d pos2 = sub == this ? pos : sub.getWorldPosition();
        Vector3d dir = sub.getInlineDir();
        dir.scale(this.length * 0.5);
        p1.set((Tuple3d)pos);
        p2.set((Tuple3d)pos2);
        p1.sub((Tuple3d)dir);
        p2.add((Tuple3d)dir);
    }

    public void getControlPointEnds(Tuple3d p1, Tuple3d p2) {
        Vector3d dir1;
        Vector3d dir2;
        Vector3d pos2;
        PipeControlPoint sub = this.isAxial() || this.isDirected() || this.isTurn() ? this : this.getChildPoints().get(0);
        Vector3d pos = this.getWorldPosition();
        Vector3d vector3d = pos2 = sub == this ? pos : sub.getWorldPosition();
        if (this.isInline()) {
            dir2 = this.getInlineDir();
            dir2.scale(this.length * 0.5);
            dir1 = new Vector3d(dir2);
            dir1.negate();
        } else if (this.isEnd()) {
            dir2 = dir1 = new Vector3d();
        } else {
            dir1 = this.getPathLegDirection(Direction.PREVIOUS);
            dir2 = sub.getPathLegDirection(Direction.NEXT);
            if (dir1 != null) {
                dir1.scale(this.length);
            } else {
                dir1 = new Vector3d();
            }
            if (dir2 != null) {
                dir2.scale(this.length);
            } else {
                dir2 = new Vector3d();
            }
        }
        p1.set((Tuple3d)pos);
        p2.set((Tuple3d)pos2);
        p1.add((Tuple3d)dir1);
        p2.add((Tuple3d)dir2);
    }

    public void getEndDirections(Tuple3d v1, Tuple3d v2) {
        PipeControlPoint sub = this.isAxial() ? this : this.getDualSub();
        Vector3d dir1 = this.getPathLegDirection(Direction.PREVIOUS);
        Vector3d dir2 = sub.getPathLegDirection(Direction.NEXT);
        if (dir1 != null) {
            v1.set((Tuple3d)dir1);
        } else {
            v1.set(0.0, 0.0, 0.0);
        }
        if (dir2 != null) {
            v2.set((Tuple3d)dir2);
        } else {
            v2.set(0.0, 0.0, 0.0);
        }
    }

    public void getInlineControlPointEnds(Tuple3d p1, Tuple3d p2, Vector3d dir) {
        assert (this.isInline());
        Vector3d pos = this.getWorldPosition();
        dir.set((Tuple3d)this.getInlineDir());
        dir.normalize();
        dir.scale(this.length * 0.5);
        p1.set((Tuple3d)pos);
        p2.set((Tuple3d)pos);
        p1.sub((Tuple3d)dir);
        p2.add((Tuple3d)dir);
    }

    public void getInlineControlPointEnds(Tuple3d center, Tuple3d p1, Tuple3d p2, Vector3d dir) {
        assert (this.isInline());
        Vector3d pos = this.getWorldPosition();
        center.set((Tuple3d)pos);
        dir.set((Tuple3d)this.getInlineDir());
        dir.normalize();
        dir.scale(this.length * 0.5);
        p1.set((Tuple3d)pos);
        p2.set((Tuple3d)pos);
        p1.sub((Tuple3d)dir);
        p2.add((Tuple3d)dir);
    }

    public Vector3d getInlineDir() {
        Vector3d dir = this.getPathLegDirection(Direction.NEXT);
        if (dir == null) {
            dir = this.getPathLegDirection(Direction.PREVIOUS);
            if (dir != null) {
                dir.scale(-1.0);
            } else {
                dir = new Vector3d(1.0, 0.0, 0.0);
                MathTools.rotate((Quat4d)this.getWorldOrientation(), (Tuple3d)dir, (Tuple3d)dir);
            }
        }
        return dir;
    }

    public double getInlineLength() {
        if (this.type == PointType.TURN) {
            return this.length;
        }
        if (this.type == PointType.INLINE) {
            return this.length * 0.5;
        }
        return 0.0;
    }

    public Vector3d getRealPosition(PositionType type) {
        Vector3d pos = this.getWorldPosition();
        switch (type) {
            case NEXT: {
                double length = this.getInlineLength();
                Vector3d dir = this.isInline() ? this.getInlineDir() : this.getPathLegDirection(Direction.NEXT);
                dir.scale(length);
                pos.add((Tuple3d)dir);
                break;
            }
            case PREVIOUS: {
                Vector3d dir;
                double length = this.getInlineLength();
                if (this.isInline()) {
                    dir = this.getInlineDir();
                    dir.negate();
                } else {
                    dir = this.getPathLegDirection(Direction.PREVIOUS);
                }
                dir.scale(length);
                pos.add((Tuple3d)dir);
                break;
            }
            case PORT: {
                break;
            }
        }
        return pos;
    }

    public void getInlineMovement(Tuple3d start, Tuple3d end) {
        PipeControlPoint p = this.previous.getPrevious();
        PipeControlPoint n = this.next.getNext();
        start.set((Tuple3d)p.getWorldPosition());
        end.set((Tuple3d)n.getWorldPosition());
    }

    public PipeControlPoint findNextEnd() {
        ArrayList<PipeControlPoint> t = new ArrayList<PipeControlPoint>();
        return this.findNextEnd(t);
    }

    public PipeControlPoint findPreviousEnd() {
        ArrayList<PipeControlPoint> t = new ArrayList<PipeControlPoint>();
        return this.findPreviousEnd(t);
    }

    public PipeControlPoint findNextEnd(List<PipeControlPoint> nextList) {
        while (true) {
            PipeControlPoint pcp = null;
            PipeControlPoint p = null;
            p = nextList.size() == 0 ? this : nextList.get(nextList.size() - 1);
            pcp = p.getNext();
            if (pcp == null) {
                pcp = p;
                if (nextList.size() > 0) {
                    nextList.remove(nextList.size() - 1);
                }
                return pcp;
            }
            if (pcp.isPathLegEnd()) {
                return pcp;
            }
            nextList.add(pcp);
        }
    }

    public PipeControlPoint findPreviousEnd(List<PipeControlPoint> prevList) {
        while (true) {
            PipeControlPoint pcp = null;
            PipeControlPoint p = null;
            p = prevList.size() == 0 ? this : prevList.get(prevList.size() - 1);
            pcp = p.getPrevious();
            if (pcp == null) {
                pcp = p;
                if (prevList.size() > 0) {
                    prevList.remove(prevList.size() - 1);
                }
                return pcp;
            }
            if (pcp.isPathLegEnd()) {
                return pcp;
            }
            prevList.add(pcp);
        }
    }

    public void _remove() {
        this._remove(true);
    }

    public PipeControlPoint getDualSub() {
        if (this.isDualInline()) {
            return this.getChildPoints().get(0);
        }
        throw new IllegalStateException("Current control point is not dual inline");
    }

    public void _remove(boolean renconnect) {
        if (this.disposed) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this) + " Remove " + renconnect);
        }
        this.disposed = true;
        if (this.getParentPoint() != null) {
            this.getParentPoint()._remove(renconnect);
            return;
        }
        PipeRun pipeRun = this.getPipeRun();
        P3DRootNode root = this.getRoot();
        PipeControlPoint additionalRemove = null;
        if (root == null || !root.isPipingRulesEnabled()) {
            this.component = null;
            this.setPrevious(null);
            this.setNext(null);
        } else {
            PipeControlPoint currentPrev = this.previous;
            PipeControlPoint currentNext = this.next;
            if (currentNext == null && currentPrev == null) {
                this.removeComponent();
                if (pipeRun != null) {
                    pipeRun.remChild(this);
                    this.checkRemove(pipeRun);
                }
                return;
            }
            if (currentNext != null && currentPrev != null) {
                boolean link = renconnect;
                if (currentNext.isBranchEnd()) {
                    link = false;
                    currentNext.remove();
                    currentNext = null;
                    this.setNext(null);
                }
                if (currentPrev.isBranchEnd()) {
                    link = false;
                    currentPrev.remove();
                    currentPrev = null;
                    this.setPrevious(null);
                }
                if (link && this.isDualSub()) {
                    throw new RuntimeException("_remove() is called for parent point, somehow got to child point. " + String.valueOf(this));
                }
                if (currentNext != null) {
                    if (currentNext.isDualInline()) {
                        PipeControlPoint sccp = currentNext;
                        PipeControlPoint ocp = currentNext.getDualSub();
                        if (ocp == null) {
                            throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, no offset control point");
                        }
                        if (link) {
                            sccp.setPrevious(currentPrev);
                            assert (ocp.getPrevious() == currentPrev);
                        } else {
                            sccp.setPrevious(null);
                            assert (ocp.getPrevious() == null);
                        }
                        this.setNext(null);
                    } else {
                        if (currentNext.isDualSub()) {
                            throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, next control point is offset control point");
                        }
                        if (currentNext.previous == this) {
                            if (link) {
                                currentNext.setPrevious(currentPrev);
                            } else {
                                currentNext.setPrevious(null);
                            }
                            this.setNext(null);
                        } else if (this.isDualInline()) {
                            if (currentNext.previous != this.getDualSub()) {
                                throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged");
                            }
                            if (link) {
                                currentNext.setPrevious(currentPrev);
                            } else {
                                currentNext.setPrevious(null);
                            }
                            this.setNext(null);
                        } else {
                            throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged");
                        }
                    }
                }
                if (currentPrev != null) {
                    if (currentPrev.isDualInline()) {
                        throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, previous control point is size change control point");
                    }
                    if (currentPrev.isDualSub()) {
                        PipeControlPoint ocp = currentPrev;
                        PipeControlPoint sccp = currentPrev.getParentPoint();
                        if (sccp == null) {
                            throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, no size change control point");
                        }
                        if (link) {
                            sccp.setNext(currentNext);
                            assert (ocp.getNext() == currentNext);
                        } else {
                            sccp.setNext(null);
                            assert (ocp.getNext() == null);
                        }
                        this.setPrevious(null);
                    } else if (currentPrev.next == this) {
                        if (link) {
                            currentPrev.setNext(currentNext);
                        } else {
                            currentPrev.setNext(null);
                        }
                        this.setPrevious(null);
                    } else {
                        throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged");
                    }
                }
                if (link && currentNext.isVariableLength() && currentPrev.isVariableLength()) {
                    additionalRemove = currentPrev;
                    Point3d ps = new Point3d();
                    Point3d pe = new Point3d();
                    Point3d ns = new Point3d();
                    Point3d ne = new Point3d();
                    currentPrev.getInlineControlPointEnds((Tuple3d)ps, (Tuple3d)pe);
                    currentNext.getInlineControlPointEnds((Tuple3d)ns, (Tuple3d)ne);
                    double l = currentPrev.getLength() + currentNext.getLength();
                    Vector3d cp = new Vector3d();
                    cp.add((Tuple3d)ps, (Tuple3d)ne);
                    cp.scale(0.5);
                    currentNext.setLength(l);
                    currentNext.setWorldPosition(cp);
                }
            } else if (currentNext != null) {
                if (currentNext.isDualInline()) {
                    PipeControlPoint sccp = currentNext;
                    PipeControlPoint ocp = currentNext.getDualSub();
                    if (ocp == null) {
                        throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, no offset control point");
                    }
                    sccp.setPrevious(null);
                    assert (ocp.getPrevious() == null);
                } else {
                    if (currentNext.isDualSub()) {
                        throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, next control point is offset control point");
                    }
                    if (currentNext.previous == this) {
                        currentNext.setPrevious(null);
                    } else if (this.isDualInline()) {
                        if (currentNext.previous != this.getDualSub()) {
                            throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged");
                        }
                        currentNext.setPrevious(null);
                    } else {
                        throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged");
                    }
                }
                this.setNext(null);
            } else {
                if (currentPrev.isDualInline()) {
                    throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, previous control point is size change control point");
                }
                if (currentPrev.isDualSub()) {
                    PipeControlPoint ocp = currentPrev;
                    PipeControlPoint sccp = currentPrev.getParentPoint();
                    if (sccp == null) {
                        throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged, no size change control point");
                    }
                    sccp.setNext(null);
                    assert (ocp.getNext() == null);
                } else if (currentPrev.next == this) {
                    currentPrev.setNext(null);
                } else {
                    throw new RuntimeException("Removing PipeControlPoint " + String.valueOf(this) + " structure damaged");
                }
                this.setPrevious(null);
            }
            if (this.children.size() > 0) {
                this.removeSubPoints();
            } else if (this.parent != null) {
                this.removeParentPoint();
            }
        }
        this.removeComponent();
        if (pipeRun != null) {
            pipeRun.remChild(this);
            this.checkRemove(pipeRun);
            if (root.isPipingRulesEnabled() && pipeRun.getParent() != null && pipeRun.getControlPoints().size() > 0) {
                root.validate(pipeRun);
            }
        }
        if (additionalRemove != null) {
            additionalRemove.remove();
        }
    }

    public void remove() {
        PipeControlPoint currentPrev = this.previous;
        PipeControlPoint currentNext = this.next;
        this._remove();
        try {
            if (currentNext != null && !currentNext.checkRemove()) {
                currentNext.requestUpdate();
            }
            if (currentPrev != null && !currentPrev.checkRemove()) {
                currentPrev.requestUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAndSplit() {
        PipeControlPoint currentPrev = this.previous;
        PipeControlPoint currentNext = this.next;
        if (this.next != null && this.previous != null) {
            P3DRootNode root = (P3DRootNode)this.getPipelineComponent().getRootNode();
            PipeRun nextPipeRun = new PipeRun();
            nextPipeRun.setName(root.getUniqueName("PipeRun"));
            root.addChild((INode)nextPipeRun);
            PipeRun previousRun = this.previous.getPipeRun();
            nextPipeRun.setPipeDiameter(previousRun.getPipeDiameter());
            nextPipeRun.setPipeThickness(previousRun.getPipeThickness());
            nextPipeRun.setTurnRadiusArray(previousRun.getTurnRadiusArray());
            PipelineComponent n = this.next.getPipelineComponent();
            while (n != null) {
                if (n.getPipeRun() != previousRun) break;
                if (!(n instanceof Nozzle)) {
                    n.deattach();
                    nextPipeRun.addChild(n);
                } else {
                    n.setPipeRun(nextPipeRun);
                }
                n = n.getNext();
            }
        }
        this._remove(false);
        try {
            if (currentNext != null && !currentNext.checkRemove()) {
                currentNext.requestUpdate();
            }
            if (currentPrev != null && !currentPrev.checkRemove()) {
                currentPrev.requestUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean checkRemove() {
        if (this.getParentPoint() != null) {
            return this.getParentPoint().checkRemove();
        }
        if (this.getPipelineComponent() == null) {
            return true;
        }
        if (this.getPipelineComponent().getType().equals("Plant3D.URIs.Builtin_BranchSplitComponent") && this.getChildPoints().get(0).getNext() == null && this.getChildPoints().get(0).getPrevious() == null) {
            this.remove();
            return true;
        }
        return this.checkRemove(this.getPipeRun());
    }

    private boolean checkRemove(PipeRun pipeRun) {
        if (pipeRun == null) {
            return false;
        }
        Collection<PipeControlPoint> points = pipeRun.getControlPoints();
        if (points.size() == 0) {
            pipeRun.remove();
            return true;
        }
        if (points.size() == 1) {
            PipeControlPoint pcp = points.iterator().next();
            if (pcp.isDeletable() && pcp.getNext() == null && pcp.getPrevious() == null) {
                pcp._remove();
                return true;
            }
        } else {
            points.size();
        }
        return false;
    }

    private void removeSubPoints() {
        for (PipeControlPoint p : this.children) {
            p.parent = null;
            p.component = null;
            PipeControlPoint currentNext = p.getNext();
            PipeControlPoint currentPrev = p.getPrevious();
            p._setNext(null);
            p._setPrevious(null);
            PipeRun run = p.getPipeRun();
            if (run != null) {
                run.remChild(p);
                this.checkRemove(run);
            }
            if (currentNext != null && !currentNext.checkRemove()) {
                currentNext.requestUpdate();
            }
            if (currentPrev == null || currentPrev.checkRemove()) continue;
            currentPrev.requestUpdate();
        }
        this.children.clear();
    }

    private void removeParentPoint() {
        throw new RuntimeException("Child points cannot be removed directly");
    }

    public boolean isRemoved() {
        return this.component == null || this.disposed;
    }

    private void removeComponent() {
        if (this.component == null) {
            return;
        }
        PipelineComponent next = this.component.getNext();
        PipelineComponent prev = this.component.getPrevious();
        PipelineComponent br0 = this.component.getBranch0();
        this.component.setNext(null);
        this.component.setPrevious(null);
        this.component.setBranch0(null);
        if (next != null) {
            if (next.getNext() == this.component) {
                next.setNext(null);
            } else if (next.getPrevious() == this.component) {
                next.setPrevious(null);
            } else if (next.getBranch0() == this.component) {
                next.setBranch0(null);
            }
        }
        if (prev != null) {
            if (prev.getNext() == this.component) {
                prev.setNext(null);
            } else if (prev.getPrevious() == this.component) {
                prev.setPrevious(null);
            } else if (prev.getBranch0() == this.component) {
                prev.setBranch0(null);
            }
        }
        if (br0 != null) {
            if (br0.getNext() == this.component) {
                br0.setNext(null);
            } else if (br0.getPrevious() == this.component) {
                br0.setPrevious(null);
            } else if (br0.getBranch0() == this.component) {
                br0.setBranch0(null);
            }
        }
        PipelineComponent comp = this.component;
        this.component = null;
        comp.remove();
    }

    public void setOrientation(Quat4d orientation) {
        if (MathTools.equals((Tuple4d)orientation, (Tuple4d)this.getOrientation())) {
            return;
        }
        super.setOrientation(orientation);
        if (this.getParentPoint() == null && this.component != null) {
            this.component._setWorldOrientation(this.getWorldOrientation());
        }
        this.updateSubPoint();
    }

    public void setPosition(Vector3d position) {
        if (MathTools.equals((Tuple3d)position, (Tuple3d)this.getPosition())) {
            return;
        }
        if (Double.isNaN(position.x) || Double.isNaN(position.y) || Double.isNaN(position.z)) {
            throw new IllegalArgumentException("NaN is not supported");
        }
        super.setPosition(position);
        if (this.getParentPoint() == null && this.component != null) {
            this.component._setWorldPosition(this.getWorldPosition());
        }
        this.updateSubPoint();
    }

    private void updateSubPoint() {
        if (this.isOffset()) {
            if (this.next == null && this.previous == null) {
                for (PipeControlPoint sub : this.getChildPoints()) {
                    sub.setWorldPosition(this.getWorldPosition());
                    sub.setWorldOrientation(this.getWorldOrientation());
                }
                return;
            }
            for (PipeControlPoint sub : this.getChildPoints()) {
                Vector3d wp = this.getWorldPosition();
                wp.add((Tuple3d)this.getSizeChangeOffsetVector());
                sub.setWorldPosition(wp);
                sub.setWorldOrientation(this.getWorldOrientation());
            }
        } else {
            for (PipeControlPoint sub : this.getChildPoints()) {
                sub.setWorldPosition(this.getWorldPosition());
                sub.setWorldOrientation(this.getWorldOrientation());
            }
        }
    }

    public void _setWorldPosition(Vector3d position) {
        Vector3d localPos = this.getLocalPosition(position);
        super.setPosition(localPos);
        this.updateSubPoint();
    }

    public void _setWorldOrientation(Quat4d orientation) {
        Quat4d localOr = this.getLocalOrientation(orientation);
        super.setOrientation(localOr);
        this.updateSubPoint();
    }

    public void orientToDirection(Vector3d dir) {
        this.orientToDirection(dir, null);
    }

    public void orientToDirection(Vector3d dir, Vector3d leg) {
        Double angleO = this.getRotationAngle();
        double angle = 0.0;
        if (angleO != null) {
            angle = angleO;
        }
        boolean reversed = this._getReversed();
        Quat4d q = null;
        q = dir != null ? this.getControlPointOrientationQuat(dir, leg, angle, reversed) : this.getControlPointOrientationQuat(angle, reversed);
        this.setWorldOrientation(q);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " " + String.valueOf(this.getPosition()) + " " + this.getTypeString();
    }

    public void requestUpdate() {
        P3DRootNode root = this.getRoot();
        if (root != null) {
            root.requestUpdate(this);
        }
    }

    public void positionUpdate() throws Exception {
        P3DRootNode root = this.getRoot();
        if (root != null) {
            root.positionUpdate(this);
        }
    }

    public void positionUpdate(boolean b) throws Exception {
        P3DRootNode root = this.getRoot();
        if (root != null) {
            root.positionUpdate(this, b);
        }
    }

    public static enum Direction {
        NEXT,
        PREVIOUS;

    }

    public static enum PointType {
        INLINE,
        TURN,
        END;

    }

    public static enum PositionType {
        SPLIT,
        NEXT,
        PREVIOUS,
        PORT;

    }
}

