/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.Collection;
import java.util.HashSet;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.NodeMapProvider;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeException;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.annotations.GraphType;
import org.simantics.objmap.graph.annotations.RelatedElementsAdd;
import org.simantics.objmap.graph.annotations.RelatedElementsGet;
import org.simantics.objmap.graph.annotations.RelatedElementsRem;
import org.simantics.plant3d.scenegraph.ColorSystem;
import org.simantics.plant3d.scenegraph.EndComponent;
import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.IColorSystem;
import org.simantics.plant3d.scenegraph.IP3DVisualNode;
import org.simantics.plant3d.scenegraph.InlineComponent;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.P3DParentNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import org.simantics.plant3d.scenegraph.controlpoint.PipingRules;

@GraphType(value="http://www.simantics.org/Plant3D-0.1/Plant")
public class P3DRootNode<T>
extends ParentNode<INode>
implements IG3DNode,
NodeMapProvider<Resource, T, INode> {
    protected Vector3d upVector = new Vector3d(0.0, 1.0, 0.0);
    private NodeMap<Resource, T, INode> nodeMap;
    private IMapping<Resource, INode> mapping;
    private PipingRules pipingRules = new PipingRules();
    private IColorSystem colorSystem;

    @RelatedElementsAdd(value="http://www.simantics.org/Plant3D-0.1/children")
    public void addChild(INode node) {
        this.addNode("http://www.simantics.org/Plant3D-0.1/children", node);
    }

    @RelatedElementsGet(value="http://www.simantics.org/Plant3D-0.1/children")
    public Collection<INode> getChild() {
        return this.getNodes("http://www.simantics.org/Plant3D-0.1/children");
    }

    @RelatedElementsRem(value="http://www.simantics.org/Plant3D-0.1/children")
    public void remChild(INode node) {
        this.removeNode("http://www.simantics.org/Plant3D-0.1/children", node);
    }

    public P3DRootNode() {
        this.pipingRules.setEnabled(false);
        this.colorSystem = new ColorSystem();
    }

    public PipingRules getRules() {
        return this.pipingRules;
    }

    public void enablePipingRules(boolean enabled) {
        this.pipingRules.setEnabled(enabled);
    }

    public boolean isPipingRulesEnabled() {
        return this.pipingRules.isEnabled();
    }

    public void requestUpdate(PipeControlPoint pcp) {
        this.pipingRules.requestUpdate(pcp);
    }

    public void positionUpdate(PipeControlPoint pcp) throws Exception {
        this.pipingRules.positionUpdate(pcp);
    }

    public void positionUpdate(PipeControlPoint pcp, boolean allowIR) throws Exception {
        this.pipingRules.positionUpdate(pcp, allowIR);
    }

    public boolean updatePipingRules() throws Exception {
        return this.pipingRules.update();
    }

    public void validate(PipeRun pipeRun) {
        this.pipingRules.validate(pipeRun);
    }

    public void setNodeMap(NodeMap<Resource, T, INode> nodeMap) {
        this.nodeMap = nodeMap;
        this.mapping = nodeMap.getMapping();
    }

    public void setMapping(IMapping<Resource, INode> mapping) {
        this.mapping = mapping;
    }

    public NodeMap<Resource, T, INode> getNodeMap() {
        return this.nodeMap;
    }

    public Resource getNodeResource(INode node) {
        return (Resource)this.mapping.inverseGet((Object)node);
    }

    public INode getResourceNode(Resource r) {
        return (INode)this.mapping.get((Object)r);
    }

    public ParentNode<?> getParent() {
        return null;
    }

    public ParentNode<?> getRootNode() {
        return this;
    }

    public Quat4d getOrientation() {
        return MathTools.getIdentityQuat();
    }

    public Vector3d getPosition() {
        return new Vector3d();
    }

    public Quat4d getWorldOrientation() {
        return MathTools.getIdentityQuat();
    }

    public Vector3d getWorldPosition() {
        return new Vector3d();
    }

    public Quat4d getWorldOrientation(Quat4d localOrientation) {
        return localOrientation;
    }

    public Vector3d getWorldPosition(Vector3d localPosition) {
        return localPosition;
    }

    public Quat4d getLocalOrientation(Quat4d worldOrientation) {
        return worldOrientation;
    }

    public Vector3d getLocalPosition(Vector3d worldPosition) {
        return worldPosition;
    }

    public void setPosition(Vector3d position) {
        throw new NodeException("Cannot set root node position");
    }

    public void setOrientation(Quat4d orientation) {
        throw new NodeException("Cannot set root node orientation");
    }

    public void setWorldOrientation(Quat4d orientation) {
        throw new NodeException("Cannot set root node orientation");
    }

    public void setWorldPosition(Vector3d position) {
        throw new NodeException("Cannot set root node orientation");
    }

    public String getUniqueName(String prefix) {
        HashSet<String> names = new HashSet<String>();
        for (INode node : this.getChild()) {
            if (!(node instanceof IP3DVisualNode)) continue;
            IP3DVisualNode n = (IP3DVisualNode)node;
            names.add(n.getName());
            if (!(node instanceof P3DParentNode)) continue;
            ((P3DParentNode)node).getComponentNames(names);
        }
        int i = 1;
        String genName;
        while (names.contains(genName = prefix + "_" + i)) {
            ++i;
        }
        return genName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(NodeMap.class)) {
            return adapter.cast(this.nodeMap);
        }
        return null;
    }

    public Nozzle createNozzle() {
        return new Nozzle();
    }

    public Equipment createEquipment() {
        return new Equipment();
    }

    public InlineComponent createInline() {
        return new InlineComponent();
    }

    public EndComponent createEnd() {
        return new EndComponent();
    }

    public TurnComponent createTurn() {
        return new TurnComponent();
    }

    public Vector3d getUpVector() {
        return this.upVector;
    }

    public IColorSystem getColorSystem() {
        return this.colorSystem;
    }

    public void setColorSystem(IColorSystem colorSystem) {
        this.colorSystem = colorSystem;
    }
}

