/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.scenegraph.GeometryProvider;
import org.simantics.g3d.scenegraph.NodeHighlighter;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.objmap.graph.annotations.RelatedGetObj;
import org.simantics.objmap.graph.annotations.RelatedSetObj;
import org.simantics.plant3d.scenegraph.GeometryComponent;
import org.simantics.plant3d.scenegraph.P3DNode;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.ParameterizedNode;
import vtk.vtkProp3D;
import vtk.vtkRenderer;

public abstract class GeometryNode
extends P3DNode
implements ParameterizedNode,
NodeHighlighter {
    private GeometryComponent component = new GeometryComponent(){

        @Override
        protected double[] getColor() {
            return GeometryNode.this.getColor();
        }

        @Override
        protected double[] getSelectedColor() {
            return GeometryNode.this.getSelectedColor();
        }
    };

    @Override
    public void visualize(VtkView panel) {
        this.updateParameters();
        this.component.visualize(panel);
        this.update(panel.getRenderer());
    }

    public void updateParameters() {
        this.component.updateParameters();
    }

    @Override
    public Map<String, Object> getParameterMap() {
        return this.component.getParameterMap();
    }

    public Map<String, Object> getCalculatedParameters() {
        return this.component.getCalculatedParameters();
    }

    public Map<String, Object> getTotalParameters() {
        return this.component.getTotalParameters();
    }

    public void setParametersUpdated(boolean parametersUpdated) {
        this.component.setParametersUpdated(parametersUpdated);
    }

    @Override
    public void setParameterMap(Map<String, Object> parameters) {
        Set<String> ids = this.component.setParameterMap(parameters);
        for (String id : ids) {
            this.firePropertyChanged(id);
        }
    }

    @RelatedGetObj(value="http://www.simantics.org/Plant3D-0.1/hasGeometry")
    public GeometryProvider getGeometry() {
        return this.component.getGeometry();
    }

    @RelatedSetObj(value="http://www.simantics.org/Plant3D-0.1/hasGeometry")
    public void setGeometry(GeometryProvider provider) {
        if (provider != null && provider.equals(this.component.getGeometry())) {
            return;
        }
        this.component.setGeometry(provider);
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/hasGeometry");
    }

    @Override
    public Collection<vtkProp3D> getActors() {
        return this.component.getActors();
    }

    @Override
    public void stopVisualize() {
        this.component.stopVisualize();
    }

    public void highlight(NodeHighlighter.HighlightEventType type) {
        this.component.highlight(type);
    }

    protected double[] getSelectedColor() {
        return ((P3DRootNode)this.getRootNode()).getColorSystem().getSelectedColor(this);
    }

    protected double[] getColor() {
        return ((P3DRootNode)this.getRootNode()).getColorSystem().getColor(this);
    }

    @Override
    public void update(vtkRenderer ren) {
        vtkUtil.updateTransform(this.getActors(), (Vector3d)this.getWorldPosition(), (Quat4d)this.getWorldOrientation());
    }
}

