/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import org.simantics.plant3d.scenegraph.Equipment;
import org.simantics.plant3d.scenegraph.IColorSystem;
import org.simantics.plant3d.scenegraph.IP3DNode;
import org.simantics.plant3d.scenegraph.Nozzle;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.TurnComponent;

public class ColorSystem
implements IColorSystem {
    public double[] equipmentColor = new double[]{1.0, 0.0, 0.0};
    public double[] equipmentSelectedColor = new double[]{0.5, 0.0, 0.5};
    public double[] pipelineComponentColor = new double[]{0.7, 0.7, 0.7};
    public double[] pipelineComponentFixedColor = new double[]{1.0, 0.0, 0.0};
    public double[] pipelineComponentSelectedColor = new double[]{0.5, 0.0, 0.5};
    public double[] turnComponentColor = new double[]{0.6, 0.6, 0.6};
    public double[] turnComponentFixedColor = new double[]{1.0, 0.0, 0.0};
    public double[] turnComponentSelectedColor = new double[]{0.5, 0.0, 0.5};
    public double[] nozzleColor = new double[]{0.7, 0.7, 0.7};
    public double[] nozzleSelectedColor = new double[]{0.5, 0.0, 0.5};
    public double[] defaultColor = new double[]{1.0, 0.0, 0.0};
    public double[] defaultSelectedColor = new double[]{1.0, 1.0, 0.0};

    @Override
    public double[] getColor(IP3DNode node) {
        if (node instanceof Equipment) {
            return this.equipmentColor;
        }
        if (node instanceof Nozzle) {
            return this.nozzleColor;
        }
        if (node instanceof TurnComponent) {
            PipelineComponent pc = (PipelineComponent)node;
            if (pc.getControlPoint() == null || !pc.getControlPoint().isFixed()) {
                return this.turnComponentColor;
            }
            return this.turnComponentFixedColor;
        }
        if (node instanceof PipelineComponent) {
            PipelineComponent pc = (PipelineComponent)node;
            if (pc.getControlPoint() == null || !pc.getControlPoint().isFixed()) {
                return this.pipelineComponentColor;
            }
            return this.pipelineComponentFixedColor;
        }
        return this.defaultColor;
    }

    @Override
    public double[] getSelectedColor(IP3DNode node) {
        if (node instanceof Equipment) {
            return this.equipmentSelectedColor;
        }
        if (node instanceof TurnComponent) {
            return this.turnComponentSelectedColor;
        }
        if (node instanceof Nozzle) {
            return this.nozzleSelectedColor;
        }
        if (node instanceof PipelineComponent) {
            return this.pipelineComponentSelectedColor;
        }
        return this.defaultSelectedColor;
    }
}

