/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.remover;

import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.plant3d.ontology.Plant3D;

public class P3DRemover
implements Remover {
    Resource resource;

    public P3DRemover(Resource resource) {
        this.resource = resource;
    }

    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        Plant3D P3D = Plant3D.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(this.resource, P3D.Node)) {
            return "Resource " + String.valueOf(this.resource) + " is not a Plant3D object";
        }
        if (!graph.isInstanceOf(this.resource, P3D.Plant)) {
            return "Only Plant can be removed directly";
        }
        return null;
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        EntityRemover.remove((WriteGraph)graph, (Resource)this.resource, (boolean)false);
    }
}

