/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.db.Resource;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.shape.Tube;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.plant3d.geometry.BuiltinMeshProvider;

public class ReducerGeometryProvider
extends BuiltinMeshProvider {
    private double radius = 0.01;
    private double radius2 = 0.02;
    private double offset = 0.0;

    public ReducerGeometryProvider(Resource resource) {
        super(resource);
    }

    public Collection<TopoDS_Shape> getModel() throws Exception {
        if (this.radius < MathTools.NEAR_ZERO || this.radius2 < MathTools.NEAR_ZERO) {
            return Collections.emptyList();
        }
        double length = Math.max(0.1, Math.abs(this.radius - this.radius2) * 4.0);
        TopoDS_Shape shape = Math.abs(this.radius - this.radius2) < MathTools.NEAR_ZERO ? OccTriangulator.makeCylinder((double[])new double[]{-length * 0.5, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)this.radius, (double)length) : OccTriangulator.makeCone((double[])new double[]{-length * 0.5, 0.0, 0.0}, (double[])new double[]{1.0, 0.0, 0.0}, (double)this.radius, (double)this.radius2, (double)length);
        return Collections.singletonList(shape);
    }

    public Mesh getMesh() {
        double length = Math.max(0.1, Math.abs(this.radius - this.radius2) * 4.0);
        if (length < 1.0E-4 || this.radius < MathTools.NEAR_ZERO || this.radius2 < MathTools.NEAR_ZERO) {
            return null;
        }
        Tube tube = new Tube();
        tube.setResolution(16);
        ArrayList<Point3d> vertices = new ArrayList<Point3d>();
        ArrayList<Double> radius = new ArrayList<Double>();
        ArrayList<Vector3d> tangents = new ArrayList<Vector3d>();
        vertices.add(new Point3d(-length * 0.5, 0.0, 0.0));
        vertices.add(new Point3d(length * 0.5, -this.offset, 0.0));
        radius.add(this.radius);
        radius.add(this.radius2);
        tangents.add(new Vector3d(1.0, 0.0, 0.0));
        tangents.add(new Vector3d(1.0, 0.0, 0.0));
        tube.setVertices(vertices);
        tube.setRadiis(radius);
        tube.setTangents(tangents);
        tube.setCap(false);
        return tube.create();
    }

    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("radius")) {
            this.radius = (Double)props.get("radius");
        }
        if (props.containsKey("radius2")) {
            this.radius2 = (Double)props.get("radius2");
        }
        this.offset = props.containsKey("offset") ? (Double)props.get("offset") : 0.0;
    }

    @Override
    public void updateCalculatedProperties(Map<String, Object> returnProps) {
        returnProps.put("length", Math.max(0.1, Math.abs(this.radius - this.radius2) * 4.0));
    }
}

