/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.opencascade;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jcae.opencascade.jni.BRepBndLib;
import org.jcae.opencascade.jni.BRepGProp;
import org.jcae.opencascade.jni.BRep_Tool;
import org.jcae.opencascade.jni.Bnd_Box;
import org.jcae.opencascade.jni.GP_Trsf;
import org.jcae.opencascade.jni.GProp_GProps;
import org.jcae.opencascade.jni.GProp_VelGProps;
import org.jcae.opencascade.jni.Poly_Triangulation;
import org.jcae.opencascade.jni.TopAbs_Orientation;
import org.jcae.opencascade.jni.TopLoc_Location;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shape;

public class OCCTTool {
    public static double[] getBoundingBox(TopoDS_Shape shape) {
        double[] bb = new double[6];
        Bnd_Box boundingBox = new Bnd_Box();
        BRepBndLib.add((TopoDS_Shape)shape, (Bnd_Box)boundingBox);
        boundingBox.get(bb);
        boundingBox.delete();
        return bb;
    }

    public static double getBoundingBoxDiagonal(TopoDS_Shape shape) {
        double[] min = new double[3];
        double[] max = new double[3];
        double[] mmm = new double[3];
        double[] bb = OCCTTool.getBoundingBox(shape);
        min[0] = bb[0];
        min[1] = bb[1];
        min[2] = bb[2];
        max[0] = bb[3];
        max[1] = bb[4];
        max[2] = bb[5];
        int i = 0;
        while (i < 3) {
            mmm[i] = max[i] - min[i];
            ++i;
        }
        double length = Math.sqrt(mmm[2] * mmm[2] + mmm[1] * mmm[1] + mmm[0] * mmm[0]);
        return length;
    }

    public static double getBoundingBoxDiagonal3D(TopoDS_Shape shape) {
        double[] min = new double[3];
        double[] max = new double[3];
        double[] mmm = new double[3];
        double[] bb = OCCTTool.getBoundingBox(shape);
        min[0] = bb[0];
        min[1] = bb[1];
        min[2] = bb[2];
        max[0] = bb[3];
        max[1] = bb[4];
        max[2] = bb[5];
        int i = 0;
        while (i < 3) {
            mmm[i] = max[i] - min[i];
            ++i;
        }
        double length = Math.sqrt(mmm[2] * mmm[2] + mmm[1] * mmm[1] + mmm[0] * mmm[0]);
        double t0 = mmm[0] * mmm[0];
        double t1 = mmm[1] * mmm[1];
        double t2 = mmm[2] * mmm[2];
        double tol = 1.0E-6 * length;
        if (t0 < tol || t1 < tol || t2 < tol) {
            return 0.0;
        }
        return length;
    }

    public static double getBoundingBoxVolume(TopoDS_Shape shape) {
        double[] min = new double[3];
        double[] max = new double[3];
        double[] mmm = new double[3];
        double[] bb = OCCTTool.getBoundingBox(shape);
        min[0] = bb[0];
        min[1] = bb[1];
        min[2] = bb[2];
        max[0] = bb[3];
        max[1] = bb[4];
        max[2] = bb[5];
        int i = 0;
        while (i < 3) {
            mmm[i] = max[i] - min[i];
            ++i;
        }
        double vol = Math.sqrt(mmm[2] * mmm[1] * mmm[0]);
        return vol;
    }

    private static GProp_GProps getGProp(TopoDS_Shape shape) {
        GProp_GProps GSystem = null;
        int type = 0;
        if (type == 0) {
            GSystem = new GProp_GProps();
            BRepGProp.volumeProperties((TopoDS_Shape)shape, (GProp_GProps)GSystem, (double)0.001);
        } else if (type == 1) {
            GSystem = new GProp_VelGProps();
            BRepGProp.volumeProperties((TopoDS_Shape)shape, (GProp_GProps)GSystem, (double)0.001);
        } else if (type == 2) {
            GSystem = new GProp_VelGProps();
            BRepGProp.volumePropertiesGK((TopoDS_Shape)shape, (GProp_GProps)GSystem, (double)0.001);
        }
        return GSystem;
    }

    public static double getMass(TopoDS_Shape shape) {
        GProp_GProps GSystem = OCCTTool.getGProp(shape);
        double mass = GSystem.mass();
        GSystem.delete();
        return mass;
    }

    public static double[] getInertia(TopoDS_Shape shape) {
        GProp_GProps GSystem = OCCTTool.getGProp(shape);
        double[] inertia = GSystem.matrixOfInertia();
        GSystem.delete();
        return inertia;
    }

    public static double[] getCentreOfMass(TopoDS_Shape shape) {
        GProp_GProps GSystem = OCCTTool.getGProp(shape);
        double[] cm = GSystem.centreOfMass();
        GSystem.delete();
        return cm;
    }

    public static boolean appendToMesh(TopoDS_Face face, List<Double> meshPoints, List<Integer> meshTriangles) {
        TopLoc_Location Location2 = new TopLoc_Location();
        Poly_Triangulation triangulation = BRep_Tool.triangulation((TopoDS_Face)face, (TopLoc_Location)Location2);
        if (triangulation == null) {
            Location2.delete();
            System.out.println("Encountered empty triangulation after face");
            return false;
        }
        boolean reverse = face.orientation() == TopAbs_Orientation.REVERSED;
        int lastPoint = meshPoints.size() / 3;
        int[] triangles = triangulation.triangles();
        double[] nodes = triangulation.nodes();
        int nofTriangles = triangulation.nbTriangles();
        int nofNodes = triangulation.nbNodes();
        triangulation.delete();
        if (nofTriangles < 1) {
            System.out.println("No triangles for mesh on face");
            Location2.delete();
            return false;
        }
        if (nofNodes < 1) {
            System.out.println("No nodes for mesh on face:");
            Location2.delete();
            return false;
        }
        int i = 0;
        while (i < nofTriangles) {
            int n2;
            int n1;
            int n0;
            if (!reverse) {
                n0 = triangles[3 * i];
                n1 = triangles[3 * i + 1];
                n2 = triangles[3 * i + 2];
            } else {
                n0 = triangles[3 * i + 2];
                n1 = triangles[3 * i + 1];
                n2 = triangles[3 * i];
            }
            meshTriangles.add(n0 + lastPoint);
            meshTriangles.add(n1 + lastPoint);
            meshTriangles.add(n2 + lastPoint);
            ++i;
        }
        GP_Trsf transformation = Location2.transformation();
        Location2.delete();
        double[] d_mat = new double[16];
        transformation.getValues(d_mat);
        Matrix4d mat = new Matrix4d(d_mat);
        int i2 = 0;
        while (i2 < nofNodes) {
            Point3d p = new Point3d(nodes[3 * i2], nodes[3 * i2 + 1], nodes[3 * i2 + 2]);
            mat.transform(p);
            meshPoints.add(p.x);
            meshPoints.add(p.y);
            meshPoints.add(p.z);
            ++i2;
        }
        transformation.delete();
        return true;
    }
}

