/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.domain;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.graph.rules.domain.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedListAccessor
implements IDomainAccessor<Resource, Collection<Resource>> {
    static Logger LOGGER = LoggerFactory.getLogger(LinkedListAccessor.class);
    Resource relation;
    Resource listType;
    boolean deleteExtraObjects;

    public LinkedListAccessor(Resource relation, Resource listType, boolean deleteExtraObjects) {
        this.relation = relation;
        this.listType = listType;
        this.deleteExtraObjects = deleteExtraObjects;
    }

    @Override
    public Collection<Resource> get(ReadGraph g, Resource element) throws MappingException {
        try {
            LOGGER.trace("        LinkdedListAccessor.get");
            return ListUtils.toList((ReadGraph)g, (Resource)g.getPossibleObject(element, this.relation));
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Collection<Resource> value) throws MappingException {
        try {
            LOGGER.trace("        LinkdedListAccessor.set");
            return MappingUtils.synchronizeList(g, element, this.relation, this.listType, new ArrayList<Resource>(value), this.deleteExtraObjects);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }
}

