/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.math;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class TriTriIntersection {
    public static Line triTriIntesect(Vector3d v00, Vector3d v01, Vector3d v02, Vector3d v10, Vector3d v11, Vector3d v12) {
        Plane p0;
        Line x1;
        Plane p1 = TriTriIntersection.triToPlane(v10, v11, v12);
        Line x0 = TriTriIntersection.triCrossingPlane(v00, v01, v02, p1);
        if (x0 != null && x0.p0 != null && (x1 = TriTriIntersection.triCrossingPlane(v10, v11, v12, p0 = TriTriIntersection.triToPlane(v00, v01, v02))) != null) {
            Line il = TriTriIntersection.planePlaneIntersectLine(p0, p1);
            return TriTriIntersection.lineCrossing(il, x0, x1);
        }
        return null;
    }

    public static Plane triToPlane(Vector3d v0, Vector3d v1, Vector3d v2) {
        Vector3d a = new Vector3d();
        a.sub((Tuple3d)v2, (Tuple3d)v0);
        Vector3d b = new Vector3d();
        b.sub((Tuple3d)v1, (Tuple3d)v0);
        Vector3d n = new Vector3d();
        n.cross(a, b);
        double w = n.dot(v0);
        return new Plane(n, -w);
    }

    public static Line triCrossingPlane(Vector3d v0, Vector3d v1, Vector3d v2, Plane p) {
        double d0 = p.n.dot(v0) + p.d;
        double d1 = p.n.dot(v1) + p.d;
        double d2 = p.n.dot(v2) + p.d;
        double d01 = d0 * d1;
        double d12 = d1 * d2;
        if (d01 < 0.0) {
            double da0 = Math.abs(d0);
            double da1 = Math.abs(d1);
            double da2 = Math.abs(d2);
            double t01 = da0 / (da1 + da0);
            if (d12 < 0.0) {
                double t12 = da1 / (da2 + da1);
                Vector3d r0 = new Vector3d();
                r0.sub((Tuple3d)v1, (Tuple3d)v0);
                r0.scale(t01);
                r0.add((Tuple3d)v0);
                Vector3d r1 = new Vector3d();
                r1.sub((Tuple3d)v2, (Tuple3d)v1);
                r1.scale(t12);
                r1.add((Tuple3d)v1);
                return new Line(r0, r1);
            }
            double t20 = da2 / (da0 + da2);
            Vector3d r0 = new Vector3d();
            r0.sub((Tuple3d)v1, (Tuple3d)v0);
            r0.scale(t01);
            r0.add((Tuple3d)v0);
            Vector3d r1 = new Vector3d();
            r1.sub((Tuple3d)v0, (Tuple3d)v2);
            r1.scale(t20);
            r1.add((Tuple3d)v2);
            return new Line(r0, r1);
        }
        if (d12 < 0.0) {
            double da0 = Math.abs(d0);
            double da1 = Math.abs(d1);
            double da2 = Math.abs(d2);
            double t12 = da1 / (da2 + da1);
            double t20 = da2 / (da0 + da2);
            Vector3d r0 = new Vector3d();
            r0.sub((Tuple3d)v2, (Tuple3d)v1);
            r0.scale(t12);
            r0.add((Tuple3d)v1);
            Vector3d r1 = new Vector3d();
            r1.sub((Tuple3d)v0, (Tuple3d)v2);
            r1.scale(t20);
            r1.add((Tuple3d)v2);
            return new Line(r0, r1);
        }
        if (d0 == 0.0 && d1 == 0.0 && d2 == 0.0) {
            return new Line(null, null);
        }
        return null;
    }

    public static Line planePlaneIntersectLine(Plane p0, Plane p1) {
        Vector3d n = new Vector3d();
        n.cross(p0.n, p1.n);
        Plane pn = new Plane(n, 0.0);
        Point3d lp = TriTriIntersection.intersect(p0, p1, pn);
        if (lp == null) {
            return null;
        }
        Point3d lp2 = new Point3d();
        lp2.add((Tuple3d)lp, (Tuple3d)n);
        Line l = new Line(lp, lp2);
        return l;
    }

    public static Point3d intersect(Plane p0, Plane p1, Plane p2) {
        Matrix3d m0 = new Matrix3d(p0.n.x, p0.n.y, p0.n.z, p1.n.x, p1.n.y, p1.n.z, p2.n.x, p2.n.y, p2.n.z);
        double d0 = m0.determinant();
        if (d0 == 0.0) {
            return null;
        }
        Matrix3d mx = new Matrix3d(-p0.d, p0.n.y, p0.n.z, -p1.d, p1.n.y, p1.n.z, -p2.d, p2.n.y, p2.n.z);
        double dx = mx.determinant();
        Matrix3d my = new Matrix3d(p0.n.x, -p0.d, p0.n.z, p1.n.x, -p1.d, p1.n.z, p2.n.x, -p2.d, p2.n.z);
        double dy = my.determinant();
        Matrix3d mz = new Matrix3d(p0.n.x, p0.n.y, -p0.d, p1.n.x, p1.n.y, -p1.d, p2.n.x, p2.n.y, -p2.d);
        double dz = mz.determinant();
        Point3d v = new Point3d(dx, dy, dz);
        v.scale(1.0 / d0);
        return v;
    }

    public static Line lineCrossing(Line l, Line x0, Line x1) {
        double len = l.p0.distanceSquared(l.p1);
        double s = -1.0 / len;
        Vector3d ld = new Vector3d();
        ld.sub((Tuple3d)l.p1, (Tuple3d)l.p0);
        Vector3d lx00 = new Vector3d();
        lx00.sub((Tuple3d)l.p0, (Tuple3d)x0.p0);
        Vector3d lx10 = new Vector3d();
        lx10.sub((Tuple3d)l.p0, (Tuple3d)x1.p0);
        Vector3d lx01 = new Vector3d();
        lx01.sub((Tuple3d)l.p0, (Tuple3d)x0.p1);
        Vector3d lx11 = new Vector3d();
        lx11.sub((Tuple3d)l.p0, (Tuple3d)x1.p1);
        double t00 = lx00.dot(ld) * s;
        double t10 = lx10.dot(ld) * s;
        double t01 = lx01.dot(ld) * s;
        double t11 = lx11.dot(ld) * s;
        Vector2d span = null;
        span = t00 < t01 ? (t10 < t11 ? TriTriIntersection.intersectSpan(t00, t01, t10, t11) : TriTriIntersection.intersectSpan(t00, t01, t11, t10)) : (t10 < t11 ? TriTriIntersection.intersectSpan(t01, t00, t10, t11) : TriTriIntersection.intersectSpan(t01, t00, t11, t10));
        if (span == null) {
            return null;
        }
        Point3d p0 = new Point3d((Tuple3d)ld);
        p0.scale(span.x);
        p0.add((Tuple3d)l.p0);
        Point3d p1 = new Point3d((Tuple3d)ld);
        p1.scale(span.y);
        p1.add((Tuple3d)l.p0);
        return new Line(p0, p1);
    }

    public static Vector2d intersectSpan(double v00, double v01, double v10, double v11) {
        double min1;
        double max0 = Math.max(v00, v10);
        if (max0 <= (min1 = Math.min(v01, v11))) {
            return new Vector2d(max0, min1);
        }
        return null;
    }

    public static class Line {
        Point3d p0;
        Point3d p1;

        public Line(Vector3d v0, Vector3d v1) {
            this.p0 = new Point3d((Tuple3d)v0);
            this.p1 = new Point3d((Tuple3d)v1);
        }

        public Line(Point3d p0, Point3d p1) {
            this.p0 = p0;
            this.p1 = p1;
        }

        public Point3d getP0() {
            return this.p0;
        }

        public Point3d getP1() {
            return this.p1;
        }
    }

    public static class Plane {
        Vector3d n;
        double d;

        public Plane(Vector3d n, double d) {
            this.n = n;
            this.d = d;
        }

        public Plane(double x, double y, double z, double d) {
            this.n = new Vector3d(x, y, z);
            this.d = d;
        }

        public Vector3d getN() {
            return this.n;
        }

        public double getD() {
            return this.d;
        }
    }
}

