/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.vtk.shape.IvtkVisualObject;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkAxes;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkLinearTransform;
import vtk.vtkMapper;
import vtk.vtkMatrix4x4;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderer;
import vtk.vtkSphereSource;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class axesSphereActor
extends vtkAssembly
implements IvtkVisualObject {
    private vtkRenderer ren;
    private double axisLength = 0.8;
    private vtkTextActor xactor;
    private vtkTextActor yactor;
    private vtkTextActor zactor;
    private vtkActor tubeActor;
    private vtkActor xconeActor;
    private vtkActor yconeActor;
    private vtkActor zconeActor;
    private vtkActor oBallActor;
    private boolean rendered = false;
    private boolean labelVisible = true;
    Matrix4d m = new Matrix4d();
    double[] mat = new double[16];
    Point3d x = new Point3d();
    Point3d y = new Point3d();
    Point3d z = new Point3d();

    public axesSphereActor(vtkRenderer _ren) {
        this.ren = _ren;
        this.createAxes();
    }

    public axesSphereActor(vtkRenderer _ren, double axisLength) {
        this.ren = _ren;
        this.axisLength = axisLength;
        this.createAxes();
    }

    public void createAxes() {
        vtkAxes axes = new vtkAxes();
        axes.SetOrigin(0.0, 0.0, 0.0);
        axes.SetScaleFactor(this.axisLength);
        vtkTubeFilter tube = new vtkTubeFilter();
        tube.SetInputData((vtkDataObject)axes.GetOutput());
        tube.SetRadius(0.05 * this.axisLength);
        tube.SetNumberOfSides(8);
        vtkPolyDataMapper tubeMapper = new vtkPolyDataMapper();
        tubeMapper.SetInputData(tube.GetOutput());
        this.tubeActor = new vtkActor();
        this.tubeActor.SetMapper((vtkMapper)tubeMapper);
        this.tubeActor.PickableOff();
        int coneRes = 12;
        double coneScale = 0.3 * this.axisLength;
        vtkConeSource xcone = new vtkConeSource();
        xcone.SetResolution(coneRes);
        vtkPolyDataMapper xconeMapper = new vtkPolyDataMapper();
        xconeMapper.SetInputData(xcone.GetOutput());
        this.xconeActor = new vtkActor();
        this.xconeActor.SetMapper((vtkMapper)xconeMapper);
        this.xconeActor.GetProperty().SetColor(1.0, 0.0, 0.0);
        this.xconeActor.SetScale(coneScale, coneScale, coneScale);
        this.xconeActor.SetPosition(this.axisLength, 0.0, 0.0);
        this.xconeActor.SetPickable(0);
        vtkConeSource ycone = new vtkConeSource();
        ycone.SetResolution(coneRes);
        vtkPolyDataMapper yconeMapper = new vtkPolyDataMapper();
        yconeMapper.SetInputData(ycone.GetOutput());
        this.yconeActor = new vtkActor();
        this.yconeActor.SetMapper((vtkMapper)yconeMapper);
        this.yconeActor.GetProperty().SetColor(1.0, 1.0, 0.0);
        this.yconeActor.RotateZ(90.0);
        this.yconeActor.SetScale(coneScale, coneScale, coneScale);
        this.yconeActor.SetPosition(0.0, this.axisLength, 0.0);
        this.yconeActor.SetPickable(0);
        vtkConeSource zcone = new vtkConeSource();
        zcone.SetResolution(coneRes);
        vtkPolyDataMapper zconeMapper = new vtkPolyDataMapper();
        zconeMapper.SetInputData(zcone.GetOutput());
        this.zconeActor = new vtkActor();
        this.zconeActor.SetMapper((vtkMapper)zconeMapper);
        this.zconeActor.GetProperty().SetColor(0.0, 1.0, 0.0);
        this.zconeActor.RotateY(-90.0);
        this.zconeActor.SetScale(coneScale, coneScale, coneScale);
        this.zconeActor.SetPosition(0.0, 0.0, this.axisLength);
        this.zconeActor.SetPickable(0);
        vtkSphereSource ball = new vtkSphereSource();
        ball.SetRadius(this.axisLength * 0.3);
        ball.SetPhiResolution(6);
        ball.SetThetaResolution(8);
        vtkPolyDataMapper ballMapper = new vtkPolyDataMapper();
        ballMapper.SetInputData(ball.GetOutput());
        this.oBallActor = new vtkActor();
        this.oBallActor.SetMapper((vtkMapper)ballMapper);
        this.oBallActor.GetProperty().SetColor(0.0, 0.0, 1.0);
        this.oBallActor.SetPickable(0);
        this.AddPart((vtkProp3D)this.tubeActor);
        this.AddPart((vtkProp3D)this.xconeActor);
        this.AddPart((vtkProp3D)this.yconeActor);
        this.AddPart((vtkProp3D)this.zconeActor);
        this.AddPart((vtkProp3D)this.oBallActor);
        tube.GetOutput().Delete();
        xcone.GetOutput().Delete();
        ycone.GetOutput().Delete();
        zcone.GetOutput().Delete();
        axes.GetOutput().Delete();
        ball.GetOutput().Delete();
        axes.Delete();
        tube.Delete();
        xcone.Delete();
        ycone.Delete();
        zcone.Delete();
        ball.Delete();
        tubeMapper.Delete();
        xconeMapper.Delete();
        yconeMapper.Delete();
        zconeMapper.Delete();
        ballMapper.Delete();
        this.xconeActor.GetProperty().Delete();
        this.yconeActor.GetProperty().Delete();
        this.zconeActor.GetProperty().Delete();
        this.oBallActor.GetProperty().Delete();
        this.xactor = new vtkTextActor();
        this.yactor = new vtkTextActor();
        this.zactor = new vtkTextActor();
        this.xactor.SetInput("X");
        this.yactor.SetInput("Y");
        this.zactor.SetInput("Z");
        this.xactor.SetTextScaleModeToNone();
        this.yactor.SetTextScaleModeToNone();
        this.zactor.SetTextScaleModeToNone();
        this.xactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.xactor.GetTextProperty().ShadowOff();
        this.xactor.GetTextProperty().ItalicOff();
        this.xactor.GetTextProperty().BoldOff();
        this.yactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.yactor.GetTextProperty().ShadowOff();
        this.yactor.GetTextProperty().ItalicOff();
        this.yactor.GetTextProperty().BoldOff();
        this.zactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.zactor.GetTextProperty().ShadowOff();
        this.zactor.GetTextProperty().ItalicOff();
        this.zactor.GetTextProperty().BoldOff();
        this.xactor.GetTextProperty().Delete();
        this.yactor.GetTextProperty().Delete();
        this.zactor.GetTextProperty().Delete();
        this.xactor.SetMaximumLineHeight(0.25f);
        this.yactor.SetMaximumLineHeight(0.25f);
        this.zactor.SetMaximumLineHeight(0.25f);
        this.xactor.SetPickable(0);
        this.yactor.SetPickable(0);
        this.zactor.SetPickable(0);
    }

    @Override
    public void addToRenderer() {
        if (this.rendered) {
            return;
        }
        this.rendered = true;
        this.ren.AddActor2D((vtkProp)this.xactor);
        this.ren.AddActor2D((vtkProp)this.yactor);
        this.ren.AddActor2D((vtkProp)this.zactor);
        this.ren.AddActor((vtkProp)this);
    }

    @Override
    public void removeFromRenderer() {
        if (!this.rendered) {
            return;
        }
        this.rendered = false;
        this.ren.RemoveActor2D((vtkProp)this.xactor);
        this.ren.RemoveActor2D((vtkProp)this.yactor);
        this.ren.RemoveActor2D((vtkProp)this.zactor);
        this.ren.RemoveActor((vtkProp)this);
    }

    @Override
    public boolean isRendered() {
        return this.rendered;
    }

    public void setAxesVisibility(boolean ison) {
        this.SetVisibility(ison ? 1 : 0);
        this.xactor.SetVisibility(ison ? 1 : 0);
        this.yactor.SetVisibility(ison ? 1 : 0);
        this.zactor.SetVisibility(ison ? 1 : 0);
    }

    public void setLabelVisibility(boolean ison) {
        this.xactor.SetVisibility(ison ? 1 : 0);
        this.yactor.SetVisibility(ison ? 1 : 0);
        this.zactor.SetVisibility(ison ? 1 : 0);
        this.labelVisible = ison;
        if (this.labelVisible) {
            this.updateTextLoc();
        }
    }

    private void updateTextLoc() {
        if (!this.labelVisible) {
            return;
        }
        this.xactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.yactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.zactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.GetMatrix(this.mat);
        MathTools.set((Matrix4d)this.m, (double[])this.mat);
        this.x.set(this.axisLength, 0.0, 0.0);
        this.y.set(0.0, this.axisLength, 0.0);
        this.z.set(0.0, 0.0, this.axisLength);
        this.m.transform(this.x);
        this.m.transform(this.y);
        this.m.transform(this.z);
        this.xactor.GetPositionCoordinate().SetValue(this.x.x, this.x.y, this.x.z);
        this.yactor.GetPositionCoordinate().SetValue(this.y.x, this.y.y, this.y.z);
        this.zactor.GetPositionCoordinate().SetValue(this.z.x, this.z.y, this.z.z);
        this.xactor.GetPositionCoordinate().Delete();
        this.yactor.GetPositionCoordinate().Delete();
        this.zactor.GetPositionCoordinate().Delete();
    }

    public void SetPickable(int id0) {
        super.SetPickable(id0);
        this.tubeActor.SetPickable(id0);
        this.xconeActor.SetPickable(id0);
        this.yconeActor.SetPickable(id0);
        this.zconeActor.SetPickable(id0);
        this.oBallActor.SetPickable(id0);
    }

    public void SetOrientation(double id0, double id1, double id2) {
        super.SetOrientation(id0, id1, id2);
        this.updateTextLoc();
    }

    public void RotateWXYZ(double id0, double id1, double id2, double id3) {
        super.RotateWXYZ(id0, id1, id2, id3);
        this.updateTextLoc();
    }

    public void SetPosition(double[] id0) {
        super.SetPosition(id0);
        this.updateTextLoc();
    }

    public void SetPosition(double id0, double id1, double id2) {
        super.SetPosition(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetOrientation(double[] id0) {
        super.SetOrientation(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0, double id1, double id2) {
        super.SetScale(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetScale(double[] id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetUserMatrix(vtkMatrix4x4 id0) {
        super.SetUserMatrix(id0);
        this.updateTextLoc();
    }

    public void SetUserTransform(vtkLinearTransform id0) {
        super.SetUserTransform(id0);
        this.updateTextLoc();
    }

    public void Delete() {
        this.ren.RemoveActor((vtkProp)this.xactor);
        this.ren.RemoveActor((vtkProp)this.yactor);
        this.ren.RemoveActor((vtkProp)this.zactor);
        this.ren.RemoveActor((vtkProp)this.tubeActor);
        this.ren.RemoveActor((vtkProp)this.xconeActor);
        this.ren.RemoveActor((vtkProp)this.yconeActor);
        this.ren.RemoveActor((vtkProp)this.xconeActor);
        this.xactor.Delete();
        this.yactor.Delete();
        this.zactor.Delete();
        this.tubeActor.Delete();
        this.xconeActor.Delete();
        this.yconeActor.Delete();
        this.zconeActor.Delete();
        super.Delete();
    }

    public void dispose() {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                axesSphereActor.this.removeFromRenderer();
                axesSphereActor.this.Delete();
            }
        });
    }

    @Override
    public vtkProp3D getVtkProp() {
        return this;
    }
}

