/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.gizmo;

import java.util.Collection;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.gizmo.Gizmo;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.vtk.common.VtkView;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderer;

public abstract class vtkGizmo
implements Gizmo<vtkProp, VtkView> {
    private VtkView view;
    private Collection<vtkProp> gizmo;
    private Tuple3d position;
    private AxisAngle4d orientation;
    private Tuple3d scale;

    public void attach(VtkView renderingPart) {
        if (this.view != null) {
            throw new RuntimeException("Gizmo is attached");
        }
        this.view = renderingPart;
        this.attachActors();
    }

    public void deattach() {
        if (this.view == null) {
            throw new RuntimeException("Gizmo is not attached");
        }
        this.deattachActors();
        this.view = null;
    }

    public boolean isAttached() {
        return this.view != null;
    }

    protected void attachActors() {
        this.view.lock();
        this.gizmo = this.getGizmo();
        vtkRenderer ren1 = this.view.getRenderer();
        for (vtkProp p : this.gizmo) {
            ren1.AddActor(p);
        }
        if (this.position != null) {
            this.setPosition(this.position);
        }
        if (this.orientation != null) {
            this.setRotation(this.orientation);
        }
        if (this.scale != null) {
            this.setScale(this.scale);
        }
        this.view.unlock();
    }

    protected void deattachActors() {
        this.view.lock();
        vtkRenderer ren1 = this.view.getRenderer();
        if (ren1 != null) {
            for (vtkProp p : this.gizmo) {
                ren1.RemoveActor(p);
            }
        }
        this.view.unlock();
    }

    public boolean isPartOf(vtkProp pickedObject) {
        for (vtkProp prop : this.gizmo) {
            if (!prop.equals(pickedObject)) continue;
            return true;
        }
        return false;
    }

    public void setPosition(Tuple3d position) {
        this.position = position;
        for (vtkProp p : this.gizmo) {
            ((vtkProp3D)p).SetPosition(position.x, position.y, position.z);
        }
    }

    public void setRotation(AxisAngle4d q) {
        this.orientation = q;
        for (vtkProp p : this.gizmo) {
            ((vtkProp3D)p).SetOrientation(0.0, 0.0, 0.0);
            ((vtkProp3D)p).RotateWXYZ(MathTools.radToDeg((double)q.angle), q.x, q.y, q.z);
        }
    }

    public void setScale(Tuple3d s) {
        this.scale = s;
        for (vtkProp p : this.gizmo) {
            ((vtkProp3D)p).SetScale(s.x, s.y, s.z);
        }
    }

    public void setScale(double s) {
        this.scale = new Vector3d(s, s, s);
        for (vtkProp p : this.gizmo) {
            ((vtkProp3D)p).SetScale(s, s, s);
        }
    }

    public abstract Collection<vtkProp> getGizmo();

    public double[] add(double[] ... color) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        double[][] dArray = color;
        int n = color.length;
        int n2 = 0;
        while (n2 < n) {
            double[] c = dArray[n2];
            int i = 0;
            while (i < 3) {
                int n3 = i;
                result[n3] = result[n3] + c[i];
                ++i;
            }
            ++n2;
        }
        return result;
    }

    public VtkView getView() {
        return this.view;
    }
}

