/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.annotations.Referable;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;

@Referable
public class RecordType
extends Datatype {
    public static final Datatype VOID_TYPE = new RecordType(false, new Component[0]);
    public static final String KEY_REFERABLE = "referable";
    public static final String KEY_IDENTIFIER = "identifier";
    public static final Component[] NO_COMPONENTS = new Component[0];
    Component[] components = NO_COMPONENTS;
    private transient int[] identifiersIndices;
    private transient Datatype identifierType;

    public RecordType() {
        this.setReferable(false);
    }

    public RecordType(boolean referable, Component ... components) {
        this.components = components;
        this.setReferable(referable);
    }

    public boolean isReferable() {
        String str = (String)this.metadata.get(KEY_REFERABLE);
        return str != null && str.equals(Boolean.TRUE.toString());
    }

    public void setReferable(boolean referable) {
        if (!referable) {
            this.metadata.remove(KEY_REFERABLE);
        } else {
            this.metadata.put(KEY_REFERABLE, Boolean.toString(referable));
        }
    }

    @Override
    protected void collectSubtypes(Set<Datatype> subtypes, Set<Datatype> recursiveSubtypes) {
        if (!subtypes.add(this)) {
            recursiveSubtypes.add(this);
            return;
        }
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.type.collectSubtypes(subtypes, recursiveSubtypes);
            ++n2;
        }
    }

    public void setComponents(Component[] components) {
        this.components = components;
    }

    public void mergeRecord(RecordType src) throws DatatypeConstructionException {
        int ci = src.getComponentCount();
        int i = 0;
        while (i < ci) {
            Component sc = src.components[i];
            int li = this.getComponentIndex2(sc.name);
            if (li < 0) {
                this.addComponent(sc.name, sc.type);
            } else {
                Component lc = this.components[li];
                if (sc.type instanceof RecordType && lc.type instanceof RecordType) {
                    ((RecordType)lc.type).mergeRecord((RecordType)sc.type);
                } else if (!sc.type.equals(lc.type)) {
                    throw new DatatypeConstructionException("Cannot merge field \"" + sc.name + "\" " + sc.type.getClass().getName() + " and " + lc.getClass().getName());
                }
            }
            ++i;
        }
    }

    public void addComponent(String name, Datatype type) {
        Component c = new Component(name, type);
        if (this.components == null) {
            this.components = new Component[]{c};
        } else {
            Component[] newComponents = new Component[this.components.length + 1];
            System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
            newComponents[this.components.length] = c;
            this.components = newComponents;
        }
    }

    public void clear() {
        this.components = new Component[0];
        this.metadata.clear();
    }

    public void removeComponent(String name) {
        int index = this.getComponentIndex2(name);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Component[] newComponents = new Component[this.components.length - 1];
        if (index > 0) {
            System.arraycopy(this.components, 0, newComponents, 0, index);
        }
        if (index < newComponents.length) {
            System.arraycopy(this.components, index + 1, newComponents, index, newComponents.length - index);
        }
        this.components = newComponents;
    }

    @Override
    public int getComponentCount() {
        return this.components.length;
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        IdentityPair<RecordType, RecordType> pair;
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        if (!(obj instanceof RecordType)) {
            return false;
        }
        RecordType other = (RecordType)obj;
        if (this.components.length != other.components.length) {
            return false;
        }
        int i = 0;
        while (i < this.components.length) {
            Component lc = this.components[i];
            Component rc = other.components[i];
            if (!lc.name.equals(rc.name)) {
                return false;
            }
            ++i;
        }
        if (compareHistory == null) {
            compareHistory = new HashSet<IdentityPair<Datatype, Datatype>>(1);
        }
        if (compareHistory.contains(pair = new IdentityPair<RecordType, RecordType>(this, other))) {
            return true;
        }
        compareHistory.add(pair);
        int i2 = 0;
        while (i2 < this.components.length) {
            Component lc = this.components[i2];
            Component rc = other.components[i2];
            if (!lc.type.deepEquals(rc.type, compareHistory)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            hash = hash * 13 + 7 * Objects.hashCode(c.name);
            ++n2;
        }
        return hash;
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    public boolean isTupleType() {
        if (this.components.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.getComponentCount()) {
            if (!this.getComponent((int)i).name.equals(Integer.toString(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Datatype getComponentType(int index) {
        if (index < 0 || index >= this.components.length) {
            return null;
        }
        return this.components[index].type;
    }

    @Override
    public Datatype getComponentType(ChildReference path) throws IllegalArgumentException {
        if (path == null) {
            return this;
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            return this.components[ir.index].type.getComponentType(path.childReference);
        }
        if (path instanceof NameReference) {
            NameReference nr = (NameReference)path;
            return this.getComponent((String)nr.name).type.getComponentType(path.childReference);
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            try {
                Integer i = new Integer(lr.label);
                return this.getComponent((int)i.intValue()).type.getComponentType(path.childReference);
            }
            catch (NumberFormatException numberFormatException) {
                return this.getComponent((String)lr.label).type.getComponentType(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean hasComponent(String fieldName) {
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].name.equals(fieldName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Integer getComponentIndex(String fieldName) {
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].name.equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public int getComponentIndex2(String fieldName) {
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].name.equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Datatype getComponentType(String fieldName) {
        int index = this.getComponentIndex2(fieldName);
        if (index < 0) {
            return null;
        }
        return this.components[index].type;
    }

    public Component getComponent(String fieldName) {
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.name.equals(fieldName)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public Component getComponent(int index) {
        if (index < 0 || index >= this.components.length) {
            return null;
        }
        return this.components[index];
    }

    public Component[] getComponents() {
        return this.components;
    }

    public int[] getIdentifiers() {
        String ids = (String)this.metadata.get(KEY_IDENTIFIER);
        if (ids == null) {
            this.identifiersIndices = new int[0];
        } else {
            StringTokenizer st = new StringTokenizer(ids, ",");
            int[] indices = new int[st.countTokens()];
            int i = 0;
            while (i < indices.length) {
                String token = st.nextToken();
                try {
                    indices[i] = Integer.valueOf(token);
                }
                catch (NumberFormatException numberFormatException) {
                    indices[i] = -1;
                }
                ++i;
            }
            this.identifiersIndices = indices;
        }
        return this.identifiersIndices;
    }

    public void setIdentifiers(int ... indices) {
        if (indices.length == 0) {
            this.metadata.remove(KEY_IDENTIFIER);
            return;
        }
        this.identifiersIndices = indices;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indices.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(Integer.toString(indices[i]));
            ++i;
        }
        String str = sb.toString();
        if (str.isEmpty()) {
            this.metadata.remove(KEY_IDENTIFIER);
        } else {
            this.metadata.put(KEY_IDENTIFIER, str);
        }
    }

    public void setIdentifiers(List<Integer> indices) {
        int[] indices2 = new int[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            indices2[i] = indices.get(i);
            ++i;
        }
        this.setIdentifiers(indices2);
    }

    public boolean isIdentifier(int fieldIndex) {
        int[] ids = this.getIdentifiers();
        if (ids == null) {
            return false;
        }
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index == fieldIndex) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Datatype getIdentifierType() {
        if (this.identifierType != null) {
            return this.identifierType;
        }
        int[] ids = this.getIdentifiers();
        if (ids.length == 0) {
            return null;
        }
        if (ids.length == 1) {
            this.identifierType = this.getComponentType(ids[0]);
        }
        RecordType rt = new RecordType();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Component c = this.getComponent(i);
            rt.addComponent(c.name, c.type);
            ++n2;
        }
        this.identifierType = rt;
        return this.identifierType;
    }

    @Override
    public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            String fieldName = lr.label;
            int index = this.getComponentIndex2(fieldName);
            if (index < 0) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            return this.components[index].type.getChildType(reference.childReference);
        }
        if (reference instanceof IndexReference) {
            IndexReference ref = (IndexReference)reference;
            int index = ref.getIndex();
            if (index < 0 || index >= this.components.length) {
                new ReferenceException("RecordType doesn't have field at index+" + index);
            }
            return this.components[index].type.getChildType(reference.childReference);
        }
        if (reference instanceof NameReference) {
            NameReference lr = (NameReference)reference;
            String fieldName = lr.name;
            int index = this.getComponentIndex2(fieldName);
            if (index < 0) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            return this.components[index].type.getChildType(reference.childReference);
        }
        throw new ReferenceException(reference.getClass() + " is not a subreference of RecordType");
    }
}

