/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.streaming;

import java.io.IOException;
import java.io.PrintStream;
import org.simantics.databoard.streaming.DataReader;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.binary.Endian;

public class DataSerializationDebugger {
    DataReader in;
    PrintStream out;
    int indentation;
    private static final Integer I1 = 1;
    private static final Integer I4 = 4;
    private static final Integer I8 = 8;
    private static Datatype.Visitor<Integer> FIXED_SIZE = new Datatype.Visitor<Integer>(){

        @Override
        public Integer visit(ArrayType b) {
            Range length = b.getLength();
            if (length == null || length.getLower().getValue() == null || !length.getLower().equals(length.getUpper())) {
                return null;
            }
            int fixedLength = length.getLower().getValue().intValue();
            Integer componentLength = b.componentType.accept(this);
            if (componentLength == null) {
                return null;
            }
            return fixedLength * componentLength;
        }

        @Override
        public Integer visit(BooleanType b) {
            return I1;
        }

        @Override
        public Integer visit(DoubleType b) {
            return I8;
        }

        @Override
        public Integer visit(FloatType b) {
            return I4;
        }

        @Override
        public Integer visit(IntegerType b) {
            return I4;
        }

        @Override
        public Integer visit(ByteType b) {
            return I1;
        }

        @Override
        public Integer visit(LongType b) {
            return I8;
        }

        @Override
        public Integer visit(OptionalType b) {
            return null;
        }

        @Override
        public Integer visit(RecordType b) {
            if (b.isReferable()) {
                return null;
            }
            int sum = 0;
            Component[] componentArray = b.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                Integer componentSize = component.type.accept(this);
                if (componentSize == null) {
                    return null;
                }
                sum += componentSize.intValue();
                ++n2;
            }
            return sum;
        }

        @Override
        public Integer visit(StringType b) {
            return null;
        }

        @Override
        public Integer visit(UnionType b) {
            Integer commonComponentSize = null;
            Component[] componentArray = b.components;
            int n = b.components.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                Integer componentSize = component.type.accept(this);
                if (componentSize == null) {
                    return null;
                }
                if (commonComponentSize == null) {
                    commonComponentSize = componentSize;
                } else if (!commonComponentSize.equals(componentSize)) {
                    return null;
                }
                ++n2;
            }
            if (commonComponentSize == null) {
                return 0;
            }
            return commonComponentSize + Endian.getUIntLength(b.components.length - 1);
        }

        @Override
        public Integer visit(VariantType b) {
            return null;
        }

        @Override
        public Integer visit(MapType b) {
            return null;
        }
    };

    private void indentation() {
        int i = 0;
        while (i < this.indentation) {
            this.out.print("  ");
            ++i;
        }
    }

    public DataSerializationDebugger(DataReader in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    public void expect(Datatype datatype) throws IOException {
        if (datatype instanceof BooleanType) {
            this.expectBoolean();
        } else if (datatype instanceof ByteType) {
            this.expectByte();
        } else if (datatype instanceof IntegerType) {
            this.expectInteger();
        } else if (datatype instanceof LongType) {
            this.expectLong();
        } else if (datatype instanceof FloatType) {
            this.expectFloat();
        } else if (datatype instanceof DoubleType) {
            this.expectDouble();
        } else if (datatype instanceof StringType) {
            this.expectString();
        } else if (datatype instanceof RecordType) {
            this.expectRecord((RecordType)datatype);
        } else if (datatype instanceof ArrayType) {
            this.expectArray((ArrayType)datatype);
        } else if (datatype instanceof MapType) {
            this.expectMap((MapType)datatype);
        } else if (datatype instanceof OptionalType) {
            this.expectOptional((OptionalType)datatype);
        } else if (datatype instanceof UnionType) {
            this.expectUnion((UnionType)datatype);
        } else if (datatype instanceof VariantType) {
            this.expectVariant();
        }
    }

    private void expectVariant() throws IOException {
        this.out.print("Variant:");
        Datatype datatype = this.in.readDatatype();
        this.out.println(" " + datatype);
        ++this.indentation;
        this.indentation();
        this.expect(datatype);
        --this.indentation;
    }

    private void expectUnion(UnionType datatype) throws IOException {
        this.out.print("Union");
        int tag = this.in.readUnionTag(datatype.getComponentCount());
        Component component = datatype.getComponent(tag);
        this.out.print("(" + component.name + "): ");
        this.expect(component.type);
    }

    private void expectOptional(OptionalType datatype) throws IOException {
        this.out.print("Optional: ");
        if (this.in.beginOptional()) {
            this.expect(datatype.componentType);
        } else {
            this.out.println("null");
        }
    }

    private void expectMap(MapType datatype) throws IOException {
        this.out.print("Map");
        int length = this.in.beginMap();
        this.out.println("(" + length + "):");
        ++this.indentation;
        int i = 0;
        while (i < length) {
            this.indentation();
            this.out.print(String.valueOf(i) + "-key: ");
            this.expect(datatype.keyType);
            this.indentation();
            this.out.print(String.valueOf(i) + "-value: ");
            this.expect(datatype.valueType);
            ++i;
        }
        --this.indentation;
    }

    private static int getFixedLength(ArrayType b) {
        Range length = b.getLength();
        return length.getLower().getValue().intValue();
    }

    private void expectArray(ArrayType datatype) throws IOException {
        this.out.print("Array");
        int length = datatype.accept(FIXED_SIZE) == null ? this.in.beginVariableLengthArray() : DataSerializationDebugger.getFixedLength(datatype);
        this.out.println("(" + length + "):");
        ++this.indentation;
        int i = 0;
        while (i < length) {
            this.indentation();
            this.out.print(i);
            this.out.print(": ");
            this.expect(datatype.componentType);
            ++i;
        }
        --this.indentation;
    }

    private void expectRecord(RecordType datatype) throws IOException {
        this.out.print("Record:");
        if (datatype.isReferable()) {
            int ref = this.in.readReferableRecordReference();
            if (ref != 0) {
                this.out.println(" old " + ref);
                return;
            }
            this.out.println(" new");
        } else {
            this.out.println();
        }
        ++this.indentation;
        Component[] componentArray = datatype.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.indentation();
            this.out.print(component.name);
            this.out.print(": ");
            this.expect(component.type);
            ++n2;
        }
        --this.indentation;
    }

    private void expectString() throws IOException {
        this.out.print("String");
        int length = this.in.readStringLength();
        this.out.print("(" + length + "): ");
        this.out.println(this.in.readStringContent(length));
    }

    private void expectDouble() throws IOException {
        this.out.print("Double: ");
        this.out.println(this.in.readDouble());
    }

    private void expectFloat() throws IOException {
        this.out.print("Float: ");
        this.out.println(this.in.readFloat());
    }

    private void expectLong() throws IOException {
        this.out.print("Long: ");
        this.out.println(this.in.readLong());
    }

    private void expectInteger() throws IOException {
        this.out.print("Integer: ");
        this.out.println(this.in.readInteger());
    }

    private void expectByte() throws IOException {
        this.out.print("Byte: ");
        this.out.println(this.in.readByte());
    }

    private void expectBoolean() throws IOException {
        this.out.print("Boolean: ");
        this.out.println(this.in.readBoolean());
    }
}

