/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.util.IsReferableQuery;
import org.simantics.databoard.binding.util.Result;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;

public class OptionalSerializer
extends Serializer.CompositeSerializer {
    OptionalBinding binding;
    public Serializer componentSerializer;
    boolean componentImmutable;
    Integer fixedSize;

    public OptionalSerializer(OptionalBinding binding, Serializer componentSerializer) {
        super(IsReferableQuery.isReferable(binding.type()) != Result.No);
        this.componentSerializer = componentSerializer;
        this.binding = binding;
        this.componentImmutable = binding.getComponentBinding().isImmutable();
    }

    @Override
    public void finalizeConstruction() {
        Integer fixedSizeOfComponent = this.componentSerializer.getConstantSize();
        if (fixedSizeOfComponent != null && fixedSizeOfComponent == 0) {
            this.fixedSize = fixedSizeOfComponent + 1;
        }
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            byte x = in.readByte();
            if (x == 0) {
                return this.binding.createNoValue();
            }
            if (x == 1) {
                Object componentValue = this.componentSerializer.deserialize(in, identities);
                return this.binding.createValue(componentValue);
            }
            throw new SerializationException("Unexpected marker for option " + x + " 0 or 1 expected.");
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        block7: {
            try {
                byte x = in.readByte();
                if (x == 0) {
                    if (this.binding.hasValue(obj)) {
                        this.binding.setNoValue(obj);
                    }
                    break block7;
                }
                if (x == 1) {
                    if (this.componentImmutable) {
                        Object component = this.componentSerializer.deserialize(in, identities);
                        this.binding.setValue(obj, component);
                    } else {
                        Object component = this.binding.hasValue(obj) ? this.binding.getValue(obj) : this.binding.componentBinding.createDefault();
                        component = this.componentSerializer.deserializeToTry(in, identities, component);
                        this.binding.setValue(obj, component);
                    }
                    break block7;
                }
                throw new SerializationException("Unexpected marker for option " + x + " 0 or 1 expected.");
            }
            catch (BindingException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException, SerializationException {
        byte x = in.readByte();
        if (x == 1) {
            this.componentSerializer.skip(in, identities);
        }
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
        try {
            if (!this.binding.hasValue(obj)) {
                out.write(0);
            } else {
                out.write(1);
                Object componentValue = this.binding.getValue(obj);
                this.componentSerializer.serialize(out, identities, componentValue);
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        block4: {
            try {
                if (this.fixedSize != null) {
                    return this.fixedSize;
                }
                if (this.binding.hasValue(obj)) break block4;
                return 1;
            }
            catch (BindingException e) {
                throw new IOException(e);
            }
        }
        Object componentValue = this.binding.getValue(obj);
        return 1 + this.componentSerializer.getSize(componentValue, identities);
    }

    @Override
    public int getMinSize() {
        return 1;
    }
}

