/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.method.AsyncResultImpl;
import org.simantics.databoard.method.ConnectionClosedException;
import org.simantics.databoard.method.Handshake;
import org.simantics.databoard.method.Interface;
import org.simantics.databoard.method.InvokeException;
import org.simantics.databoard.method.MessageOverflowException;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.MethodNotSupportedException;
import org.simantics.databoard.method.MethodType;
import org.simantics.databoard.method.MethodTypeBinding;
import org.simantics.databoard.method.MethodTypeDefinition;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.util.binary.BinaryReadable;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.InputStreamReadable;
import org.simantics.databoard.util.binary.OutputStreamWriteable;

public class TcpConnection
implements MethodInterface {
    public static final ExecutorService SHARED_EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 100L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    static final Serializer MESSAGE_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.getBindingUnchecked(Message.class));
    static Charset UTF8 = Charset.forName("UTF8");
    Handshake local;
    Handshake remote;
    Interface remoteType;
    MethodTypeDefinition[] localMethods;
    MethodTypeDefinition[] remoteMethods;
    HashMap<MethodTypeDefinition, Integer> localMethodsMap;
    HashMap<MethodTypeDefinition, Integer> remoteMethodsMap;
    Socket socket;
    boolean active = true;
    MethodInterface methodInterface;
    ConcurrentHashMap<Integer, PendingRequest> requests = new ConcurrentHashMap();
    List<Object> inIdentities = new ArrayList<Object>();
    BinaryReadable in;
    int maxRecvSize;
    public ExecutorService writeExecutor = SHARED_EXECUTOR_SERVICE;
    TObjectIntHashMap<Object> outIdentities = new TObjectIntHashMap();
    BinaryWriteable out;
    AtomicInteger requestCounter = new AtomicInteger(0);
    int maxSendSize;
    Map<String, MethodType> methodTypes = new ConcurrentHashMap<String, MethodType>();
    CopyOnWriteArrayList<ConnectionListener> listeners = new CopyOnWriteArrayList();
    ConnectionThread thread = new ConnectionThread();

    public static Handshake handshake(Socket socket, final Handshake localData) throws IOException {
        InputStreamReadable bin = new InputStreamReadable(socket.getInputStream(), Long.MAX_VALUE);
        final OutputStreamWriteable bout = new OutputStreamWriteable(socket.getOutputStream());
        ExecutorService writeExecutor = SHARED_EXECUTOR_SERVICE;
        final Exception[] writeError = new Exception[1];
        final Semaphore s = new Semaphore(0);
        writeExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        TObjectIntHashMap outIdentities = new TObjectIntHashMap();
                        Handshake.SERIALIZER.serialize(bout, (TObjectIntHashMap<Object>)outIdentities, localData);
                        bout.flush();
                        outIdentities.clear();
                    }
                    catch (IOException e) {
                        writeError[0] = e;
                        s.release(1);
                    }
                }
                finally {
                    s.release(1);
                }
            }
        });
        ArrayList<Object> inIdentities = new ArrayList<Object>();
        Handshake result = (Handshake)Handshake.SERIALIZER.deserialize(bin, inIdentities);
        inIdentities.clear();
        try {
            s.acquire(1);
            Exception e = writeError[0];
            if (e != null && e instanceof IOException) {
                throw (IOException)e;
            }
            if (e != null) {
                throw new RuntimeException(e);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public TcpConnection(Socket socket, MethodInterface methodInterface, Handshake localData, Handshake remoteData) throws IOException {
        if (socket == null || localData == null || remoteData == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.methodInterface = methodInterface;
        this.socket = socket;
        this.local = localData;
        this.remote = remoteData;
        this.maxSendSize = Math.min(localData.sendMsgLimit, remoteData.recvMsgLimit);
        this.maxRecvSize = Math.min(localData.recvMsgLimit, remoteData.sendMsgLimit);
        this.localMethods = this.local.methods;
        this.remoteMethods = this.remote.methods;
        this.remoteType = new Interface(this.remoteMethods);
        this.localMethodsMap = new HashMap();
        this.remoteMethodsMap = new HashMap();
        int i = 0;
        while (i < this.localMethods.length) {
            this.localMethodsMap.put(this.localMethods[i], i);
            ++i;
        }
        i = 0;
        while (i < this.remoteMethods.length) {
            this.remoteMethodsMap.put(this.remoteMethods[i], i);
            ++i;
        }
        this.in = new InputStreamReadable(socket.getInputStream(), Long.MAX_VALUE);
        this.out = new OutputStreamWriteable(socket.getOutputStream());
        String threadName = "Connection-" + socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
        this.thread.setName(threadName);
        this.thread.start();
    }

    @Override
    public Interface getInterface() {
        return this.remoteType;
    }

    @Override
    public MethodInterface.Method getMethod(MethodTypeBinding binding) throws MethodNotSupportedException {
        MethodTypeDefinition description = binding.getMethodDefinition();
        if (!this.remoteMethodsMap.containsKey(description)) {
            throw new MethodNotSupportedException(description.getName());
        }
        int id = this.remoteMethodsMap.get(description);
        try {
            return new MethodImpl(id, binding);
        }
        catch (SerializerConstructionException e) {
            throw new MethodNotSupportedException(e);
        }
    }

    @Override
    public MethodInterface.Method getMethod(MethodTypeDefinition description) throws MethodNotSupportedException {
        if (!this.remoteMethodsMap.containsKey(description)) {
            throw new MethodNotSupportedException(description.getName());
        }
        int id = this.remoteMethodsMap.get(description);
        RecordBinding reqBinding = (RecordBinding)Bindings.getMutableBinding(description.getType().getRequestType());
        Object resBinding = Bindings.getMutableBinding(description.getType().getResponseType());
        UnionBinding errBinding = (UnionBinding)Bindings.getMutableBinding(description.getType().getErrorType());
        MethodTypeBinding binding = new MethodTypeBinding(description, reqBinding, (Binding)resBinding, errBinding);
        try {
            return new MethodImpl(id, binding);
        }
        catch (SerializerConstructionException e) {
            throw new MethodNotSupportedException(e);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    void setClosed() {
        for (ConnectionListener listener : this.listeners) {
            listener.onClosed();
        }
    }

    void setError(Exception e) {
        for (ConnectionListener listener : this.listeners) {
            listener.onError(e);
        }
        this.close();
    }

    public MethodInterface getLocalMethodInterface() {
        return this.methodInterface;
    }

    public MethodTypeDefinition[] getLocalMethodDescriptions() {
        return this.localMethods;
    }

    public MethodInterface getRemoteMethodInterface() {
        return this;
    }

    public void close() {
        this.active = false;
        ArrayList<PendingRequest> reqs = new ArrayList<PendingRequest>(this.requests.values());
        for (PendingRequest pr : reqs) {
            pr.setInvokeException(new InvokeException(new ConnectionClosedException()));
        }
        this.requests.values().removeAll(reqs);
        this.thread.interrupt();
    }

    public static TcpConnection getCurrentConnection() {
        Thread t = Thread.currentThread();
        if (!(t instanceof ConnectionThread)) {
            return null;
        }
        ConnectionThread ct = (ConnectionThread)t;
        return ct.getConnection();
    }

    public static interface ConnectionListener {
        public void onError(Exception var1);

        public void onClosed();
    }

    class ConnectionThread
    extends Thread {
        public ConnectionThread() {
            this.setDaemon(true);
        }

        public TcpConnection getConnection() {
            return TcpConnection.this;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    int size;
                    PendingRequest req;
                    int requestId;
                    Message header = (Message)MESSAGE_SERIALIZER.deserialize(TcpConnection.this.in, TcpConnection.this.inIdentities);
                    if (header instanceof RequestHeader) {
                        final RequestHeader reqHeader = (RequestHeader)header;
                        int size2 = TcpConnection.this.in.readInt();
                        if (size2 > TcpConnection.this.maxRecvSize) {
                            TcpConnection.this.setError(new MessageOverflowException());
                            return;
                        }
                        int methodId = reqHeader.methodId;
                        if (methodId < 0 || methodId >= TcpConnection.this.localMethods.length) {
                            TcpConnection.this.setError(new Exception("ProtocolError"));
                            return;
                        }
                        MethodTypeDefinition methodDescription = TcpConnection.this.localMethods[methodId];
                        try {
                            MethodInterface.Method method = TcpConnection.this.methodInterface.getMethod(methodDescription);
                            final MethodTypeBinding methodBinding = method.getMethodBinding();
                            Object request = Bindings.getSerializerUnchecked(methodBinding.getRequestBinding()).deserialize(TcpConnection.this.in, TcpConnection.this.inIdentities);
                            TcpConnection.this.inIdentities.clear();
                            method.invoke(request).setListener(new MethodInterface.InvokeListener(){

                                @Override
                                public void onCompleted(final Object response) {
                                    ((ConnectionThread)ConnectionThread.this).TcpConnection.this.writeExecutor.execute(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            TcpConnection tcpConnection = TcpConnection.this;
                                            synchronized (tcpConnection) {
                                                try {
                                                    Serializer serializer = Bindings.getSerializerUnchecked(methodBinding.getResponseBinding());
                                                    int size = serializer.getSize(response, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    if (size > ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.maxSendSize) {
                                                        ResponseTooLargeError tooLarge = new ResponseTooLargeError();
                                                        tooLarge.requestId = reqHeader.requestId;
                                                        MESSAGE_SERIALIZER.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, tooLarge);
                                                        ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                        return;
                                                    }
                                                    ResponseHeader respHeader = new ResponseHeader();
                                                    respHeader.requestId = reqHeader.requestId;
                                                    MESSAGE_SERIALIZER.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, respHeader);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out.writeInt(size);
                                                    serializer.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, response);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out.flush();
                                                }
                                                catch (IOException e) {
                                                    TcpConnection.this.setError(e);
                                                }
                                                catch (RuntimeException e) {
                                                    TcpConnection.this.setError(e);
                                                }
                                            }
                                        }
                                    });
                                }

                                @Override
                                public void onException(final Exception cause) {
                                    ((ConnectionThread)ConnectionThread.this).TcpConnection.this.writeExecutor.execute(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            TcpConnection tcpConnection = TcpConnection.this;
                                            synchronized (tcpConnection) {
                                                try {
                                                    Exception_ msg = new Exception_();
                                                    msg.message = String.valueOf(cause.getClass().getName()) + ": " + cause.getMessage();
                                                    MESSAGE_SERIALIZER.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, msg);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out.flush();
                                                }
                                                catch (IOException e) {
                                                    TcpConnection.this.setError(e);
                                                }
                                                catch (RuntimeException e) {
                                                    TcpConnection.this.setError(e);
                                                }
                                            }
                                        }
                                    });
                                }

                                @Override
                                public void onExecutionError(final Object error) {
                                    ((ConnectionThread)ConnectionThread.this).TcpConnection.this.writeExecutor.execute(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            TcpConnection tcpConnection = TcpConnection.this;
                                            synchronized (tcpConnection) {
                                                try {
                                                    Serializer serializer = Bindings.getSerializerUnchecked(methodBinding.getErrorBinding());
                                                    int size = serializer.getSize(error, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    if (size > ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.maxSendSize) {
                                                        ResponseTooLargeError tooLarge = new ResponseTooLargeError();
                                                        tooLarge.requestId = reqHeader.requestId;
                                                        MESSAGE_SERIALIZER.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, tooLarge);
                                                        ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                        return;
                                                    }
                                                    ExecutionError_ errorHeader = new ExecutionError_();
                                                    errorHeader.requestId = reqHeader.requestId;
                                                    MESSAGE_SERIALIZER.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, errorHeader);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out.writeInt(size);
                                                    serializer.serialize(((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities, error);
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                                    ((ConnectionThread)(this).ConnectionThread.this).TcpConnection.this.out.flush();
                                                }
                                                catch (IOException e) {
                                                    TcpConnection.this.setError(e);
                                                }
                                                catch (RuntimeException e) {
                                                    TcpConnection.this.setError(e);
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        catch (MethodNotSupportedException methodNotSupportedException) {
                            TcpConnection.this.in.skipBytes(size2);
                            final InvalidMethodError error = new InvalidMethodError();
                            error.requestId = reqHeader.requestId;
                            TcpConnection.this.writeExecutor.execute(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    TcpConnection tcpConnection = TcpConnection.this;
                                    synchronized (tcpConnection) {
                                        try {
                                            MESSAGE_SERIALIZER.serialize(((ConnectionThread)ConnectionThread.this).TcpConnection.this.out, ((ConnectionThread)ConnectionThread.this).TcpConnection.this.outIdentities, error);
                                            ((ConnectionThread)ConnectionThread.this).TcpConnection.this.outIdentities.clear();
                                            ((ConnectionThread)ConnectionThread.this).TcpConnection.this.out.flush();
                                        }
                                        catch (IOException e) {
                                            TcpConnection.this.setError(e);
                                        }
                                        catch (RuntimeException e) {
                                            TcpConnection.this.setError(e);
                                        }
                                    }
                                }
                            });
                        }
                        continue;
                    }
                    if (header instanceof ResponseHeader) {
                        requestId = ((ResponseHeader)header).requestId;
                        req = TcpConnection.this.requests.remove(requestId);
                        if (req == null) {
                            TcpConnection.this.setError(new RuntimeException("Request by id " + requestId + " does not exist"));
                            return;
                        }
                        size = TcpConnection.this.in.readInt();
                        Object response = req.method.responseSerializer.deserialize(TcpConnection.this.in, TcpConnection.this.inIdentities);
                        TcpConnection.this.inIdentities.clear();
                        req.setResponse(response);
                        continue;
                    }
                    if (header instanceof ExecutionError_) {
                        requestId = ((ExecutionError_)header).requestId;
                        req = TcpConnection.this.requests.remove(requestId);
                        if (req == null) {
                            TcpConnection.this.setError(new RuntimeException("Request by id " + requestId + " does not exist"));
                            return;
                        }
                        size = TcpConnection.this.in.readInt();
                        Object executionError = req.method.errorSerializer.deserialize(TcpConnection.this.in, TcpConnection.this.inIdentities);
                        TcpConnection.this.inIdentities.clear();
                        req.setExecutionError(executionError);
                        continue;
                    }
                    if (header instanceof Exception_) {
                        requestId = ((Exception_)header).requestId;
                        req = TcpConnection.this.requests.remove(requestId);
                        req.setExecutionError(new Exception(((Exception_)header).message));
                        continue;
                    }
                    if (header instanceof InvalidMethodError) {
                        requestId = ((InvalidMethodError)header).requestId;
                        req = TcpConnection.this.requests.remove(requestId);
                        req.setInvokeException(new InvokeException(new MethodNotSupportedException("?")));
                        continue;
                    }
                    if (!(header instanceof ResponseTooLargeError)) continue;
                    requestId = ((ResponseTooLargeError)header).requestId;
                    req = TcpConnection.this.requests.remove(requestId);
                    req.setInvokeException(new InvokeException(new MessageOverflowException()));
                }
                catch (EOFException eOFException) {
                    TcpConnection.this.setClosed();
                    break;
                }
                catch (SocketException e) {
                    if (e.getMessage().equals("Socket Closed")) {
                        TcpConnection.this.setClosed();
                        break;
                    }
                    TcpConnection.this.setError(e);
                    break;
                }
                catch (IOException e) {
                    TcpConnection.this.setError(e);
                    break;
                }
            }
            try {
                TcpConnection.this.socket.close();
            }
            catch (IOException iOException) {}
            TcpConnection.this.close();
        }
    }

    public static class Exception_
    extends Message {
        public int requestId;
        public String message;
    }

    public static class ExecutionError_
    extends Message {
        public int requestId;
    }

    public static class InvalidMethodError
    extends Message {
        public int requestId;
    }

    @Union(value={RequestHeader.class, ResponseHeader.class, ExecutionError_.class, Exception_.class, InvalidMethodError.class, ResponseTooLargeError.class})
    public static class Message {
    }

    class MethodImpl
    implements MethodInterface.Method {
        int methodId;
        MethodTypeBinding methodBinding;
        Serializer responseSerializer;
        Serializer requestSerializer;
        Serializer errorSerializer;

        MethodImpl(int methodId, MethodTypeBinding methodBinding) throws SerializerConstructionException {
            this.methodId = methodId;
            this.methodBinding = methodBinding;
            this.requestSerializer = Bindings.getSerializer(methodBinding.getRequestBinding());
            this.responseSerializer = Bindings.getSerializer(methodBinding.getResponseBinding());
            this.errorSerializer = Bindings.getSerializer(methodBinding.getErrorBinding());
        }

        @Override
        public MethodInterface.AsyncResult invoke(final Object request) {
            final PendingRequest result = new PendingRequest(this, TcpConnection.this.requestCounter.getAndIncrement());
            TcpConnection.this.requests.put(result.requestId, result);
            if (!TcpConnection.this.active) {
                result.setInvokeException(new InvokeException(new ConnectionClosedException()));
            } else {
                TcpConnection.this.writeExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        TcpConnection tcpConnection = TcpConnection.this;
                        synchronized (tcpConnection) {
                            try {
                                int size = MethodImpl.this.requestSerializer.getSize(request, ((MethodImpl)MethodImpl.this).TcpConnection.this.outIdentities);
                                if (size > ((MethodImpl)MethodImpl.this).TcpConnection.this.maxSendSize) {
                                    result.setInvokeException(new InvokeException(new MessageOverflowException()));
                                    return;
                                }
                                ((MethodImpl)MethodImpl.this).TcpConnection.this.outIdentities.clear();
                                RequestHeader reqHeader = new RequestHeader();
                                reqHeader.methodId = MethodImpl.this.methodId;
                                reqHeader.requestId = result.requestId;
                                MESSAGE_SERIALIZER.serialize(((MethodImpl)MethodImpl.this).TcpConnection.this.out, ((MethodImpl)MethodImpl.this).TcpConnection.this.outIdentities, reqHeader);
                                ((MethodImpl)MethodImpl.this).TcpConnection.this.outIdentities.clear();
                                ((MethodImpl)MethodImpl.this).TcpConnection.this.out.writeInt(size);
                                MethodImpl.this.requestSerializer.serialize(((MethodImpl)MethodImpl.this).TcpConnection.this.out, ((MethodImpl)MethodImpl.this).TcpConnection.this.outIdentities, request);
                                ((MethodImpl)MethodImpl.this).TcpConnection.this.outIdentities.clear();
                                ((MethodImpl)MethodImpl.this).TcpConnection.this.out.flush();
                            }
                            catch (IOException e) {
                                result.setInvokeException(new InvokeException(e));
                            }
                            catch (RuntimeException e) {
                                result.setInvokeException(new InvokeException(e));
                            }
                        }
                    }
                });
            }
            return result;
        }

        @Override
        public MethodTypeBinding getMethodBinding() {
            return this.methodBinding;
        }
    }

    class PendingRequest
    extends AsyncResultImpl {
        MethodImpl method;
        int requestId;

        public PendingRequest(MethodImpl method, int requestId) {
            this.method = method;
            this.requestId = requestId;
        }
    }

    public static class RequestHeader
    extends Message {
        public int requestId;
        public int methodId;
    }

    public static class ResponseHeader
    extends Message {
        public int requestId;
    }

    public static class ResponseTooLargeError
    extends Message {
        public int requestId;
    }
}

