/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Methods;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.method.AsyncResultImpl;
import org.simantics.databoard.method.Interface;
import org.simantics.databoard.method.InvokeException;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.MethodNotSupportedException;
import org.simantics.databoard.method.MethodType;
import org.simantics.databoard.method.MethodTypeBinding;
import org.simantics.databoard.method.MethodTypeDefinition;

public class MethodInterfaceUtil {
    public static Comparator<Method> methodComparator = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static <T> MethodInterface bindInterface(Class<T> interfaze, T obj) throws BindingConstructionException {
        Interface interfaceType = Methods.getInterfaceType(interfaze);
        MethodInterface mi = MethodInterfaceUtil.bindInterface(interfaceType, obj);
        return mi;
    }

    public static <T> MethodInterface bindInterface(final Interface interfaceType, final T obj) throws BindingConstructionException {
        int len = interfaceType.getMethodDefinitions().length;
        final MethodTypeDefinition[] methodDefinitions = interfaceType.getMethodDefinitions();
        final MethodTypeBinding[] methodBindings = new MethodTypeBinding[len];
        final Method[] methods = new Method[len];
        Class<?> clazz = obj.getClass();
        Method[] classMethods = clazz.getMethods();
        int i = 0;
        while (i < len) {
            MethodTypeDefinition def = methodDefinitions[i];
            MethodType type = def.getType();
            String name = def.getName();
            Method[] methodArray = classMethods;
            int n = classMethods.length;
            int n2 = 0;
            while (n2 < n) {
                MethodTypeBinding classMethodTypeBinding;
                Method m = methodArray[n2];
                if (m.getName().equals(name) && (classMethodTypeBinding = Methods.getMethodTypeBinding(m)).getMethodType().equals(type)) {
                    m.setAccessible(true);
                    methodBindings[i] = classMethodTypeBinding;
                    methods[i] = m;
                    break;
                }
                ++n2;
            }
            if (methods[i] == null) {
                throw new BindingConstructionException("Could not find method " + def + " in " + clazz.getSimpleName());
            }
            ++i;
        }
        MethodInterface mi = new MethodInterface(){

            @Override
            public MethodInterface.Method getMethod(MethodTypeDefinition description) throws MethodNotSupportedException {
                int index = -1;
                int i = 0;
                while (i < methodDefinitions.length) {
                    if (methodDefinitions[i].equals(description)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index < 0) {
                    throw new MethodNotSupportedException(description.getName());
                }
                final MethodTypeBinding binding = methodBindings[index];
                final Method method = methods[index];
                MethodInterface.Method m = new MethodInterface.Method(){

                    @Override
                    public MethodTypeBinding getMethodBinding() {
                        return binding;
                    }

                    @Override
                    public MethodInterface.AsyncResult invoke(Object request) {
                        AsyncResultImpl result = new AsyncResultImpl();
                        try {
                            Object response = method.invoke(obj, (Object[])request);
                            if (response != null) {
                                result.setResponse(response);
                            } else {
                                result.setInvokeException(new InvokeException(new NullPointerException()));
                            }
                        }
                        catch (InvocationTargetException t) {
                            Throwable e = t.getTargetException();
                            if (e instanceof RuntimeException) {
                                result.setInvokeException(new InvokeException((Exception)e));
                            } else {
                                result.setExecutionError(e);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            result.setInvokeException(new InvokeException(e));
                        }
                        catch (IllegalAccessException e) {
                            result.setInvokeException(new InvokeException(e));
                        }
                        return result;
                    }
                };
                return m;
            }

            @Override
            public MethodInterface.Method getMethod(MethodTypeBinding binding) throws MethodNotSupportedException {
                MethodTypeDefinition description = binding.getMethodDefinition();
                int index = -1;
                int i = 0;
                while (i < methodDefinitions.length) {
                    if (methodDefinitions[i].equals(description)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index < 0) {
                    throw new MethodNotSupportedException(description.getName());
                }
                MethodTypeBinding producerBinding = methodBindings[index];
                final MethodTypeBinding consumerBinding = binding;
                try {
                    final Adapter requestAdapter = Bindings.getTypeAdapter(consumerBinding.getRequestBinding(), producerBinding.getRequestBinding());
                    final Adapter responseAdapter = Bindings.getTypeAdapter(producerBinding.getResponseBinding(), consumerBinding.getResponseBinding());
                    final Adapter errorAdapter = Bindings.getTypeAdapter(producerBinding.getErrorBinding(), consumerBinding.getErrorBinding());
                    final Method method = methods[index];
                    MethodInterface.Method m = new MethodInterface.Method(){

                        @Override
                        public MethodTypeBinding getMethodBinding() {
                            return consumerBinding;
                        }

                        @Override
                        public MethodInterface.AsyncResult invoke(Object request) {
                            AsyncResultImpl result = new AsyncResultImpl();
                            try {
                                request = requestAdapter.adapt(request);
                                Object response = method.invoke(obj, (Object[])request);
                                response = responseAdapter.adapt(response);
                                result.setResponse(response);
                            }
                            catch (AdaptException e1) {
                                result.setInvokeException(new InvokeException(e1));
                            }
                            catch (InvocationTargetException t) {
                                try {
                                    Object error = errorAdapter.adapt(t.getCause());
                                    result.setExecutionError(error);
                                }
                                catch (AdaptException e) {
                                    result.setInvokeException(new InvokeException(e));
                                }
                            }
                            catch (IllegalArgumentException e) {
                                result.setInvokeException(new InvokeException(e));
                            }
                            catch (IllegalAccessException e) {
                                result.setInvokeException(new InvokeException(e));
                            }
                            return result;
                        }
                    };
                    return m;
                }
                catch (AdapterConstructionException e1) {
                    throw new MethodNotSupportedException("Could not adapt method " + e1.getMessage(), e1);
                }
            }

            @Override
            public Interface getInterface() {
                return interfaceType;
            }
        };
        return mi;
    }

    public static <T> T createProxy(Class<T> interfaze, MethodInterface mi) throws BindingConstructionException {
        StubClassLoader cl = new StubClassLoader(interfaze.getClassLoader());
        try {
            Class<?> virhe = cl.loadClass(String.valueOf(interfaze.getName()) + "_Stub");
            Constructor<?> c = virhe.getConstructor(MethodInterface.class);
            return (T)c.newInstance(mi);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Did you remember to include org.objectweb.asm ??");
            throw new BindingConstructionException(e);
        }
        catch (SecurityException e) {
            throw new BindingConstructionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BindingConstructionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingConstructionException(e);
        }
        catch (InstantiationException e) {
            throw new BindingConstructionException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingConstructionException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingConstructionException(e.getCause());
        }
    }

    public static MethodInterface adaptMethods(MethodInterface mi, MethodTypeDefinition[] rangeMethods) {
        throw new IllegalArgumentException("To be implemented");
    }

    static class StubClassLoader
    extends ClassLoader {
        public StubClassLoader() {
            super(Thread.currentThread().getContextClassLoader());
        }

        public StubClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.endsWith("_Stub")) {
                Class<?> interfaze = this.loadClass(name.substring(0, name.length() - 5));
                ClassWriter cw = new ClassWriter(0);
                this.createImpl(name, interfaze, cw);
                byte[] b = cw.toByteArray();
                Class<?> clazz = this.defineClass(name, b, 0, b.length);
                return clazz;
            }
            return super.findClass(name);
        }

        static String toTypeDescriptor(Class<?> clazz) {
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz.isArray()) {
                return clazz.getName().replaceAll("\\.", "/");
            }
            return "L" + clazz.getName().replaceAll("\\.", "/") + ";";
        }

        /*
         * WARNING - void declaration
         */
        void createImpl(String className, Class<?> interfaze, ClassWriter cw) {
            Method[] methods = interfaze.getMethods();
            Arrays.sort(methods, methodComparator);
            String classResourceName = className.replaceAll("\\.", "/");
            String classTypeDescriptor = "L" + classResourceName + ";";
            String interfaceResourceName = classResourceName.substring(0, classResourceName.length() - 5);
            String interfaceTypeDescriptor = "L" + interfaceResourceName + ";";
            cw.visit(50, 33, classResourceName, null, "java/lang/Object", new String[]{interfaceResourceName});
            HashSet imports = new HashSet();
            imports.add(MethodInterface.AsyncResult.class);
            imports.add(MethodInterface.ExecutionError.class);
            imports.add(Method.class);
            imports.add(interfaze);
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz;
                Method method = methodArray[n2];
                Class<?>[] classArray = method.getExceptionTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    clazz = classArray[n4];
                    imports.add(clazz);
                    ++n4;
                }
                classArray = method.getParameterTypes();
                n3 = classArray.length;
                n4 = 0;
                while (n4 < n3) {
                    clazz = classArray[n4];
                    imports.add(clazz);
                    ++n4;
                }
                imports.add(method.getReturnType());
                ++n2;
            }
            for (Class clazz : imports) {
                String name;
                if (clazz.isPrimitive() || (name = clazz.getName()).startsWith("java.lang")) continue;
                String resourceName = name.replaceAll("\\.", "/");
                String outerName = resourceName.contains("$") ? resourceName.substring(0, resourceName.indexOf(36)) : null;
                String className_ = clazz.isArray() ? clazz.getSimpleName().substring(0, clazz.getSimpleName().length() - 2) : clazz.getSimpleName();
                int access = 9 + (clazz.isInterface() ? 1536 : 0);
                cw.visitInnerClass(resourceName, outerName, className_, access);
            }
            FieldVisitor fv = cw.visitField(24, "interfaze", "Ljava/lang/Class;", "Ljava/lang/Class<*>;", null);
            fv.visitEnd();
            fv = cw.visitField(24, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;", null, null);
            fv.visitEnd();
            fv = cw.visitField(0, "mi", "Lorg/simantics/databoard/method/MethodInterface;", null, null);
            fv.visitEnd();
            fv = cw.visitField(0, "methods", "[Lorg/simantics/databoard/method/MethodInterface$Method;", null, null);
            fv.visitEnd();
            MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            Label label = new Label();
            mv.visitLabel(label);
            mv.visitLdcInsn((Object)Type.getType((String)interfaceTypeDescriptor));
            mv.visitFieldInsn(179, classResourceName, "interfaze", "Ljava/lang/Class;");
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitFieldInsn(178, classResourceName, "interfaze", "Ljava/lang/Class;");
            mv.visitMethodInsn(182, "java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;");
            mv.visitVarInsn(58, 0);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, "org/simantics/databoard/method/MethodInterfaceUtil", "methodComparator", "Ljava/util/Comparator;");
            mv.visitMethodInsn(184, "java/util/Arrays", "sort", "([Ljava/lang/Object;Ljava/util/Comparator;)V");
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(190);
            mv.visitTypeInsn(189, "org/simantics/databoard/method/MethodTypeBinding");
            mv.visitFieldInsn(179, classResourceName, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;");
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitInsn(3);
            mv.visitVarInsn(54, 1);
            Label l5 = new Label();
            mv.visitLabel(l5);
            Label l6 = new Label();
            mv.visitJumpInsn(167, l6);
            Label l7 = new Label();
            mv.visitLabel(l7);
            mv.visitFrame(1, 2, new Object[]{"[Ljava/lang/reflect/Method;", Opcodes.INTEGER}, 0, null);
            mv.visitFieldInsn(178, classResourceName, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;");
            mv.visitVarInsn(21, 1);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(50);
            mv.visitMethodInsn(184, "org/simantics/databoard/Methods", "getMethodTypeBinding", "(Ljava/lang/reflect/Method;)Lorg/simantics/databoard/method/MethodTypeBinding;");
            mv.visitInsn(83);
            Label l8 = new Label();
            mv.visitLabel(l8);
            mv.visitIincInsn(1, 1);
            mv.visitLabel(l6);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(21, 1);
            mv.visitFieldInsn(178, classResourceName, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;");
            mv.visitInsn(190);
            mv.visitJumpInsn(161, l7);
            Label l9 = new Label();
            mv.visitLabel(l9);
            mv.visitInsn(177);
            Label l10 = new Label();
            mv.visitLabel(l10);
            mv.visitLocalVariable("methods", "[Ljava/lang/reflect/Method;", null, l2, l10, 0);
            mv.visitLocalVariable("i", "I", null, l5, l9, 1);
            mv.visitMaxs(4, 2);
            mv.visitEnd();
            mv = cw.visitMethod(1, "<init>", "(Lorg/simantics/databoard/method/MethodInterface;)V", null, new String[]{"org/simantics/databoard/method/MethodNotSupportedException"});
            mv.visitCode();
            Label label2 = new Label();
            mv.visitLabel(label2);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, classResourceName, "mi", "Lorg/simantics/databoard/method/MethodInterface;");
            l2 = new Label();
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, classResourceName, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;");
            mv.visitInsn(190);
            mv.visitTypeInsn(189, "org/simantics/databoard/method/MethodInterface$Method");
            mv.visitFieldInsn(181, classResourceName, "methods", "[Lorg/simantics/databoard/method/MethodInterface$Method;");
            l3 = new Label();
            mv.visitLabel(l3);
            mv.visitInsn(3);
            mv.visitVarInsn(54, 2);
            l4 = new Label();
            mv.visitLabel(l4);
            l5 = new Label();
            mv.visitJumpInsn(167, l5);
            l6 = new Label();
            mv.visitLabel(l6);
            mv.visitFrame(0, 3, new Object[]{classResourceName, "org/simantics/databoard/method/MethodInterface", Opcodes.INTEGER}, 0, new Object[0]);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, classResourceName, "methods", "[Lorg/simantics/databoard/method/MethodInterface$Method;");
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(178, classResourceName, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;");
            mv.visitVarInsn(21, 2);
            mv.visitInsn(50);
            mv.visitMethodInsn(185, "org/simantics/databoard/method/MethodInterface", "getMethod", "(Lorg/simantics/databoard/method/MethodTypeBinding;)Lorg/simantics/databoard/method/MethodInterface$Method;");
            mv.visitInsn(83);
            l7 = new Label();
            mv.visitLabel(l7);
            mv.visitIincInsn(2, 1);
            mv.visitLabel(l5);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(21, 2);
            mv.visitFieldInsn(178, classResourceName, "bindings", "[Lorg/simantics/databoard/method/MethodTypeBinding;");
            mv.visitInsn(190);
            mv.visitJumpInsn(161, l6);
            l8 = new Label();
            mv.visitLabel(l8);
            mv.visitInsn(177);
            l9 = new Label();
            mv.visitLabel(l9);
            mv.visitLocalVariable("this", classTypeDescriptor, null, label2, l9, 0);
            mv.visitLocalVariable("mi", "Lorg/simantics/databoard/method/MethodInterface;", null, label2, l9, 1);
            mv.visitLocalVariable("i", "I", null, l4, l8, 2);
            mv.visitMaxs(5, 3);
            mv.visitEnd();
            boolean bl = false;
            Method[] methodArray2 = methods;
            int n5 = methods.length;
            int n6 = 0;
            while (n6 < n5) {
                void var12_24;
                Method m = methodArray2[n6];
                String typeDescription = "";
                Class<?>[] params = m.getParameterTypes();
                int i = 0;
                while (i < params.length) {
                    typeDescription = String.valueOf(typeDescription) + StubClassLoader.toTypeDescriptor(params[i]);
                    ++i;
                }
                typeDescription = "(" + typeDescription + ")" + StubClassLoader.toTypeDescriptor(m.getReturnType());
                Class<?>[] exceptions = m.getExceptionTypes();
                String[] exceptionResourceNames = new String[exceptions.length];
                int i2 = 0;
                while (i2 < exceptionResourceNames.length) {
                    exceptionResourceNames[i2] = exceptions[i2].getName().replaceAll("\\.", "/");
                    ++i2;
                }
                int argRegs = 0;
                int i3 = 0;
                while (i3 < params.length) {
                    Class<?> clazz = params[i3];
                    ++argRegs;
                    if (clazz == Long.TYPE || clazz == Double.TYPE) {
                        ++argRegs;
                    }
                    ++i3;
                }
                mv = cw.visitMethod(1, m.getName(), typeDescription, null, exceptionResourceNames);
                mv.visitCode();
                Label l02 = new Label();
                Label l12 = new Label();
                Label l22 = new Label();
                mv.visitTryCatchBlock(l02, l12, l22, "org/simantics/databoard/method/MethodInterface$ExecutionError");
                Label l32 = new Label();
                mv.visitTryCatchBlock(l02, l12, l32, "java/lang/InterruptedException");
                Label l42 = new Label();
                mv.visitLabel(l42);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, classResourceName, "methods", "[Lorg/simantics/databoard/method/MethodInterface$Method;");
                mv.visitLdcInsn((Object)((int)var12_24));
                mv.visitInsn(50);
                mv.visitVarInsn(58, argRegs + 1);
                Label l52 = new Label();
                mv.visitLabel(l52);
                mv.visitLdcInsn((Object)params.length);
                mv.visitTypeInsn(189, "java/lang/Object");
                int register = 1;
                int i4 = 0;
                while (i4 < params.length) {
                    Class<?> clazz = params[i4];
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)i4);
                    if (clazz == Byte.TYPE) {
                        mv.visitVarInsn(21, register++);
                        mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                    } else if (clazz == Character.TYPE) {
                        mv.visitVarInsn(21, register++);
                        mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                    } else if (clazz == Boolean.TYPE) {
                        mv.visitVarInsn(21, register++);
                        mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                    } else if (clazz == Byte.TYPE) {
                        mv.visitVarInsn(21, register++);
                        mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                    } else if (clazz == Integer.TYPE) {
                        mv.visitVarInsn(21, register++);
                        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                    } else if (clazz == Long.TYPE) {
                        mv.visitVarInsn(22, register);
                        register += 2;
                        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(F)Ljava/lang/Long;");
                    } else if (clazz == Float.TYPE) {
                        mv.visitVarInsn(23, register);
                        register += 2;
                        mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                    } else if (clazz == Double.TYPE) {
                        mv.visitVarInsn(24, register);
                        register += 2;
                        mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                    } else {
                        mv.visitVarInsn(25, register++);
                    }
                    mv.visitInsn(83);
                    ++i4;
                }
                mv.visitVarInsn(58, argRegs + 2);
                Label l62 = new Label();
                mv.visitLabel(l62);
                mv.visitVarInsn(25, argRegs + 1);
                mv.visitVarInsn(25, argRegs + 2);
                mv.visitMethodInsn(185, "org/simantics/databoard/method/MethodInterface$Method", "invoke", "(Ljava/lang/Object;)Lorg/simantics/databoard/method/MethodInterface$AsyncResult;");
                mv.visitVarInsn(58, argRegs + 3);
                mv.visitLabel(l02);
                mv.visitVarInsn(25, argRegs + 3);
                mv.visitMethodInsn(185, "org/simantics/databoard/method/MethodInterface$AsyncResult", "waitForResponse", "()Ljava/lang/Object;");
                Class<?> returnType = m.getReturnType();
                if (returnType == Void.TYPE) {
                    mv.visitInsn(87);
                    mv.visitLabel(l12);
                    mv.visitInsn(177);
                } else if (returnType == Integer.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Integer");
                    mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                    mv.visitLabel(l12);
                    mv.visitInsn(172);
                } else if (returnType == Byte.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Byte");
                    mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "B()");
                    mv.visitLabel(l12);
                    mv.visitInsn(172);
                } else if (returnType == Character.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Character");
                    mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                    mv.visitLabel(l12);
                    mv.visitInsn(172);
                } else if (returnType == Boolean.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Boolean");
                    mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                    mv.visitLabel(l12);
                    mv.visitInsn(172);
                } else if (returnType == Short.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Short");
                    mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                    mv.visitLabel(l12);
                    mv.visitInsn(172);
                } else if (returnType == Long.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Long");
                    mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                    mv.visitLabel(l12);
                    mv.visitInsn(173);
                } else if (returnType == Double.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Double");
                    mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                    mv.visitLabel(l12);
                    mv.visitInsn(175);
                } else if (returnType == Float.TYPE) {
                    mv.visitTypeInsn(192, "java/lang/Float");
                    mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                    mv.visitLabel(l12);
                    mv.visitInsn(174);
                } else {
                    mv.visitTypeInsn(192, returnType.getName().replaceAll("\\.", "/"));
                    mv.visitLabel(l12);
                    mv.visitInsn(176);
                }
                mv.visitLabel(l22);
                mv.visitFrame(0, 5, new Object[]{classResourceName, "java/lang/Integer", "org/simantics/databoard/method/MethodInterface$Method", "[Ljava/lang/Object;", "org/simantics/databoard/method/MethodInterface$AsyncResult"}, 1, new Object[]{"org/simantics/databoard/method/MethodInterface$ExecutionError"});
                mv.visitVarInsn(58, argRegs + 4);
                Label l72 = new Label();
                mv.visitLabel(l72);
                mv.visitVarInsn(25, argRegs + 4);
                mv.visitMethodInsn(182, "org/simantics/databoard/method/MethodInterface$ExecutionError", "getError", "()Ljava/lang/Object;");
                mv.visitVarInsn(58, argRegs + 5);
                Class<?>[] exceptionClasses = m.getExceptionTypes();
                Label[] nextException = new Label[exceptionClasses.length];
                int i5 = 0;
                while (i5 < exceptionClasses.length) {
                    Class<?> exceptionClass = exceptionClasses[i5];
                    String exceptionClassResourceName = exceptionClass.getName().replaceAll("\\.", "/");
                    nextException[i5] = new Label();
                    Label l82 = new Label();
                    mv.visitLabel(l82);
                    mv.visitVarInsn(25, argRegs + 5);
                    mv.visitTypeInsn(193, exceptionClassResourceName);
                    mv.visitJumpInsn(153, nextException[i5]);
                    mv.visitVarInsn(25, argRegs + 5);
                    mv.visitTypeInsn(192, exceptionClassResourceName);
                    mv.visitInsn(191);
                    mv.visitLabel(nextException[i5]);
                    ++i5;
                }
                mv.visitFrame(1, 2, new Object[]{"org/simantics/databoard/method/MethodInterface$ExecutionError", "java/lang/Object"}, 0, null);
                mv.visitTypeInsn(187, "java/lang/RuntimeException");
                mv.visitInsn(89);
                mv.visitVarInsn(25, argRegs + 4);
                mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
                mv.visitInsn(191);
                mv.visitLabel(l32);
                mv.visitFrame(0, 5, new Object[]{classResourceName, "java/lang/Integer", "org/simantics/databoard/method/MethodInterface$Method", "[Ljava/lang/Object;", "org/simantics/databoard/method/MethodInterface$AsyncResult"}, 1, new Object[]{"java/lang/InterruptedException"});
                mv.visitVarInsn(58, argRegs + 4);
                Label l102 = new Label();
                mv.visitLabel(l102);
                mv.visitTypeInsn(187, "java/lang/RuntimeException");
                mv.visitInsn(89);
                mv.visitVarInsn(25, argRegs + 4);
                mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
                mv.visitInsn(191);
                Label l11 = new Label();
                mv.visitLabel(l11);
                mv.visitLocalVariable("this", classTypeDescriptor, null, l42, l11, 0);
                register = 1;
                int i6 = 0;
                while (i6 < params.length) {
                    Class<?> clazz = params[i6];
                    mv.visitLocalVariable("arg" + (i6 + 1), StubClassLoader.toTypeDescriptor(clazz), null, l42, l11, register);
                    ++register;
                    if (clazz == Long.TYPE || clazz == Double.TYPE) {
                        ++argRegs;
                    }
                    ++i6;
                }
                mv.visitLocalVariable("m", "Lorg/simantics/databoard/method/MethodInterface$Method;", null, l52, l11, argRegs + 1);
                mv.visitLocalVariable("args", "[Ljava/lang/Object;", null, l62, l11, argRegs + 2);
                mv.visitLocalVariable("result", "Lorg/simantics/databoard/method/MethodInterface$AsyncResult;", null, l02, l11, argRegs + 3);
                mv.visitLocalVariable("e", "Lorg/simantics/databoard/method/MethodInterface$ExecutionError;", null, l72, l32, argRegs + 4);
                mv.visitLocalVariable("cause", "Ljava/lang/Object;", null, l72, l32, argRegs + 5);
                mv.visitLocalVariable("e", "Ljava/lang/InterruptedException;", null, l102, l11, argRegs + 4);
                mv.visitMaxs(argRegs + 3, argRegs + 6);
                mv.visitEnd();
                ++var12_24;
                ++n6;
            }
            cw.visitEnd();
        }
    }
}

