/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.BooleanAccessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.StringAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.TaggedObject;
import org.simantics.databoard.forms.DataboardDialog;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.StringUtil;
import org.simantics.databoard.util.URIUtil;

public class DataboardForm {
    public static final Datatype TEXTBOX;
    public static final Datatype PASSWORD;
    public int column1Width = -1;
    private RecordType allfields = new RecordType();

    static {
        PASSWORD = new StringType();
        DataboardForm.PASSWORD.metadata.put("style", "password");
        TEXTBOX = new StringType();
        DataboardForm.TEXTBOX.metadata.put("style", "multi");
    }

    public static StringType fileSaveDialog(String ... namesAndExts) {
        StringType result = new StringType();
        result.metadata.put("style", "filesave");
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int i = 0;
        while (i < namesAndExts.length) {
            StringBuilder sb = i % 2 == 0 ? sb1 : sb2;
            int j = i / 2;
            if (j > 0) {
                sb.append(',');
            }
            sb.append(namesAndExts[i]);
            ++i;
        }
        result.metadata.put("filetypes", sb1.toString());
        result.metadata.put("fileexts", sb2.toString());
        return result;
    }

    public static StringType fileOpenDialog(String ... namesAndExts) {
        StringType result = new StringType();
        result.metadata.put("style", "fileopen");
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int i = 0;
        while (i < namesAndExts.length) {
            StringBuilder sb = i % 2 == 0 ? sb1 : sb2;
            int j = i / 2;
            if (j > 0) {
                sb.append(',');
            }
            sb.append(namesAndExts[i]);
            ++i;
        }
        result.metadata.put("filetypes", sb1.toString());
        result.metadata.put("fileexts", sb2.toString());
        return result;
    }

    public static StringType directoryDialog() {
        StringType result = new StringType();
        result.metadata.put("style", "directory");
        return result;
    }

    public void setFirstColumnWidth(int width) {
        this.column1Width = width;
    }

    public List<Problem> validate(Composite composite) {
        ArrayList<Problem> result = new ArrayList<Problem>();
        this._validateFields((Control)composite, result);
        return result;
    }

    public static List<String> toStrings(List<Problem> problems) {
        ArrayList<String> result = new ArrayList<String>(problems.size());
        for (Problem p : problems) {
            result.add(p.error);
        }
        return result;
    }

    protected void _validateFields(Control control, List<Problem> result) {
        String refStr;
        ChildReference ref;
        Object data = control.getData();
        if (data != null && data instanceof String && (ref = ChildReference.parsePath(refStr = (String)data)) != null) {
            try {
                Object fieldType = this.allfields.getChildType(ref);
                if (!(fieldType instanceof UnionType && control instanceof Combo || fieldType instanceof UnionType && control instanceof Composite || fieldType instanceof BooleanType && control instanceof Button)) {
                    Binding binding;
                    Problem problem;
                    Object value;
                    Text text;
                    if (fieldType instanceof RecordType && control instanceof Text) {
                        try {
                            text = (Text)control;
                            RecordBinding fieldBinding = (RecordBinding)Bindings.getMutableBinding(fieldType);
                            value = DataboardForm.parse(fieldBinding, text.getText());
                            fieldBinding.assertInstaceIsValid(value);
                        }
                        catch (BindingException er) {
                            problem = new Problem();
                            problem.error = er.getCause() != null ? er.getCause().getMessage() : er.getMessage();
                            problem.fieldReference = refStr;
                            problem.control = control;
                            result.add(problem);
                        }
                    } else if (fieldType instanceof StringAccessor && control instanceof Text) {
                        try {
                            text = (Text)control;
                            binding = (StringBinding)Bindings.getBinding(fieldType);
                            value = ((StringBinding)binding).create(text.getText());
                            binding.assertInstaceIsValid(value);
                        }
                        catch (BindingException er) {
                            problem = new Problem();
                            problem.error = er.getCause() != null ? er.getCause().getMessage() : er.getMessage();
                            problem.fieldReference = refStr;
                            problem.control = control;
                            result.add(problem);
                        }
                    } else if (fieldType instanceof NumberType && control instanceof Text) {
                        try {
                            text = (Text)control;
                            binding = (NumberBinding)Bindings.getBinding(fieldType);
                            value = ((NumberBinding)binding).create(text.getText());
                            binding.assertInstaceIsValid(value);
                        }
                        catch (BindingException er) {
                            problem = new Problem();
                            if (er.getCause() != null && er.getCause() instanceof NumberFormatException) {
                                NumberFormatException nfe = (NumberFormatException)er.getCause();
                                problem.error = nfe.getMessage();
                            } else {
                                problem.error = er.getMessage();
                            }
                            problem.fieldReference = refStr;
                            problem.control = control;
                            result.add(problem);
                        }
                    }
                }
            }
            catch (AccessorConstructionException e) {
                Problem problem = new Problem();
                problem.error = e.getMessage();
                problem.fieldReference = refStr;
                problem.control = control;
                result.add(problem);
            }
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this._validateFields(child, result);
                ++n2;
            }
        }
    }

    public RecordType type() {
        return this.allfields;
    }

    public Control getControl(Control control, ChildReference ref) {
        return this.getControl(control, ref.toPath());
    }

    public Control getControl(Control control, String ref) {
        Object data = control.getData();
        if (data != null && data instanceof String && data.equals(ref)) {
            return control;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control result = this.getControl(child, ref);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public void readFields(Composite composite, RecordBinding binding, Object dst) throws BindingException, AccessorConstructionException, AccessorException {
        RecordAccessor ra = (RecordAccessor)Accessors.getAccessor(binding, dst);
        this._readFields((Control)composite, ra);
    }

    protected void _readFields(Control control, RecordAccessor ra) throws AccessorException, BindingException {
        block16: {
            ChildReference ref;
            Object data = control.getData();
            if (data != null && data instanceof String && (ref = ChildReference.parsePath((String)data)) != null) {
                try {
                    Accessor sa;
                    Object fieldAccessor = ra.getComponent(ref);
                    if (fieldAccessor instanceof UnionAccessor && control instanceof Combo) {
                        sa = (UnionAccessor)fieldAccessor;
                        Combo combo = (Combo)control;
                        String text = combo.getText();
                        int tag = sa.type().getComponentIndex2(text);
                        Datatype tagType = sa.type().components[tag].type;
                        Object tagBinding = Bindings.getBinding(tagType);
                        Object defaultValue = ((Binding)tagBinding).createDefault();
                        sa.setComponentValue(tag, (Binding)tagBinding, defaultValue);
                        break block16;
                    }
                    if (fieldAccessor instanceof UnionAccessor && control instanceof Composite) {
                        Composite radioComposite = (Composite)control;
                        Control[] controlArray = radioComposite.getChildren();
                        int tag = controlArray.length;
                        int text = 0;
                        while (text < tag) {
                            UnionAccessor sa2;
                            int tag2;
                            String name;
                            Object data2;
                            Control c = controlArray[text];
                            if (c instanceof Button && ((Button)c).getSelection() && (data2 = c.getData()) != null && (name = DataboardForm.getName(data2.toString())) != null && (tag2 = (sa2 = (UnionAccessor)fieldAccessor).type().getComponentIndex2(name)) >= 0) {
                                Datatype tagType = sa2.type().components[tag2].type;
                                Object tagBinding = Bindings.getBinding(tagType);
                                Object defaultValue = ((Binding)tagBinding).createDefault();
                                sa2.setComponentValue(tag2, (Binding)tagBinding, defaultValue);
                                break block16;
                            }
                            ++text;
                        }
                        break block16;
                    }
                    if (fieldAccessor instanceof BooleanAccessor && control instanceof Button) {
                        sa = (BooleanAccessor)fieldAccessor;
                        sa.setValue(((Button)control).getSelection());
                    } else if (fieldAccessor instanceof RecordAccessor && control instanceof Text) {
                        RecordAccessor raa = (RecordAccessor)fieldAccessor;
                        Text text = (Text)control;
                        RecordBinding fieldBinding = (RecordBinding)Bindings.getMutableBinding(raa.type());
                        Object value = DataboardForm.parse(fieldBinding, text.getText());
                        raa.setValue(fieldBinding, value);
                    } else if (fieldAccessor instanceof StringAccessor && control instanceof Text) {
                        sa = (StringAccessor)fieldAccessor;
                        sa.setValue(((Text)control).getText());
                    } else if (fieldAccessor.type() instanceof NumberType && control instanceof Text) {
                        NumberBinding binding = (NumberBinding)Bindings.getBinding(fieldAccessor.type());
                        Object value = binding.create(((Text)control).getText());
                        fieldAccessor.setValue(binding, value);
                    }
                }
                catch (AccessorConstructionException accessorConstructionException) {}
            }
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this._readFields(child, ra);
                ++n2;
            }
        }
    }

    public void writeFields(Composite composite, RecordBinding binding, Object src) throws AccessorException, BindingException, AccessorConstructionException {
        RecordAccessor ra = (RecordAccessor)Accessors.getAccessor(binding, src);
        this._writeFields((Control)composite, ra);
    }

    void _writeFields(Control control, RecordAccessor ra) throws AccessorException, BindingException, AccessorConstructionException {
        ChildReference ref;
        Object data = control.getData();
        if (data != null && data instanceof String && (ref = ChildReference.parsePath((String)data)) != null) {
            try {
                Accessor sa;
                Object fieldAccessor = ra.getComponent(ref);
                if (fieldAccessor instanceof UnionAccessor && control instanceof Combo) {
                    sa = (UnionAccessor)fieldAccessor;
                    Combo combo = (Combo)control;
                    int tag = sa.getTag();
                    combo.setText(sa.type().getComponent((int)tag).name);
                } else if (fieldAccessor instanceof UnionAccessor && control instanceof Composite) {
                    Composite radioComposite = (Composite)control;
                    UnionAccessor sa2 = (UnionAccessor)fieldAccessor;
                    int tag = sa2.getTag();
                    int i = 0;
                    while (i < sa2.count()) {
                        Button button = (Button)radioComposite.getChildren()[i * 2];
                        button.setSelection(i == tag);
                        ++i;
                    }
                } else if (fieldAccessor instanceof BooleanAccessor && control instanceof Button) {
                    sa = (BooleanAccessor)fieldAccessor;
                    ((Button)control).setSelection(sa.getValue());
                } else if (fieldAccessor instanceof RecordAccessor && control instanceof Text) {
                    RecordAccessor raa = (RecordAccessor)fieldAccessor;
                    Text text = (Text)control;
                    RecordBinding fieldBinding = (RecordBinding)Bindings.getMutableBinding(raa.type());
                    String str = DataboardForm.print(fieldBinding, raa.getValue(fieldBinding));
                    text.setText(str);
                } else if (fieldAccessor instanceof StringAccessor && control instanceof Text) {
                    sa = (StringAccessor)fieldAccessor;
                    ((Text)control).setText(sa.getValue());
                } else if (fieldAccessor.type() instanceof NumberType && control instanceof Text) {
                    NumberBinding binding = (NumberBinding)Bindings.getBinding(fieldAccessor.type());
                    Object value = fieldAccessor.getValue(binding);
                    ((Text)control).setText(binding.toString(value, true));
                }
            }
            catch (AccessorConstructionException accessorConstructionException) {}
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this._writeFields(child, ra);
                ++n2;
            }
        }
    }

    public void clear(Control control) {
        this._clearFields(control);
        this.allfields.clear();
    }

    protected void _clearFields(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this._clearFields(child);
                child.dispose();
                ++n2;
            }
        }
    }

    public void addListener(Composite composite, RecordType type, Listener listener) throws BindingException, AccessorConstructionException, AccessorException {
        this._addListener((Control)composite, type, listener);
    }

    protected void _addListener(Control control, Datatype type, Listener listener) throws AccessorException, BindingException {
        int n;
        Object data = control.getData();
        ChildReference ref = null;
        if (data != null && data instanceof String) {
            ref = ChildReference.parsePath((String)data);
        }
        try {
            Datatype fieldType;
            Datatype datatype = fieldType = ref == null ? type : type.getChildType(ref);
            if (fieldType instanceof UnionType && control instanceof Combo) {
                control.addListener(13, listener);
            } else if (fieldType instanceof UnionType && control instanceof Composite) {
                Composite radioComposite = (Composite)control;
                Control[] controlArray = radioComposite.getChildren();
                int n2 = controlArray.length;
                n = 0;
                while (n < n2) {
                    Control c = controlArray[n];
                    if (c instanceof Button) {
                        c.addListener(13, listener);
                    }
                    ++n;
                }
            } else if (fieldType instanceof BooleanType && control instanceof Button) {
                control.addListener(13, listener);
            } else if (fieldType instanceof StringType && control instanceof Text) {
                control.addListener(24, listener);
            } else if (fieldType instanceof NumberType && control instanceof Text) {
                control.addListener(24, listener);
            }
        }
        catch (ReferenceException referenceException) {}
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control child = controlArray[n3];
                this._addListener(child, type, listener);
                ++n3;
            }
        }
    }

    public void addField(Composite parent, String name, Datatype fieldType) {
        this.addField(parent, fieldType, URIUtil.encodeURI(name), null);
        this.allfields.addComponent(name, fieldType);
    }

    public void addField(Composite parent, String name, Datatype fieldType, String ref) {
        this.addField(parent, fieldType, DataboardForm.appendName(ref, name), null);
        RecordType root = this.allfields;
        if (ref != null && !ref.isEmpty()) {
            ChildReference path = ChildReference.parsePath(ref);
            while (path != null) {
                if (!(path instanceof LabelReference)) {
                    throw new RuntimeException("blaah");
                }
                LabelReference lr = (LabelReference)path;
                String label = lr.label;
                if (root.hasComponent(label)) {
                    root = (RecordType)root.getComponent((String)label).type;
                } else {
                    RecordType rt = new RecordType();
                    root.addComponent(label, rt);
                    root = rt;
                }
                path = path.childReference;
            }
        }
        if (!root.hasComponent(name)) {
            root.addComponent(name, fieldType);
        }
    }

    public void addFields(Composite parent, RecordType source) {
        Component[] componentArray = source.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.addField(parent, component.name, component.type);
            ++n2;
        }
    }

    public void addFields(Composite parent, RecordType source, String ref) {
        Component[] componentArray = source.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.addField(parent, component.name, component.type, ref);
            ++n2;
        }
    }

    public void addField(Composite parent, Datatype fieldType, String ref, GridData lblLayout) {
        if (lblLayout == null) {
            lblLayout = new GridData(16384, 1, false, false, 1, 1);
            if (DataboardForm.getDepth(ref) < 3) {
                lblLayout.widthHint = this.column1Width;
            }
        }
        String fieldName = DataboardForm.getName(ref);
        if (fieldType instanceof StringType) {
            Label label = new Label(parent, 0);
            label.setText(String.valueOf(fieldName) + ":");
            label.setToolTipText(fieldName);
            label.setLayoutData((Object)lblLayout);
            this.addString(parent, (StringType)fieldType, ref);
        } else if (fieldType instanceof BooleanType) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)lblLayout);
            this.addBoolean(parent, (BooleanType)fieldType, ref);
        } else if (fieldType instanceof NumberType) {
            Label label = new Label(parent, 0);
            label.setText(String.valueOf(fieldName) + ":");
            label.setLayoutData((Object)lblLayout);
            this.addNumber(parent, (NumberType)fieldType, ref);
        } else if (fieldType instanceof RecordType) {
            boolean tabbed;
            RecordType record = (RecordType)fieldType;
            String options = (String)record.metadata.get("style");
            boolean dialog = options == null ? false : options.contains("dialog");
            boolean bl = tabbed = options == null ? false : options.contains("tabbed");
            if (tabbed) {
                Label label = new Label(parent, 0);
                label.setText(String.valueOf(fieldName) + ":");
                label.setLayoutData((Object)lblLayout);
                CTabFolder folder = new CTabFolder(parent, 2176);
                folder.setSimple(false);
                folder.setLayout((Layout)new GridLayout(3, false));
                folder.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                int i = 0;
                while (i < record.getComponentCount()) {
                    String childName = record.getComponent((int)i).name;
                    Datatype childType = record.getComponentType(i);
                    String childRef = DataboardForm.appendName(ref, childName);
                    if (i > 0) {
                        new Label(parent, 0);
                    }
                    CTabItem item = new CTabItem(folder, 0);
                    item.setText(childName);
                    Composite composite = new Composite((Composite)folder, 0);
                    composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                    composite.setLayout((Layout)new GridLayout(3, false));
                    composite.setData((Object)ref);
                    if (childType instanceof RecordType) {
                        this.addRecord(composite, (RecordType)childType, childRef);
                    } else {
                        this.addWidget(composite, childType, childRef);
                    }
                    item.setControl((Control)composite);
                    ++i;
                }
                folder.setSelection(0);
            } else if (dialog) {
                Label label = new Label(parent, 0);
                label.setText(String.valueOf(fieldName) + ":");
                label.setLayoutData((Object)lblLayout);
                final String title = fieldName;
                final Shell shell = parent.getShell();
                final RecordBinding fieldBinding = (RecordBinding)Bindings.getMutableBinding(fieldType);
                Object fieldValue = fieldBinding.createDefaultUnchecked();
                final Text text = new Text(parent, 2048);
                Button select = new Button(parent, 8);
                text.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
                text.setText(DataboardForm.print(fieldBinding, fieldValue));
                text.setData((Object)ref);
                text.addListener(25, new Listener(){

                    public void handleEvent(Event e) {
                        try {
                            String newText = DataboardForm.applyEventToString(text.getText(), e);
                            Object value = DataboardForm.parse(fieldBinding, newText);
                            fieldBinding.assertInstaceIsValid(value);
                            text.setBackground(null);
                        }
                        catch (BindingException bindingException) {
                            Color error = new Color((Device)text.getDisplay(), 255, 222, 222);
                            text.setBackground(error);
                            error.dispose();
                        }
                    }
                });
                select.setText("Select");
                select.setLayoutData((Object)new GridData(131072, 1, false, false));
                select.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Object initialValue;
                        try {
                            initialValue = DataboardForm.parse(fieldBinding, text.getText());
                        }
                        catch (BindingException bindingException) {
                            initialValue = fieldBinding.createDefaultUnchecked();
                        }
                        DataboardDialog dialog = new DataboardDialog(shell, title, fieldBinding, initialValue);
                        int code = dialog.open();
                        if (code == 0) {
                            Object result = dialog.getResult();
                            String str = DataboardForm.print(fieldBinding, result);
                            text.setText(str);
                        }
                    }
                });
            } else if (DataboardForm.allBooleans(record)) {
                Label label = new Label(parent, 0);
                label.setText(String.valueOf(fieldName) + ":");
                label.setLayoutData((Object)lblLayout);
                int i = 0;
                while (i < record.getComponentCount()) {
                    String childName = record.getComponent((int)i).name;
                    Datatype childType = record.getComponentType(i);
                    String childRef = DataboardForm.appendName(ref, childName);
                    if (i > 0) {
                        new Label(parent, 0);
                    }
                    this.addWidget(parent, childType, childRef);
                    ++i;
                }
            } else {
                Group group = new Group(parent, 0);
                group.setText(fieldName);
                group.setLayout((Layout)new GridLayout(3, false));
                group.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                group.setData((Object)ref);
                this.addRecord((Composite)group, record, ref);
            }
        } else if (fieldType instanceof UnionType) {
            Label label = new Label(parent, 0);
            label.setText(String.valueOf(fieldName) + ":");
            label.setLayoutData((Object)lblLayout);
            this.addUnion(parent, (UnionType)fieldType, ref);
        }
    }

    protected void addWidget(Composite parent, Datatype fieldType, String ref) {
        if (fieldType instanceof StringType) {
            this.addString(parent, (StringType)fieldType, ref);
        } else if (fieldType instanceof BooleanType) {
            this.addBoolean(parent, (BooleanType)fieldType, ref);
        } else if (fieldType instanceof NumberType) {
            this.addNumber(parent, (NumberType)fieldType, ref);
        } else if (fieldType instanceof RecordType) {
            RecordType rt = (RecordType)fieldType;
            Group group = new Group(parent, 0);
            String name = DataboardForm.getName(ref);
            group.setText(name);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            group.setData((Object)ref);
            this.addRecord((Composite)group, rt, ref);
        } else if (fieldType instanceof UnionType) {
            this.addUnion(parent, (UnionType)fieldType, ref);
        }
    }

    public CTabFolder addTabFolder(Composite parent, RecordType record, String ref) {
        CTabFolder folder = new CTabFolder(parent, 2176);
        folder.setSimple(false);
        folder.setLayout((Layout)new GridLayout(3, false));
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        int i = 0;
        while (i < record.getComponentCount()) {
            String childName = record.getComponent((int)i).name;
            Datatype childType = record.getComponentType(i);
            String childRef = DataboardForm.appendName(ref, childName);
            if (i > 0) {
                new Label(parent, 0);
            }
            CTabItem item = new CTabItem(folder, 0);
            item.setText(childName);
            Composite composite = new Composite((Composite)folder, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            composite.setLayout((Layout)new GridLayout(3, false));
            composite.setData((Object)ref);
            if (childType instanceof RecordType) {
                this.addRecord(composite, (RecordType)childType, childRef);
            } else {
                this.addWidget(composite, childType, childRef);
            }
            item.setControl((Control)composite);
            this.allfields.addComponent(childName, childType);
            ++i;
        }
        folder.setSelection(0);
        return folder;
    }

    protected void addRecord(Composite parent, RecordType record, String ref) {
        boolean tabbed;
        String options = (String)record.metadata.get("style");
        if (options != null) {
            options.contains("dialog");
        }
        boolean bl = tabbed = options == null ? false : options.contains("tabbed");
        if (tabbed) {
            this.addTabFolder(parent, record, ref);
            return;
        }
        GridData lblLayout = new GridData(16384, 1, false, false, 1, 1);
        if (DataboardForm.getDepth(ref) < 3) {
            lblLayout.widthHint = this.column1Width;
        }
        int i = 0;
        while (i < record.getComponentCount()) {
            String fieldName = record.getComponent((int)i).name;
            Datatype fieldType = record.getComponentType(i);
            String fieldRef = DataboardForm.appendName(ref, fieldName);
            this.addField(parent, fieldType, fieldRef, lblLayout);
            ++i;
        }
    }

    protected void addUnion(Composite parent, UnionType union, String ref) {
        if (union.isEnumeration()) {
            this.addEnum(parent, union, ref);
        } else {
            this.addRadio(parent, union, ref);
        }
    }

    protected void addEnum(Composite parent, UnionType union, String ref) {
        Combo combo = new Combo(parent, 8);
        String[] items = new String[union.getComponentCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = union.getComponent((int)i).name;
            ++i;
        }
        combo.setItems(items);
        combo.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        combo.setData((Object)ref);
        UnionBinding binding = (UnionBinding)Bindings.getBinding(union);
        try {
            TaggedObject defaultOption = (TaggedObject)binding.createDefault();
            combo.setText(items[defaultOption.tag]);
        }
        catch (BindingException bindingException) {}
    }

    protected void addRadio(Composite parent, UnionType union, String ref) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setData((Object)ref);
        int count = union.getComponentCount();
        Composite[] panels = new Composite[count];
        Button[] buttons = new Button[count];
        int i = 0;
        while (i < count) {
            Component component = union.getComponent(i);
            String childRef = String.valueOf(ref) + "/" + URIUtil.encodeURI(component.name);
            Button b = buttons[i] = new Button(composite, 16);
            b.setLayoutData((Object)new GridData(16384, 1, false, false, 1, 1));
            b.setText(component.name);
            b.setData((Object)childRef);
            String options = (String)union.metadata.get("style");
            boolean border = options == null ? true : !options.contains("no-border");
            int style = 0;
            if (border) {
                style |= 0x800;
            }
            Composite panel = panels[i] = new Composite(composite, style);
            panel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            panel.setLayout((Layout)new GridLayout(3, false));
            panel.setData((Object)childRef);
            Datatype componentType = union.getComponentType(i);
            if (componentType instanceof RecordType) {
                this.addRecord(panel, (RecordType)componentType, childRef);
            } else {
                this.addWidget(panel, componentType, childRef);
            }
            ++i;
        }
        UnionBinding binding = (UnionBinding)Bindings.getBinding(union);
        try {
            TaggedObject defaultOption = (TaggedObject)binding.createDefault();
            buttons[defaultOption.tag].setSelection(true);
        }
        catch (BindingException bindingException) {}
    }

    protected void addNumber(Composite parent, NumberType number, String ref) {
        String unit = number.getUnit();
        String options = (String)number.metadata.get("style");
        boolean border = options == null ? true : !options.contains("no-border");
        int style = 0;
        if (border) {
            style |= 0x800;
        }
        final Text text = new Text(parent, style);
        text.setData((Object)ref);
        text.setLayoutData((Object)new GridData(4, 1, true, false, unit == null ? 2 : 1, 1));
        final NumberBinding binding = (NumberBinding)Bindings.getBinding(number);
        try {
            text.setText(binding.createDefault().toString());
        }
        catch (BindingException bindingException) {}
        text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                try {
                    String newText = DataboardForm.applyEventToString(text.getText(), e);
                    Object value = binding.create(newText);
                    binding.assertInstaceIsValid(value);
                    text.setBackground(null);
                }
                catch (BindingException bindingException) {
                    Color error = new Color((Device)text.getDisplay(), 255, 222, 222);
                    text.setBackground(error);
                    error.dispose();
                }
            }
        });
        if (unit != null) {
            Label unitLabel = new Label(parent, 0);
            unitLabel.setText(unit);
        }
    }

    static String applyEventToString(String orig, Event e) {
        if (e.character == '\b') {
            return String.valueOf(orig.substring(0, e.start)) + orig.substring(e.end, orig.length());
        }
        return String.valueOf(orig.substring(0, e.start)) + e.text + orig.substring(e.end, orig.length());
    }

    protected void addBoolean(Composite parent, BooleanType booleanType, String ref) {
        Button button = new Button(parent, 32);
        button.setText(DataboardForm.getName(ref));
        button.setData((Object)ref);
        button.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    protected void addString(Composite parent, StringType stringType, String ref) {
        FileDialog fd;
        boolean multi;
        String options = (String)stringType.metadata.get("style");
        boolean password = options == null ? false : options.contains("password");
        boolean filesave = options == null ? false : options.contains("filesave");
        boolean fileopen = options == null ? false : options.contains("fileopen");
        boolean directory = options == null ? false : options.contains("directory");
        boolean bl = multi = options == null ? false : options.contains("multi");
        boolean border = options == null ? true : !options.contains("no-border");
        int style = 0;
        if (password) {
            style |= 0x400000;
        }
        if (multi) {
            style |= 2;
        }
        if (border) {
            style |= 0x800;
        }
        final Text text = new Text(parent, style);
        text.setLayoutData((Object)new GridData(4, multi ? 4 : 1, true, false, filesave | fileopen | directory ? 1 : 2, 1));
        text.setData((Object)ref);
        final StringBinding binding = (StringBinding)Bindings.getBinding(stringType);
        try {
            text.setText(binding.createDefault().toString());
        }
        catch (BindingException bindingException) {}
        text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                try {
                    String newText = DataboardForm.applyEventToString(text.getText(), e);
                    Object value = binding.create(newText);
                    binding.assertInstaceIsValid(value);
                    text.setBackground(null);
                }
                catch (BindingException bindingException) {
                    Color error = new Color((Device)text.getDisplay(), 255, 222, 222);
                    text.setBackground(error);
                    error.dispose();
                }
            }
        });
        if (filesave | fileopen) {
            fd = new FileDialog(parent.getShell(), filesave ? 8192 : 4096);
            String filetypesStr = (String)stringType.metadata.get("filetypes");
            String fileextsStr = (String)stringType.metadata.get("fileexts");
            String name = DataboardForm.getName(ref);
            String[] filetypes = filetypesStr == null ? null : filetypesStr.split(",");
            String[] fileexts = fileextsStr == null ? null : fileextsStr.split(",");
            fd.setFilterNames(filetypes);
            fd.setFilterExtensions(fileexts);
            boolean nameMatchesExt = false;
            if (name != null && !name.isEmpty()) {
                String[] stringArray = fileexts;
                int n = fileexts.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileext = stringArray[n2];
                    nameMatchesExt |= StringUtil.simplePatternMatch(name, fileext) && !name.contains(" ");
                    ++n2;
                }
            }
            final String initialName = nameMatchesExt ? name : null;
            Button chooseFileButton = new Button(parent, 8);
            chooseFileButton.setText("Select");
            chooseFileButton.setLayoutData((Object)new GridData(131072, 1, false, false));
            chooseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String result;
                    String name = text.getText();
                    if (name == null || name.isEmpty()) {
                        name = initialName;
                    }
                    if (name != null) {
                        fd.setFileName(name);
                    }
                    if ((result = fd.open()) != null) {
                        text.setText(result);
                    }
                }
            });
        }
        if (directory) {
            fd = new DirectoryDialog(parent.getShell(), 0);
            String name = DataboardForm.getName(ref);
            fd.setMessage(name);
            Button chooseDirButton = new Button(parent, 8);
            chooseDirButton.setText("Select");
            chooseDirButton.setLayoutData((Object)new GridData(131072, 1, false, false));
            chooseDirButton.addSelectionListener((SelectionListener)new SelectionAdapter((DirectoryDialog)fd){
                private final /* synthetic */ DirectoryDialog val$fd;
                {
                    this.val$fd = directoryDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    String dir = text.getText();
                    this.val$fd.setFilterPath(dir);
                    String result = this.val$fd.open();
                    if (result != null) {
                        text.setText(result);
                    }
                }
            });
        }
    }

    static String appendName(String ref, String name) {
        return String.valueOf(ref) + "/" + URIUtil.encodeURI(name);
    }

    static String getName(String ref) {
        if (ref == null) {
            return null;
        }
        int i = ref.lastIndexOf(47);
        if (i < 0) {
            return URIUtil.decodeURI(ref);
        }
        String namePart = ref.substring(i + 1);
        return URIUtil.decodeURI(namePart);
    }

    static int getDepth(String ref) {
        int depth = 0;
        int i = 0;
        while (i < ref.length()) {
            if (ref.charAt(i) == '/') {
                ++depth;
            }
            ++i;
        }
        return depth;
    }

    static boolean allBooleans(RecordType rt) {
        Component[] componentArray = rt.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (!(c.type instanceof BooleanType)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static String print(RecordBinding recordBinding, Object value) {
        if (DataboardForm.allBooleans(recordBinding.type())) {
            StringBuilder sb = new StringBuilder();
            int j = 0;
            int i = 0;
            while (i < recordBinding.getComponentCount()) {
                try {
                    boolean b = recordBinding.getBoolean(value, i);
                    if (b) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(recordBinding.type().getComponent((int)i).name);
                        ++j;
                    }
                }
                catch (BindingException bindingException) {}
                ++i;
            }
            return sb.toString();
        }
        try {
            return recordBinding.toString(value, true);
        }
        catch (BindingException e) {
            return e.toString();
        }
    }

    static Object parse(RecordBinding recordBinding, String txt) throws BindingException {
        if (DataboardForm.allBooleans(recordBinding.type())) {
            String[] tokens;
            Object result = recordBinding.createDefaultUnchecked();
            String[] stringArray = tokens = txt.split(", ");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (!token.isEmpty()) {
                    int i = recordBinding.type().getComponentIndex2(token);
                    if (i >= 0) {
                        recordBinding.setBoolean(result, i, true);
                    } else {
                        throw new BindingException("There is no field \"" + token + "\"");
                    }
                }
                ++n2;
            }
            return result;
        }
        try {
            return recordBinding.parseValueDefinition(txt);
        }
        catch (DataTypeSyntaxError e) {
            throw new BindingException(e);
        }
    }

    public static class Problem
    extends Bean {
        public String fieldReference;
        public transient Control control;
        public String error;
    }
}

