/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SpecializedSerializerProvider;
import org.simantics.databoard.type.UnionType;

class UnionClassBinding
extends UnionBinding
implements SpecializedSerializerProvider {
    Class<?>[] componentClasses;
    Serializer specializedSerializer;
    transient Boolean isImmutable;

    public UnionClassBinding(UnionType type) throws BindingConstructionException {
        this.type = type;
    }

    @Override
    public Object create(int tag, Object value) {
        return value;
    }

    @Override
    public void setValue(Object union, int tag, Object value) throws BindingException {
        if (tag != this.getTag(union)) {
            throw new BindingException("Cannot change the class of an instance");
        }
        Binding cb = this.getComponentBinding(tag);
        cb.readFrom(cb, value, union);
    }

    @Override
    public int getTag(Object obj) throws BindingException {
        int i = 0;
        while (i < this.componentClasses.length) {
            if (this.componentClasses[i].isInstance(obj)) {
                return i;
            }
            ++i;
        }
        throw new BindingException(String.valueOf(obj.getClass().getSimpleName()) + " is not a known component class");
    }

    @Override
    public Object getValue(Object obj) {
        return obj;
    }

    @Override
    public boolean isInstance(Object obj) {
        Class<?>[] classArray = this.componentClasses;
        int n = this.componentClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.isInstance(obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Serializer getSpecializedSerializer() {
        return this.specializedSerializer;
    }

    @Override
    public synchronized boolean isImmutable() {
        if (this.isImmutable == null) {
            boolean b = true;
            Binding[] bindingArray = this.getComponentBindings();
            int n = bindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                Binding cb = bindingArray[n2];
                if (!(b &= cb.isImmutable())) break;
                ++n2;
            }
            this.isImmutable = b;
        }
        return this.isImmutable;
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        UnionBinding sb = (UnionBinding)srcBinding;
        int st = sb.getTag(src);
        int dt = this.getTag(dst);
        Binding scb = sb.getComponentBinding(st);
        Object sv = sb.getValue(src);
        if (st == dt) {
            Object dv = this.getValue(dst);
            Binding dcb = this.getComponentBinding(dt);
            dcb.readFrom(scb, sv, dv);
            return dv;
        }
        try {
            Binding dcb = this.getComponentBinding(st);
            return Bindings.adapt(src, scb, dcb);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public boolean isTagMutable() {
        return true;
    }

    @Override
    protected boolean baseEquals(Object obj) {
        if (!super.baseEquals(obj)) {
            return false;
        }
        UnionClassBinding o = (UnionClassBinding)obj;
        if (this.isImmutable != o.isImmutable) {
            return false;
        }
        if (this.specializedSerializer != o.specializedSerializer) {
            return false;
        }
        if (this.componentClasses.length != o.componentClasses.length) {
            return false;
        }
        int i = 0;
        while (i < this.componentClasses.length) {
            if (!this.componentClasses[i].equals(o.componentClasses[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int baseHashCode() {
        int code = super.baseHashCode();
        int i = 0;
        while (i < this.componentClasses.length) {
            code = 23 * code + this.componentClasses.hashCode();
            ++i;
        }
        return code;
    }
}

