/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.ConstantBinding;
import org.simantics.databoard.type.UnionType;

public class EnumClassBinding
extends UnionBinding {
    Class<Enum<?>> clazz;
    Enum<?>[] tags;

    public EnumClassBinding(UnionType type, Class<Enum<?>> clazz) {
        this.type = type;
        this.tags = clazz.getEnumConstants();
        this.clazz = clazz;
        this.componentBindings = new Binding[this.tags.length];
        int i = 0;
        while (i < this.tags.length) {
            this.componentBindings[i] = new ConstantBinding(type.components[i].type, this.tags[i]);
            ++i;
        }
    }

    @Override
    public Object create(int tag, Object value) {
        return this.tags[tag];
    }

    @Override
    public void setValue(Object union, int tag, Object value) throws BindingException {
        throw new BindingException("Cannot change enum instance value");
    }

    @Override
    public int getTag(Object obj) throws BindingException {
        int i = 0;
        while (i < this.tags.length) {
            if (obj == this.tags[i]) {
                return i;
            }
            ++i;
        }
        throw new BindingException(obj + " is not an element of " + this.clazz.getSimpleName());
    }

    @Override
    public Object getValue(Object obj) {
        return obj;
    }

    @Override
    public boolean isInstance(Object obj) {
        return this.clazz.isInstance(obj);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    protected boolean baseEquals(Object obj) {
        EnumClassBinding o = (EnumClassBinding)obj;
        return super.baseEquals(obj) && o.clazz.equals(this.clazz);
    }

    @Override
    public int baseHashCode() {
        return super.baseHashCode() + 13 * this.clazz.hashCode();
    }
}

