/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.mutable;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.type.Datatype;

public class MutableVariant
extends Variant
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    public static MutableVariant ofInstance(Object instance) {
        Object binding = Bindings.getBindingUnchecked(instance.getClass());
        return new MutableVariant((Binding)binding, instance);
    }

    public MutableVariant() {
        this.binding = VoidBinding.VOID_BINDING;
        this.value = null;
    }

    public MutableVariant(Variant v) {
        this.binding = v.getBinding();
        this.value = v.getValue();
    }

    public MutableVariant(Binding binding, Object value) {
        this.binding = binding;
        this.value = value;
    }

    public void setValue(Variant v) {
        this.binding = v.getBinding();
        this.value = v.getValue();
    }

    public void setValue(Binding binding, Object newValue) {
        this.binding = binding;
        this.value = newValue;
    }

    public void readFrom(Binding binding, Object newValue) throws BindingException {
        if (binding.isImmutable()) {
            this.binding = binding;
            this.value = newValue;
            return;
        }
        if (this.binding == binding) {
            binding.readFrom(binding, newValue, this.value);
        } else {
            try {
                this.value = binding.clone(newValue);
                this.binding = binding;
            }
            catch (AdaptException e) {
                throw new BindingException(e);
            }
        }
    }

    @Override
    public MutableVariant clone() {
        if (this.binding.isImmutable()) {
            return new MutableVariant(this.binding, this.value);
        }
        Object newValue = Bindings.cloneUnchecked(this.value, this.binding, this.binding);
        return new MutableVariant(this.binding, newValue);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object dataTypeBinding = Bindings.getBindingUnchecked(Datatype.class);
        Bindings.getSerializerUnchecked(dataTypeBinding).serialize(this.type());
        Bindings.getSerializerUnchecked(this.binding).serialize(this.value, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object dataTypeBinding = Bindings.getBindingUnchecked(Datatype.class);
        Datatype type = (Datatype)Bindings.getSerializerUnchecked(dataTypeBinding).deserialize(in);
        Object binding = Bindings.getMutableBinding(type);
        Object value = Bindings.getSerializerUnchecked(binding).deserialize(in);
        this.binding = binding;
        this.value = value;
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Don't know how to instantiate " + this.type() + " with no data");
    }

    @Override
    public MutableVariant getComponent(ChildReference ref) throws AccessorConstructionException {
        if (ref == null) {
            return this;
        }
        JavaObject jo = (JavaObject)Accessors.getAccessor(this, ref);
        return new MutableVariant(jo.getBinding(), jo.getObject());
    }

    public void setComponent(ChildReference ref, Binding binding, Object value) throws AccessorException, AccessorConstructionException {
        if (ref == null) {
            this.setValue(binding, value);
        } else {
            JavaObject jo = (JavaObject)Accessors.getAccessor(this, ref);
            jo.setValue(ref, binding, value);
        }
    }
}

