/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.OptionalType;

public class OptionalBindingDefault
extends OptionalBinding {
    public OptionalBindingDefault(Binding componentBinding) {
        super(componentBinding);
    }

    public OptionalBindingDefault(OptionalType type, Binding componentBinding) {
        super(type, componentBinding);
    }

    @Override
    public Object createNoValue() {
        return null;
    }

    @Override
    public Object createValue(Object value) throws BindingException {
        if (value == null) {
            throw new BindingException("Cannot bind null as a value");
        }
        return value;
    }

    @Override
    public boolean hasValue(Object arg) {
        return arg != null;
    }

    @Override
    public Object getValue(Object arg) throws BindingException {
        if (arg == null) {
            throw new BindingException("Optional value (" + arg + ") does not contain value.");
        }
        return arg;
    }

    @Override
    public void setValue(Object optional, Object componentValue) throws BindingException {
        if (componentValue == optional) {
            return;
        }
        throw new UnsupportedOperationException("Cannot set new value to container of java.lang.Object");
    }

    @Override
    public void setNoValue(Object optional) throws BindingException {
        if (optional == null) {
            return;
        }
        throw new UnsupportedOperationException("Cannot remove value from container of java.lang.Object");
    }

    @Override
    public boolean isInstance(Object obj) {
        if (obj == null) {
            return true;
        }
        return this.componentBinding.isInstance(obj);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }
}

