/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.IdentityPair;

public class LinkedListBinding
extends ArrayBinding {
    public LinkedListBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
        if (type == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.type = type;
    }

    @Override
    public Object create() {
        return new LinkedList();
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        LinkedList<Object> result = new LinkedList<Object>();
        while (values.hasNext()) {
            result.add(values.next());
        }
        return result;
    }

    @Override
    public Object create(Collection<Object> collection) throws BindingException {
        return new LinkedList<Object>(collection);
    }

    @Override
    public Object create(Object[] values) {
        LinkedList<Object> array = new LinkedList<Object>();
        int i = 0;
        while (i < values.length) {
            array.add(values[i]);
            ++i;
        }
        return array;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", java.util.List expected");
        }
        List list = (List)array;
        return list.get(index);
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        List list = (List)array;
        int index = 0;
        for (Object o : list) {
            result[index++] = o;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        List list = (List)array;
        list.set(index, value);
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", java.util.List expected");
        }
        List list = (List)array;
        return list.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof LinkedList;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        List list = (List)array;
        list.add(index, element);
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        LinkedList list = (LinkedList)array;
        if (index < 0 || index >= list.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            list.removeFirst();
            return;
        }
        if (index == list.size()) {
            list.removeLast();
            return;
        }
        Iterator iter = list.iterator();
        int i = 0;
        while (i < index) {
            iter.next();
            ++i;
        }
        i = 0;
        while (i < count) {
            iter.next();
            iter.remove();
            ++i;
        }
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 1;
        LinkedList list = (LinkedList)value;
        for (Object element : list) {
            result = 31 * result + this.componentBinding.deepHashValue(element, hashedObjects);
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        int l2;
        int l1 = this.size(o1);
        int dif = l1 - (l2 = this.size(o2));
        if (dif != 0) {
            return dif;
        }
        Binding c = this.getComponentBinding();
        Iterator i1 = ((LinkedList)o1).iterator();
        Iterator i2 = ((LinkedList)o2).iterator();
        while (i1.hasNext()) {
            Object e2;
            Object e1 = i1.next();
            dif = c.deepCompare(e1, e2 = i2.next(), compareHistory);
            if (dif == 0) continue;
            return dif;
        }
        return 0;
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        List list = (List)array;
        int oldSize = list.size();
        if (oldSize == newSize) {
            return;
        }
        if (oldSize > newSize) {
            int i = oldSize - 1;
            while (i <= newSize) {
                list.remove(i);
                --i;
            }
            return;
        }
        int c = newSize - oldSize;
        int i = 0;
        while (i < c) {
            list.add(this.componentBinding.createDefault());
            ++i;
        }
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isResizable() {
        return true;
    }
}

