/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.HashMapBinding;
import org.simantics.databoard.binding.impl.HashSetBinding;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.type.MapType;

public class TroveBindingsProvider
implements BindingProvider {
    @Override
    public Binding provideBinding(ClassBindingFactory factory, BindingRequest request) throws BindingConstructionException {
        if (request.getClazz().equals(THashSet.class)) {
            MapType type = new MapType();
            type.valueType = Datatypes.VOID;
            return new THashSetBinding(type, null);
        }
        if (request.getClazz().equals(THashMap.class)) {
            MapType type = new MapType();
            return new THashMapBinding(type, null, null);
        }
        return null;
    }

    static class THashMapBinding
    extends HashMapBinding {
        public THashMapBinding(Binding keyBinding, Binding valueBinding) {
            super(keyBinding, valueBinding);
        }

        public THashMapBinding(MapType mapType, Binding keyBinding, Binding valueBinding) {
            super(mapType, keyBinding, valueBinding);
        }

        @Override
        public Object create() {
            return new THashMap();
        }

        @Override
        public Object create(Object[] keys, Object[] values) {
            if (keys.length != values.length) {
                throw new IllegalArgumentException("Equal length arrays expected");
            }
            int len = keys.length;
            THashMap result = new THashMap(len);
            int i = 0;
            while (i < len) {
                Object key = keys[i];
                Object value = values[i];
                result.put(key, value);
                ++i;
            }
            return result;
        }

        @Override
        public Object create(List<Object> keys, List<Object> values) {
            if (keys.size() != values.size()) {
                throw new IllegalArgumentException("Equal length arrays expected");
            }
            int len = keys.size();
            THashMap result = new THashMap(len);
            int i = 0;
            while (i < len) {
                Object key = keys.get(i);
                Object value = values.get(i);
                result.put(key, value);
                ++i;
            }
            return result;
        }

        @Override
        public Object create(Map<?, ?> initialMap) throws BindingException {
            if (initialMap instanceof THashMap) {
                return initialMap;
            }
            THashMap result = new THashMap();
            this.putAll(result, initialMap);
            return result;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof THashMap;
        }
    }

    static class THashSetBinding
    extends HashSetBinding {
        public THashSetBinding(Binding elementBinding) {
            super(elementBinding);
        }

        public THashSetBinding(MapType mapType, Binding elementBinding) {
            super(mapType, elementBinding);
        }

        @Override
        public Object create() throws BindingException {
            return new THashSet();
        }

        @Override
        public Object create(Set<?> initialSet) throws BindingException {
            if (initialSet instanceof THashSet) {
                return initialSet;
            }
            return new THashSet(initialSet);
        }

        @Override
        public Object create(Map initialMap) throws BindingException {
            return new THashSet(initialMap.keySet());
        }

        @Override
        public Object create(Object[] keys, Object[] values) throws BindingException {
            THashSet result = new THashSet(keys.length);
            int i = 0;
            while (i < keys.length) {
                result.add(keys[i]);
                ++i;
            }
            return result;
        }

        @Override
        public Object create(List<Object> keys, List<Object> values) {
            THashSet result = new THashSet(keys.size());
            int i = 0;
            while (i < keys.size()) {
                result.add(keys.get(i));
                ++i;
            }
            return result;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof THashSet;
        }
    }
}

