/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.factory.RecordObjectArrayBinding;
import org.simantics.databoard.binding.factory.TypeBindingFactory;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.BooleanBindingDefault;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.ByteBindingDefault;
import org.simantics.databoard.binding.impl.DefaultMapBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.DoubleBindingDefault;
import org.simantics.databoard.binding.impl.FloatArrayBinding;
import org.simantics.databoard.binding.impl.FloatBindingDefault;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.IntegerBindingDefault;
import org.simantics.databoard.binding.impl.LongArrayBinding;
import org.simantics.databoard.binding.impl.LongBindingDefault;
import org.simantics.databoard.binding.impl.ObjectArrayBinding;
import org.simantics.databoard.binding.impl.StringBindingDefault;
import org.simantics.databoard.binding.mutable.ContainerOptionalBinding;
import org.simantics.databoard.binding.mutable.UnionTaggedObjectBinding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;

public class DefaultBindingFactory
extends TypeBindingFactory {
    public DefaultBindingFactory() {
    }

    public DefaultBindingFactory(Map<Datatype, Binding> repository) {
        super(repository);
    }

    @Override
    protected Binding doConstruct(Datatype type) throws BindingConstructionException {
        if (type.equals(Bindings.BOOLEAN.type())) {
            return Bindings.BOOLEAN;
        }
        if (type.equals(Bindings.BYTE.type())) {
            return Bindings.BYTE;
        }
        if (type.equals(Bindings.INTEGER.type())) {
            return Bindings.INTEGER;
        }
        if (type.equals(Bindings.LONG.type())) {
            return Bindings.LONG;
        }
        if (type.equals(Bindings.FLOAT.type())) {
            return Bindings.FLOAT;
        }
        if (type.equals(Bindings.DOUBLE.type())) {
            return Bindings.DOUBLE;
        }
        if (type.equals(Bindings.STRING.type())) {
            return Bindings.STRING;
        }
        if (type.equals(Bindings.VARIANT.type())) {
            return Bindings.VARIANT;
        }
        if (type.equals(Bindings.BOOLEAN_ARRAY.type())) {
            return Bindings.BOOLEAN_ARRAY;
        }
        if (type.equals(Bindings.BYTE_ARRAY.type())) {
            return Bindings.BYTE_ARRAY;
        }
        if (type.equals(Bindings.INT_ARRAY.type())) {
            return Bindings.INT_ARRAY;
        }
        if (type.equals(Bindings.LONG_ARRAY.type())) {
            return Bindings.LONG_ARRAY;
        }
        if (type.equals(Bindings.FLOAT_ARRAY.type())) {
            return Bindings.FLOAT_ARRAY;
        }
        if (type.equals(Bindings.DOUBLE_ARRAY.type())) {
            return Bindings.DOUBLE_ARRAY;
        }
        if (type.equals(Bindings.BOOLEAN_ARRAY.type())) {
            return Bindings.BOOLEAN_ARRAY;
        }
        if (type.equals(Bindings.STRING_ARRAY.type())) {
            return Bindings.STRING_ARRAY;
        }
        if (type instanceof BooleanType) {
            return new BooleanBindingDefault((BooleanType)type);
        }
        if (type instanceof DoubleType) {
            return new DoubleBindingDefault((DoubleType)type);
        }
        if (type instanceof FloatType) {
            return new FloatBindingDefault((FloatType)type);
        }
        if (type instanceof ByteType) {
            return new ByteBindingDefault((ByteType)type);
        }
        if (type instanceof IntegerType) {
            return new IntegerBindingDefault((IntegerType)type);
        }
        if (type instanceof LongType) {
            return new LongBindingDefault((LongType)type);
        }
        if (type instanceof StringType) {
            return new StringBindingDefault((StringType)type);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Datatype componentType = arrayType.componentType();
            if (componentType instanceof BooleanType) {
                return BooleanArrayBinding.createFrom(arrayType);
            }
            if (componentType instanceof ByteType) {
                return ByteArrayBinding.createFrom(arrayType);
            }
            if (componentType instanceof IntegerType) {
                return IntArrayBinding.createFrom(arrayType);
            }
            if (componentType instanceof LongType) {
                return LongArrayBinding.createFrom(arrayType);
            }
            if (componentType instanceof FloatType) {
                return FloatArrayBinding.createFrom(arrayType);
            }
            if (componentType instanceof DoubleType) {
                return DoubleArrayBinding.createFrom(arrayType);
            }
            ObjectArrayBinding binding = new ObjectArrayBinding(arrayType, null);
            this.inprogress.put(type, binding);
            binding.componentBinding = this.construct(componentType);
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof OptionalType) {
            OptionalType optionalType = (OptionalType)type;
            Datatype componentType = optionalType.componentType;
            ContainerOptionalBinding binding = new ContainerOptionalBinding(optionalType, null);
            this.inprogress.put(type, binding);
            binding.componentBinding = this.construct(componentType);
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof RecordType) {
            RecordType recordType = (RecordType)type;
            Binding[] componentBindings = new Binding[recordType.getComponentCount()];
            RecordObjectArrayBinding binding = new RecordObjectArrayBinding(recordType, componentBindings);
            this.inprogress.put(type, binding);
            int i = 0;
            while (i < componentBindings.length) {
                componentBindings[i] = this.construct(recordType.getComponentType(i));
                ++i;
            }
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            Binding[] componentBindings = new Binding[unionType.components.length];
            UnionTaggedObjectBinding binding = new UnionTaggedObjectBinding(unionType, componentBindings);
            this.inprogress.put(type, binding);
            int i = 0;
            while (i < componentBindings.length) {
                componentBindings[i] = this.construct(unionType.getComponent((int)i).type);
                ++i;
            }
            this.inprogress.remove(type);
            return binding;
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            DefaultMapBinding binding = new DefaultMapBinding(mapType, null, null);
            this.inprogress.put(type, binding);
            binding.setKeyBinding(this.construct(mapType.keyType));
            binding.setValueBinding(this.construct(mapType.valueType));
            this.inprogress.remove(type);
            return binding;
        }
        throw new BindingConstructionException("Unexpected, I don't know how to create binding for " + type);
    }

    @Override
    public boolean supportsType(Datatype type) {
        return !this.failures.containsKey(type);
    }
}

