/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.classfactory;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.simantics.databoard.annotations.Arguments;
import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.annotations.MIMEType;
import org.simantics.databoard.annotations.Name;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Pattern;
import org.simantics.databoard.annotations.Range;
import org.simantics.databoard.annotations.Referable;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.binding.classfactory.SignatureVisitor;
import org.simantics.databoard.binding.classfactory.TypeClassFactory;
import org.simantics.databoard.binding.classfactory.TypeClassSubFactory;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.AsmBindingClassLoader;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.Bean;

public class AsmTypeClassFactory
extends ClassLoader
implements Opcodes,
TypeClassSubFactory {
    boolean makeBean = true;
    TypeClassFactory classFactory;
    Map<String, Datatype> signatureCache = new HashMap<String, Datatype>();
    private static final java.util.regex.Pattern validJavaName = java.util.regex.Pattern.compile("[a-zA-Z][\\w]*");

    public AsmTypeClassFactory(TypeClassFactory classFactory) {
        super(AsmTypeClassFactory.class.getClassLoader());
        this.classFactory = classFactory;
    }

    public void setBeanMaker(boolean makeBean) {
        this.makeBean = makeBean;
    }

    @Override
    public BindingRequest construct(TypeClassFactory mainFactory, Datatype type) throws BindingConstructionException {
        if (type instanceof RecordType) {
            RecordType rt = (RecordType)type;
            SignatureVisitor sv = new SignatureVisitor();
            type.accept(sv, null);
            String sig = String.valueOf(sv.sb.toString()) + "_" + Integer.toHexString(sv.hashcode);
            String className = "org.simantics.databoard.RecordType_" + sig;
            String classSig = "Lorg/simantics/databoard/RecordType_" + sig + ";";
            BindingRequest br = new BindingRequest(this, className, classSig, classSig, new Annotation[0]);
            this.signatureCache.put(className, rt);
            return br;
        }
        if (type instanceof UnionType) {
            UnionType ut = (UnionType)type;
            SignatureVisitor sv = new SignatureVisitor();
            type.accept(sv, null);
            String sig = String.valueOf(sv.sb.toString()) + "_" + Integer.toHexString(sv.hashcode);
            if (ut.isEnumeration()) {
                String className = "org.simantics.databoard.EnumType_" + sig;
                String classSig = "Lorg/simantics/databoard/EnumType_" + sig + ";";
                BindingRequest br = new BindingRequest(this, className, classSig, classSig, new Annotation[0]);
                this.signatureCache.put(className, ut);
                return br;
            }
            String className = "org.simantics.databoard.UnionType_" + sig;
            String classSig = "Lorg/simantics/databoard/UnionType_" + sig + ";";
            BindingRequest br = new BindingRequest(this, className, classSig, classSig, new Annotation[0]);
            this.signatureCache.put(className, ut);
            return br;
        }
        return null;
    }

    @Override
    protected synchronized Class<?> findClass(String className) throws ClassNotFoundException {
        Datatype type = this.signatureCache.get(className);
        if (type == null) {
            BindingRequest br = this.classFactory.getRepository().getRequest(className);
            if (br != null && br.getClazz() != null) {
                return br.getClazz();
            }
            return Class.forName(className);
        }
        try {
            if (type instanceof RecordType) {
                RecordType rt = (RecordType)type;
                return this.createRecordClass(rt);
            }
            if (type instanceof UnionType) {
                UnionType ut = (UnionType)type;
                if (ut.isEnumeration()) {
                    return this.createEnumClass(ut);
                }
                return this.createUnionClass(ut);
            }
            throw new ClassNotFoundException(className);
        }
        catch (BindingConstructionException bce) {
            throw new ClassNotFoundException(className, bce);
        }
    }

    public Class<?> createRecordClass(RecordType type) throws BindingConstructionException {
        AnnotationVisitor av0;
        ClassWriter cw = new ClassWriter(0);
        SignatureVisitor sv = new SignatureVisitor();
        type.accept(sv, null);
        String sig = String.valueOf(sv.sb.toString()) + "_" + Integer.toHexString(sv.hashcode);
        Integer.toHexString(type.hashCode());
        String className = "org.simantics.databoard.RecordType_" + sig;
        String classSig = "org/simantics/databoard/RecordType_" + sig;
        Class superClass = this.makeBean ? Bean.class : Object.class;
        String superType = AsmBindingClassLoader.toClassCanonicalName(superClass);
        cw.visit(50, 33, classSig, null, superType, null);
        if (type.isReferable()) {
            av0 = cw.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Referable.class), true);
            av0.visitEnd();
        }
        int i = 0;
        while (i < type.getComponentCount()) {
            Component c = type.getComponent(i);
            Datatype fieldType = c.type;
            boolean isOptional = fieldType instanceof OptionalType;
            boolean isIdentifier = type.isIdentifier(i);
            if (isOptional) {
                fieldType = ((OptionalType)fieldType).componentType;
            }
            String fieldName = AsmTypeClassFactory.toJavaFieldName(c.name);
            BindingRequest br = this.classFactory.getClass(fieldType);
            FieldVisitor fv = cw.visitField(1, fieldName, br.signature, br.descriptor.equals(br.signature) ? null : br.descriptor, null);
            if (br.annotations != null && br.annotations.length > 0) {
                Annotation[] annotationArray = br.annotations;
                int n = br.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4;
                    Object[] objectArray;
                    AnnotationVisitor av1;
                    Annotation arg;
                    Annotation a = annotationArray[n2];
                    if (a instanceof Arguments) {
                        arg = (Arguments)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Arguments.class), true);
                        av1 = av0.visitArray("value");
                        objectArray = arg.value();
                        n4 = objectArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            Object clzz = objectArray[n3];
                            av1.visit(null, (Object)Type.getType((String)AsmBindingClassLoader.toTypeDescriptor(clzz)));
                            ++n3;
                        }
                        av1.visitEnd();
                        av0.visitEnd();
                    }
                    isIdentifier |= a instanceof Identifier;
                    if (a instanceof Length) {
                        arg = (Length)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Length.class), true);
                        av1 = av0.visitArray("value");
                        objectArray = arg.value();
                        n4 = objectArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            Object s = objectArray[n3];
                            av1.visit(null, s);
                            ++n3;
                        }
                        av1.visitEnd();
                        av0.visitEnd();
                    }
                    if (a instanceof MIMEType) {
                        arg = (MIMEType)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(MIMEType.class), true);
                        av0.visit("value", (Object)arg.value());
                        av0.visitEnd();
                    }
                    if (a instanceof Name) {
                        arg = (Name)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Name.class), true);
                        av0.visit("value", (Object)arg.value());
                        av0.visitEnd();
                    }
                    isOptional |= a instanceof Optional;
                    if (a instanceof Pattern) {
                        arg = (Pattern)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Pattern.class), true);
                        av0.visit("value", (Object)arg.value());
                        av0.visitEnd();
                    }
                    if (a instanceof Range) {
                        arg = (Range)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Range.class), true);
                        av0.visit("value", (Object)arg.value());
                        av0.visitEnd();
                    }
                    if (a instanceof Unit) {
                        arg = (Unit)a;
                        av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Unit.class), true);
                        av0.visit("value", (Object)arg.value());
                        av0.visitEnd();
                    }
                    ++n2;
                }
            }
            if (isIdentifier) {
                av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Identifier.class), true);
                av0.visitEnd();
            }
            if (isOptional) {
                av0 = fv.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Optional.class), true);
                av0.visitEnd();
            }
            fv.visitEnd();
            ++i;
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        if (!this.makeBean) {
            mv.visitLabel(l0);
            mv.visitLineNumber(20, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, superType, "<init>", "()V");
        } else {
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, classSig, "getStaticBinding", "()Lorg/simantics/databoard/binding/Binding;");
            mv.visitMethodInsn(183, "org/simantics/databoard/util/Bean", "<init>", "(Lorg/simantics/databoard/binding/Binding;)V");
        }
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + classSig + ";", null, l0, l1, 0);
        if (!this.makeBean) {
            mv.visitMaxs(1, 1);
        } else {
            mv.visitMaxs(2, 1);
        }
        mv.visitEnd();
        FieldVisitor fv = cw.visitField(8, "BINDING", "Lorg/simantics/databoard/binding/Binding;", null, null);
        fv.visitEnd();
        MethodVisitor mv2 = cw.visitMethod(8, "getStaticBinding", "()Lorg/simantics/databoard/binding/Binding;", null, null);
        mv2.visitCode();
        Label l02 = new Label();
        mv2.visitLabel(l02);
        mv2.visitFieldInsn(178, classSig, "BINDING", "Lorg/simantics/databoard/binding/Binding;");
        Label l12 = new Label();
        mv2.visitJumpInsn(199, l12);
        mv2.visitLdcInsn((Object)Type.getType((String)("L" + classSig + ";")));
        mv2.visitMethodInsn(184, "org/simantics/databoard/Bindings", "getBindingUnchecked", "(Ljava/lang/Class;)Lorg/simantics/databoard/binding/Binding;");
        mv2.visitFieldInsn(179, classSig, "BINDING", "Lorg/simantics/databoard/binding/Binding;");
        mv2.visitLabel(l12);
        mv2.visitFrame(3, 0, null, 0, null);
        mv2.visitFieldInsn(178, classSig, "BINDING", "Lorg/simantics/databoard/binding/Binding;");
        mv2.visitInsn(176);
        mv2.visitMaxs(1, 0);
        mv2.visitEnd();
        cw.visitEnd();
        byte[] data = cw.toByteArray();
        Class<?> clazz = this.defineClass(className, data, 0, data.length);
        new BindingRequest(clazz);
        return clazz;
    }

    private static String toJavaFieldName(String name) {
        if (name.equals("")) {
            return "_";
        }
        Matcher m = validJavaName.matcher(name);
        if (m.matches()) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        char fc = name.charAt(0);
        int i = 0;
        while (i < name.length()) {
            boolean vc;
            char c = name.charAt(i);
            if (i == 0) {
                vc = fc >= 'a' && fc < 'z' || fc >= 'A' && fc < 'Z';
            } else {
                boolean bl = vc = c >= 'a' && c < 'z' || c >= 'A' && c < 'Z' || c == '_' || c >= '0' && fc <= '9';
            }
            if (vc) {
                sb.append('_');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public Class<?> createEnumClass(UnionType ut) {
        return null;
    }

    public Class<?> createUnionClass(UnionType ut) throws BindingConstructionException {
        ClassWriter cw = new ClassWriter(0);
        SignatureVisitor sv = new SignatureVisitor();
        ut.accept(sv, null);
        String sig = String.valueOf(sv.sb.toString()) + "_" + Integer.toHexString(sv.hashcode);
        Integer.toHexString(ut.hashCode());
        String className = "org.simantics.databoard.UnionType_" + sig;
        String classSig = "org/simantics/databoard/UnionType_" + sig;
        Class<Object> superClass = Object.class;
        String superType = AsmBindingClassLoader.toClassCanonicalName(superClass);
        cw.visit(50, 33, classSig, null, superType, null);
        AnnotationVisitor av0 = cw.visitAnnotation(AsmBindingClassLoader.toTypeDescriptor(Union.class), true);
        AnnotationVisitor av1 = av0.visitArray("value");
        Component[] componentArray = ut.components;
        int n = ut.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            BindingRequest br = this.classFactory.getClass(c.type);
            av1.visit(null, (Object)Type.getType((String)br.descriptor));
            ++n2;
        }
        av1.visitEnd();
        av0.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(20, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + classSig + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] data = cw.toByteArray();
        return this.defineClass(className, data, 0, data.length);
    }
}

