/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.util.IdentityPair;

public abstract class MapBinding
extends Binding {
    protected Binding keyBinding;
    protected Binding valueBinding;

    public MapBinding(Binding keyBinding, Binding valueBinding) {
        this.type = new MapType(keyBinding.type(), valueBinding.type());
        this.keyBinding = keyBinding;
        this.valueBinding = valueBinding;
    }

    public MapBinding(MapType mapType, Binding keyBinding, Binding valueBinding) {
        this.keyBinding = keyBinding;
        this.valueBinding = valueBinding;
        this.type = mapType;
    }

    @Override
    public MapType type() {
        return (MapType)this.type;
    }

    public Binding getKeyBinding() {
        return this.keyBinding;
    }

    public Binding getValueBinding() {
        return this.valueBinding;
    }

    public void setKeyBinding(Binding keyBinding) {
        this.keyBinding = keyBinding;
        if (!this.type().keyType.equals(keyBinding.type())) {
            throw new IllegalArgumentException("Binding for " + this.type().keyType + " expected, got " + keyBinding.type());
        }
    }

    public void setValueBinding(Binding valueBinding) {
        this.valueBinding = valueBinding;
        if (!this.type().valueType.equals(valueBinding.type())) {
            throw new IllegalArgumentException("Binding for " + this.type().valueType + " expected, got " + valueBinding.type());
        }
    }

    public abstract Object create() throws BindingException;

    public abstract Object create(Map<?, ?> var1) throws BindingException;

    public abstract Object create(List<Object> var1, List<Object> var2) throws BindingException;

    public abstract Object create(Object[] var1, Object[] var2) throws BindingException;

    public abstract int size(Object var1) throws BindingException;

    public abstract Object get(Object var1, Object var2) throws BindingException;

    public abstract boolean containsKey(Object var1, Object var2) throws BindingException;

    public abstract boolean containsValue(Object var1, Object var2) throws BindingException;

    public abstract <K, V> void put(Object var1, K var2, V var3) throws BindingException;

    public abstract Object remove(Object var1, Object var2) throws BindingException;

    public abstract <K, V> void putAll(Object var1, Map<K, V> var2) throws BindingException;

    public abstract <K, V> void getAll(Object var1, Map<K, V> var2) throws BindingException;

    public abstract void getAll(Object var1, Object[] var2, Object[] var3) throws BindingException;

    public abstract Object[] getKeys(Object var1) throws BindingException;

    public abstract void getKeys(Object var1, Set<Object> var2) throws BindingException;

    public abstract int count(Object var1, Object var2, boolean var3, Object var4, boolean var5) throws BindingException;

    public abstract int getEntries(Object var1, Object var2, boolean var3, Object var4, boolean var5, ArrayBinding var6, Object var7, ArrayBinding var8, Object var9, int var10) throws BindingException;

    public abstract Object[] getValues(Object var1) throws BindingException;

    public abstract void clear(Object var1) throws BindingException;

    @Override
    public void assertInstaceIsValid(Object map, Set<Object> validInstances) throws BindingException {
        if (!this.isInstance(map)) {
            throw new BindingException("Not a map");
        }
        Object[] objectArray = this.getKeys(map);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            this.keyBinding.assertInstaceIsValid(key, validInstances);
            Object value = this.get(map, key);
            this.valueBinding.assertInstaceIsValid(value, validInstances);
            ++n2;
        }
    }

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        try {
            MapBinding sb = (MapBinding)srcBinding;
            Binding dkb = this.getKeyBinding();
            Binding dvb = this.getValueBinding();
            TreeSet<Object> oldKeys = new TreeSet<Object>(dkb);
            this.getKeys(dst, oldKeys);
            Binding skb = sb.getKeyBinding();
            Binding svb = sb.getValueBinding();
            boolean cbImmutable = dvb.isImmutable();
            Adapter ka = Bindings.adapterFactory.getAdapter(skb, dkb, false, false);
            Adapter va = cbImmutable ? Bindings.adapterFactory.getAdapter(svb, dvb, false, true) : null;
            Object[] objectArray = sb.getKeys(src);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object dv;
                Object object = objectArray[n2];
                Object dk = ka.adapt(object);
                Object sv = sb.get(src, object);
                if (cbImmutable) {
                    dv = va.adapt(sv);
                    this.put(dst, dk, dv);
                } else if (this.containsKey(dst, dk)) {
                    dv = this.get(dst, dk);
                    dv = dvb.readFromTry(svb, sv, dv);
                    this.put(dst, dk, dv);
                } else {
                    dv = dvb.createDefault();
                    dv = dvb.readFromTry(svb, sv, dv);
                    this.put(dst, dk, dv);
                }
                oldKeys.remove(dk);
                ++n2;
            }
            for (Object e : oldKeys) {
                this.remove(dst, e);
            }
        }
        catch (AdapterConstructionException e) {
            throw new BindingException(e);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public int deepHashValue(Object map, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 0;
        Object[] keys = this.getKeys(map);
        Object[] values = this.getValues(map);
        int len = this.size(map);
        int i = 0;
        while (i < len) {
            Object key = keys[i];
            Object value = values[i];
            int keyHash = this.keyBinding.deepHashValue(key, hashedObjects);
            int valueHash = this.valueBinding.deepHashValue(value, hashedObjects);
            result += keyHash ^ valueHash;
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        int l2;
        int l1 = this.size(o1);
        int dif = l1 - (l2 = this.size(o2));
        if (dif != 0) {
            return dif;
        }
        Binding k = this.getKeyBinding();
        Binding v = this.getValueBinding();
        TreeMap e1 = new TreeMap(k);
        TreeMap e2 = new TreeMap(k);
        this.getAll(o1, e1);
        this.getAll(o2, e2);
        Iterator i1 = e1.entrySet().iterator();
        Iterator i2 = e2.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry h1 = i1.next();
            Map.Entry h2 = i2.next();
            dif = k.deepCompare(h1.getKey(), h2.getKey(), compareHistory);
            if (dif != 0) {
                return dif;
            }
            dif = v.deepCompare(h1.getValue(), h2.getValue(), compareHistory);
            if (dif != 0) {
                return dif;
            }
            i1.remove();
            i2.remove();
        }
        return 0;
    }

    public Object createUnchecked(Object[] keys, Object[] values) throws RuntimeBindingException {
        try {
            return this.create(keys, values);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Object createUnchecked(List<Object> keys, List<Object> values) throws RuntimeBindingException {
        try {
            return this.create(keys, values);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Object createUnchecked(Map<Object, Object> initialMap) throws RuntimeBindingException {
        try {
            return this.create(initialMap);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Object createUnchecked() throws RuntimeBindingException {
        try {
            return this.create();
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public abstract Object getFirstKey(Object var1);

    public abstract Object getLastKey(Object var1);

    public abstract Object getLowerKey(Object var1, Object var2);

    public abstract Object getFloorKey(Object var1, Object var2);

    public abstract Object getCeilingKey(Object var1, Object var2);

    public abstract Object getHigherKey(Object var1, Object var2);

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        Binding keyBinding = this.getKeyBinding();
        Binding valueBinding = this.getValueBinding();
        ctx.b.append("{ ");
        boolean first = true;
        Object[] objectArray = this.getKeys(value);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (first) {
                first = false;
            } else {
                ctx.b.append(", ");
                if (!ctx.singleLine) {
                    ctx.b.append('\n');
                }
            }
            keyBinding.toString(key, ctx);
            ctx.b.append(" = ");
            valueBinding.toString(this.get(value, key), ctx);
            ++n2;
        }
        ctx.b.append(" }");
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            if (ir.index == 0) {
                return this.keyBinding.getComponentBinding(path.childReference);
            }
            if (ir.index == 1) {
                return this.valueBinding.getComponentBinding(path.childReference);
            }
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            if (lr.label.equals("0") || lr.label.equals("key")) {
                return this.keyBinding.getComponentBinding(path.childReference);
            }
            if (lr.label.equals("1") || lr.label.equals("value")) {
                return this.valueBinding.getComponentBinding(path.childReference);
            }
        }
        if (path instanceof NameReference) {
            NameReference nr = (NameReference)path;
            if (nr.name.equals("key")) {
                return this.keyBinding.getComponentBinding(path.childReference);
            }
            if (nr.name.equals("value")) {
                return this.valueBinding.getComponentBinding(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getComponentCount() {
        return 2;
    }

    @Override
    public Binding getComponentBinding(int index) {
        if (index == 0) {
            return this.keyBinding;
        }
        if (index == 1) {
            return this.valueBinding;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Binding, Binding>> compareHistory) {
        MapBinding o = (MapBinding)obj;
        return super.deepEquals(obj, compareHistory) && this.keyBinding.equals((Object)o.keyBinding, compareHistory) && this.valueBinding.equals((Object)o.valueBinding, compareHistory);
    }

    @Override
    public int deepHashCode(IdentityHashMap<Object, Object> hashedObjects) {
        return super.deepHashCode(hashedObjects) + 13 * this.keyBinding.hashCode(hashedObjects) + 17 * this.valueBinding.hashCode(hashedObjects);
    }
}

