/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.adapter.RuntimeAdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.binding.util.DefaultValue;
import org.simantics.databoard.binding.util.RandomValue;
import org.simantics.databoard.parser.DataParser;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.ParseException;
import org.simantics.databoard.parser.PrintFormat;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;

public abstract class Binding
implements Comparator<Object> {
    protected Datatype type;
    protected transient Serializer binarySerializer;

    public Datatype type() {
        return this.type;
    }

    protected void setType(Datatype type) {
        this.type = type;
    }

    public abstract void accept(Visitor1 var1, Object var2);

    public abstract <T> T accept(Visitor<T> var1);

    public Serializer cachedSerializer() {
        return this.binarySerializer;
    }

    public void cacheSerializer(Serializer serializer) {
        this.binarySerializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Serializer serializer() throws RuntimeSerializerConstructionException {
        if (this.binarySerializer == null) {
            Binding binding = this;
            synchronized (binding) {
                if (this.binarySerializer == null) {
                    this.binarySerializer = Bindings.serializationFactory.getSerializerUnchecked(this);
                }
            }
        }
        return this.binarySerializer;
    }

    public abstract boolean isInstance(Object var1);

    public boolean isImmutable() {
        return false;
    }

    public abstract void readFrom(Binding var1, Object var2, Object var3) throws BindingException;

    public void readFromUnchecked(Binding srcBinding, Object src, Object dst) throws RuntimeBindingException {
        try {
            this.readFrom(srcBinding, src, dst);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        this.readFrom(srcBinding, src, dst);
        return dst;
    }

    public Object readFromTryUnchecked(Binding srcBinding, Object src, Object dst) throws BindingException {
        try {
            return this.readFromTry(srcBinding, src, dst);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void assertInstaceIsValid(Object obj) throws BindingException {
        this.assertInstaceIsValid(obj, null);
    }

    public abstract void assertInstaceIsValid(Object var1, Set<Object> var2) throws BindingException;

    public Object parseValue(Reader stream, DataValueRepository repository) throws DataTypeSyntaxError, BindingException {
        DataParser parser = new DataParser(stream);
        try {
            return new DataValueRepository().translate(parser.value(), this);
        }
        catch (ParseException e) {
            throw new DataTypeSyntaxError(e);
        }
    }

    public Object parseValue(String text, DataValueRepository repository) throws DataTypeSyntaxError, BindingException {
        return repository.translate(text, this);
    }

    public Object parseValueDefinition(String text) throws DataTypeSyntaxError, BindingException {
        try {
            DataValueRepository repo = new DataValueRepository();
            String name = repo.addValueDefinition("value : Variant = " + text);
            MutableVariant value = repo.get(name);
            return value.getValue(this);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    public String printValueDefinition(Object value, boolean singleLine) throws IOException, BindingException {
        DataValueRepository valueRepository = new DataValueRepository();
        valueRepository.put("value", this, value);
        StringBuilder sb = new StringBuilder();
        DataValuePrinter vp = new DataValuePrinter(sb, valueRepository);
        vp.setFormat(PrintFormat.MULTI_LINE);
        vp.print(this, value);
        return sb.toString();
    }

    public void printValue(Object value, Appendable out, DataValueRepository valueRepository, boolean singleLine) throws IOException, BindingException {
        DataValuePrinter writable = new DataValuePrinter(out, valueRepository);
        writable.setFormat(singleLine ? PrintFormat.SINGLE_LINE : PrintFormat.MULTI_LINE);
        writable.print(this, value);
    }

    public int hashValue(Object value) throws BindingException {
        return this.deepHashValue(value, null);
    }

    public abstract int deepHashValue(Object var1, IdentityHashMap<Object, Object> var2) throws BindingException;

    @Override
    public int compare(Object o1, Object o2) throws RuntimeBindingException {
        if (o1 == o2) {
            return 0;
        }
        if (!this.isInstance(o1)) {
            throw new IllegalArgumentException(o1 + " is not of expected class");
        }
        if (!this.isInstance(o2)) {
            throw new IllegalArgumentException(o2 + " is not of expected class");
        }
        try {
            return this.deepCompare(o1, o2, null);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public boolean equals(Object o1, Object o2) throws RuntimeBindingException {
        int dif = this.compare(o1, o2);
        return dif == 0;
    }

    public Object clone(Object o) throws AdaptException {
        try {
            return Bindings.adapterFactory.getAdapter(this, this, false, true).adapt(o);
        }
        catch (AdapterConstructionException e) {
            throw new AdaptException(e);
        }
    }

    public Object cloneUnchecked(Object o) throws RuntimeAdaptException {
        try {
            return Bindings.adapterFactory.getAdapter(this, this, false, true).adapt(o);
        }
        catch (AdaptException e) {
            throw new RuntimeAdaptException(e);
        }
        catch (AdapterConstructionException e) {
            throw new RuntimeAdaptException(new AdaptException(e));
        }
    }

    public abstract int deepCompare(Object var1, Object var2, Set<IdentityPair<Object, Object>> var3) throws BindingException;

    public Object createDefault() throws BindingException {
        try {
            return this.accept(new DefaultValue());
        }
        catch (RuntimeBindingException e) {
            throw e.getCause();
        }
    }

    public Object createDefaultUnchecked() throws RuntimeBindingException {
        return this.accept(new DefaultValue());
    }

    public Object createRandom(int seed) throws BindingException {
        try {
            return this.accept(new RandomValue(seed));
        }
        catch (RuntimeBindingException e) {
            throw e.getCause();
        }
    }

    public Object createRandom(RandomValue rv) throws BindingException {
        try {
            return this.accept(rv);
        }
        catch (RuntimeBindingException e) {
            throw e.getCause();
        }
    }

    public Object createRandom(Random random) throws BindingException {
        try {
            return this.accept(new RandomValue(random));
        }
        catch (RuntimeBindingException e) {
            throw e.getCause();
        }
    }

    public Object createRandomUnchecked(int seed) throws RuntimeBindingException {
        return this.accept(new RandomValue(seed));
    }

    public String toString(Object value) throws BindingException {
        BindingPrintContext ctx = new BindingPrintContext();
        this.toString(value, ctx);
        return ctx.b.toString();
    }

    public String toStringUnchecked(Object value) {
        try {
            BindingPrintContext ctx = new BindingPrintContext();
            this.toString(value, ctx);
            return ctx.b.toString();
        }
        catch (BindingException e) {
            return e.toString();
        }
    }

    public String toString(Object value, boolean singleLine) throws BindingException {
        BindingPrintContext ctx = new BindingPrintContext();
        ctx.singleLine = singleLine;
        this.toString(value, ctx);
        return ctx.b.toString();
    }

    protected abstract void toString(Object var1, BindingPrintContext var2) throws BindingException;

    public abstract int getComponentCount();

    public Object getComponent(Object object, ChildReference ref) throws BindingException {
        MutableVariant value = new MutableVariant(this, object);
        try {
            return ((Variant)value).getComponent(ref).getValue();
        }
        catch (AccessorConstructionException e) {
            throw new BindingException("Component access failed.", e);
        }
    }

    public Object getComponent(Object object, ChildReference ref, Binding binding) throws BindingException {
        Binding componentBinding = this.getComponentBinding(ref);
        MutableVariant value = new MutableVariant(this, object);
        try {
            return Bindings.adapt(((Variant)value).getComponent(ref), componentBinding, binding);
        }
        catch (AccessorConstructionException | AdaptException e) {
            throw new BindingException("Component access failed.", e);
        }
    }

    public void setComponent(Object object, ChildReference ref, Binding binding, Object componentValue) throws BindingException {
        MutableVariant value = new MutableVariant(this, object);
        try {
            value.setComponent(ref, binding, componentValue);
        }
        catch (AccessorConstructionException | AccessorException e) {
            throw new BindingException("Component access failed.", e);
        }
    }

    public abstract Binding getComponentBinding(int var1);

    public abstract Binding getComponentBinding(ChildReference var1);

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals(obj, new HashSet<IdentityPair<Binding, Binding>>());
    }

    protected final boolean equals(Object obj, Set<IdentityPair<Binding, Binding>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityPair<Binding, Binding> pair = new IdentityPair<Binding, Binding>(this, (Binding)obj);
        if (compareHistory.contains(pair)) {
            return true;
        }
        compareHistory.add(pair);
        return this.deepEquals(obj, compareHistory);
    }

    protected boolean baseEquals(Object obj) {
        return this.type == null ? ((Binding)obj).type == null : this.type.equals(((Binding)obj).type);
    }

    protected boolean deepEquals(Object obj, Set<IdentityPair<Binding, Binding>> compareHistory) {
        return this.baseEquals(obj);
    }

    public final int hashCode() {
        return this.deepHashCode(new IdentityHashMap<Object, Object>());
    }

    protected final int hashCode(IdentityHashMap<Object, Object> hashedObjects) {
        if (hashedObjects.containsKey(this)) {
            return 0;
        }
        hashedObjects.put(this, null);
        return this.deepHashCode(hashedObjects);
    }

    protected int baseHashCode() {
        return this.getClass().hashCode() + (this.type != null ? 3 * this.type.hashCode() : 0);
    }

    protected int deepHashCode(IdentityHashMap<Object, Object> hashedObjects) {
        return this.baseHashCode();
    }

    public static interface Visitor<T> {
        public T visit(ArrayBinding var1);

        public T visit(BooleanBinding var1);

        public T visit(DoubleBinding var1);

        public T visit(FloatBinding var1);

        public T visit(IntegerBinding var1);

        public T visit(ByteBinding var1);

        public T visit(LongBinding var1);

        public T visit(OptionalBinding var1);

        public T visit(RecordBinding var1);

        public T visit(StringBinding var1);

        public T visit(UnionBinding var1);

        public T visit(VariantBinding var1);

        public T visit(MapBinding var1);
    }

    public static interface Visitor1 {
        public void visit(ArrayBinding var1, Object var2);

        public void visit(BooleanBinding var1, Object var2);

        public void visit(DoubleBinding var1, Object var2);

        public void visit(FloatBinding var1, Object var2);

        public void visit(IntegerBinding var1, Object var2);

        public void visit(ByteBinding var1, Object var2);

        public void visit(LongBinding var1, Object var2);

        public void visit(OptionalBinding var1, Object var2);

        public void visit(RecordBinding var1, Object var2);

        public void visit(StringBinding var1, Object var2);

        public void visit(UnionBinding var1, Object var2);

        public void visit(VariantBinding var1, Object var2);

        public void visit(MapBinding var1, Object var2);
    }
}

