/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Range;

public abstract class ArrayBinding
extends Binding {
    public Binding componentBinding;

    public ArrayBinding(ArrayType type, Binding componentBinding) {
        this.componentBinding = componentBinding;
        this.type = type;
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof ComponentReference) {
            return this.componentBinding.getComponentBinding(path.childReference);
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            if (ir.index == 0) {
                return this.componentBinding.getComponentBinding(path.childReference);
            }
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            if (lr.label.equals("v")) {
                return this.componentBinding.getComponentBinding(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isImmutable() {
        return super.isImmutable();
    }

    public abstract boolean isResizable();

    @Override
    public ArrayType type() {
        return (ArrayType)this.type;
    }

    public Binding getComponentBinding() {
        return this.componentBinding;
    }

    public abstract Object create();

    public Object create(Collection<Object> collection) throws BindingException {
        return this.create(collection.size(), collection.iterator());
    }

    public abstract Object create(int var1, Iterator<Object> var2) throws BindingException;

    public Object create(int length) throws BindingException {
        try {
            return this.create(length, new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Object next() {
                    try {
                        return ArrayBinding.this.componentBinding.createDefault();
                    }
                    catch (BindingException e) {
                        throw new RuntimeBindingException(e);
                    }
                }

                @Override
                public void remove() {
                }
            });
        }
        catch (RuntimeBindingException e) {
            throw e.getCause();
        }
    }

    public abstract Object create(Object[] var1) throws BindingException;

    public Object createUnchecked(Object ... array) throws RuntimeBindingException {
        try {
            return this.create(array);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        try {
            ArrayBinding sb = (ArrayBinding)srcBinding;
            Binding scb = sb.getComponentBinding();
            Binding dcb = this.getComponentBinding();
            int newLen = sb.size(src);
            int oldLen = this.size(dst);
            boolean cbImmutable = dcb.isImmutable();
            Adapter cloner = cbImmutable ? Bindings.adapterFactory.getAdapter(scb, dcb, false, true) : null;
            int i = 0;
            while (i < newLen) {
                Object dc;
                Object sc;
                if (cbImmutable) {
                    sc = sb.get(src, i);
                    dc = cloner.adapt(sc);
                    if (i < oldLen) {
                        this.set(dst, i, dc);
                    } else {
                        this.add(dst, dc);
                    }
                } else if (i < oldLen) {
                    Object dc2 = this.get(dst, i);
                    Object sc2 = sb.get(src, i);
                    dc2 = dcb.readFromTry(scb, sc2, dc2);
                    this.set(dst, i, dc2);
                } else {
                    sc = sb.get(src, i);
                    dc = dcb.createDefault();
                    dc = dcb.readFromTry(scb, sc, dc);
                    this.add(dst, dc);
                }
                ++i;
            }
            if (oldLen > newLen) {
                this.setSize(dst, newLen);
            }
            if (!Bindings.equals(srcBinding, src, this, dst)) {
                throw new BindingException("internal error");
            }
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
        catch (AdapterConstructionException e) {
            throw new BindingException(e);
        }
    }

    public void add(Object array, Object element) throws BindingException {
        int size = this.size(array);
        this.add(array, size, element);
    }

    public abstract void add(Object var1, int var2, Object var3) throws BindingException, IndexOutOfBoundsException;

    public void remove(Object array, int index) throws BindingException, IndexOutOfBoundsException {
        this.remove(array, index, 1);
    }

    public abstract void remove(Object var1, int var2, int var3) throws BindingException, IndexOutOfBoundsException;

    public abstract Object get(Object var1, int var2) throws BindingException, IndexOutOfBoundsException;

    public abstract void getAll(Object var1, Object[] var2) throws BindingException;

    public abstract void set(Object var1, int var2, Object var3) throws BindingException;

    public abstract void setSize(Object var1, int var2) throws BindingException;

    public abstract int size(Object var1) throws BindingException;

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        ArrayType type = this.type();
        int length = this.size(obj);
        Range range = type.getLength();
        if (range != null && !range.contains(length)) {
            throw new BindingException("Array length (=" + length + ")out of bounds. " + range + " was expected.");
        }
        int i = 0;
        while (i < length) {
            Object component = this.get(obj, i);
            this.componentBinding.assertInstaceIsValid(component, validInstances);
            ++i;
        }
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int result = 1;
        int len = this.size(value);
        int i = 0;
        while (i < len) {
            Object element = this.get(value, i);
            result = 31 * result + this.componentBinding.deepHashValue(element, hashedObjects);
            ++i;
        }
        return result;
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        int l2;
        int l1 = this.size(o1);
        int dif = l1 - (l2 = this.size(o2));
        if (dif != 0) {
            return dif;
        }
        Binding c = this.getComponentBinding();
        int i = 0;
        while (i < l1) {
            Object e2;
            Object e1 = this.get(o1, i);
            dif = c.deepCompare(e1, e2 = this.get(o2, i), compareHistory);
            if (dif != 0) {
                return dif;
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        Binding componentBinding = this.getComponentBinding();
        ctx.b.append('[');
        int size = this.size(value);
        boolean numberArray = componentBinding instanceof NumberBinding;
        boolean hasMany = size > 1;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                ctx.b.append(", ");
                if (hasMany && !numberArray && !ctx.singleLine) {
                    ctx.b.append("\n");
                }
            }
            componentBinding.toString(this.get(value, i), ctx);
            ++i;
        }
        ctx.b.append(']');
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public Binding getComponentBinding(int index) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        return this.componentBinding;
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Binding, Binding>> compareHistory) {
        return super.deepEquals(obj, compareHistory) && this.componentBinding.equals((Object)((ArrayBinding)obj).componentBinding, compareHistory);
    }

    @Override
    public int deepHashCode(IdentityHashMap<Object, Object> hashedObjects) {
        return super.deepHashCode(hashedObjects) + 13 * this.componentBinding.hashCode(hashedObjects);
    }
}

