/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.lang.ref.SoftReference;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.VariantAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.VariantInterestSet;
import org.simantics.databoard.accessor.java.JavaArray;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.java.JavaRecord;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.VariantType;

public class JavaVariant
extends JavaObject
implements VariantAccessor {
    SoftReference<JavaObject> child;

    public JavaVariant(Accessor parent, VariantBinding binding, Object object, AccessorParams params) {
        super(parent, binding, object, params);
    }

    @Override
    public VariantType type() {
        return (VariantType)this.binding.type();
    }

    @Override
    public VariantBinding getBinding() {
        return (VariantBinding)this.binding;
    }

    @Override
    public <T extends Accessor> T getContentAccessor() throws AccessorConstructionException {
        try {
            JavaObject sa = this.getExistingAccessor();
            if (sa == null) {
                this.readLock();
                try {
                    Binding cb = this.getBinding().getContentBinding(this.object);
                    Object cv = this.getBinding().getContent(this.object);
                    sa = JavaObject.createSubAccessor(this, cb, cv, this.params);
                    this.child = new SoftReference<JavaObject>(sa);
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        ChildReference childPath;
                        VariantInterestSet is = (VariantInterestSet)le.getInterestSet();
                        InterestSet cis = is.getComponentInterest();
                        if (cis != null) {
                            try {
                                childPath = ChildReference.concatenate(le.path, new ComponentReference());
                                sa.addListener(le.listener, cis, childPath, le.executor);
                            }
                            catch (AccessorException e) {
                                throw new AccessorConstructionException(e);
                            }
                        }
                        if (is.inCompleteComponent()) {
                            cis = InterestSet.newInterestSet(this.getContentType(), true, true, true);
                            try {
                                childPath = ChildReference.concatenate(le.path, new ComponentReference());
                                sa.addListener(le.listener, cis, childPath, le.executor);
                            }
                            catch (AccessorException e) {
                                throw new AccessorConstructionException(e);
                            }
                        }
                        le = le.next;
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
            return (T)sa;
        }
        catch (BindingException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            if (lr.label.equals("v")) {
                T sa = this.getContentAccessor();
                if (reference.getChildReference() != null) {
                    sa = sa.getComponent(reference.getChildReference());
                }
                return sa;
            }
        }
        if (reference instanceof ComponentReference) {
            T sa = this.getContentAccessor();
            if (reference.getChildReference() != null) {
                sa = sa.getComponent(reference.getChildReference());
            }
            return sa;
        }
        throw new ReferenceException("Variant value reference expected, got " + reference.getClass().getName());
    }

    protected JavaObject getExistingAccessor() {
        SoftReference<JavaObject> r = this.child;
        if (r == null) {
            return null;
        }
        JavaObject sa = r.get();
        return sa;
    }

    @Override
    public void setValue(Binding variantBinding, Object newVariant) throws AccessorException {
        this.writeLock();
        try {
            try {
                if (!(this.binding instanceof VariantBinding)) {
                    throw new AccessorException("VariantBinding is expected.");
                }
                Binding newValueBinding = ((VariantBinding)variantBinding).getContentBinding(newVariant);
                Object newValueObject = ((VariantBinding)variantBinding).getContent(newVariant);
                this.setContentValue(newValueBinding, newValueObject);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public Object getContentValue(Binding contentBinding) throws AccessorException {
        this.readLock();
        try {
            Object object = this.getBinding().getContent(this.object);
            return object;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Datatype getContentType() throws AccessorException {
        this.readLock();
        try {
            Datatype datatype = this.getBinding().getContentType(this.object);
            return datatype;
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setContentValue(Binding valueBinding, Object newValue) throws AccessorException {
        this.writeLock();
        try {
            JavaObject sa = this.getExistingAccessor();
            if (sa != null && valueBinding.type().equals(sa.type())) {
                sa.setValue(valueBinding, newValue);
                return;
            }
            try {
                Object nv;
                JavaObject jo;
                if (sa != null) {
                    sa.invalidatedNotification();
                    this.child = null;
                    sa = null;
                }
                if (this.binding.isImmutable() && this.parent != null && this.parent instanceof JavaArray) {
                    jo = (JavaObject)this.parent;
                    ArrayBinding ab = (ArrayBinding)jo.binding;
                    nv = this.getBinding().create(valueBinding, newValue);
                    ab.set(jo.object, (Integer)this.keyInParent, nv);
                    this.object = nv;
                } else if (this.binding.isImmutable() && this.parent != null && this.parent instanceof JavaRecord) {
                    jo = (JavaObject)this.parent;
                    RecordBinding rb = (RecordBinding)jo.binding;
                    nv = this.getBinding().create(valueBinding, newValue);
                    rb.setComponent(jo.object, (Integer)this.keyInParent, nv);
                    this.object = nv;
                } else if (this.binding.isImmutable() && this.parent != null && this.parent instanceof JavaVariant) {
                    jo = (JavaObject)this.parent;
                    VariantBinding vb = (VariantBinding)jo.binding;
                    nv = this.getBinding().create(valueBinding, newValue);
                    vb.setContent(jo.object, this.getBinding(), nv);
                    this.object = nv;
                } else {
                    this.getBinding().setContent(this.object, valueBinding, newValue);
                }
                ListenerEntry le = this.listeners;
                while (le != null) {
                    VariantInterestSet is = (VariantInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        if (is.inValues()) {
                            MutableVariant value = new MutableVariant(valueBinding, valueBinding.isImmutable() ? newValue : valueBinding.clone(newValue));
                            ValueAssigned e = new ValueAssigned(Bindings.MUTABLE_VARIANT, (Object)value);
                            this.emitEvent(le, e);
                        } else {
                            this.emitEvent(le, new ValueAssigned());
                        }
                    }
                    le = le.next;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        ChildReference childPath;
        super.addListener(listener, interestSet, path, executor);
        VariantInterestSet is = (VariantInterestSet)interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null && !is.inCompleteComponent()) {
            return;
        }
        JavaObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        if (cis != null) {
            childPath = ChildReference.concatenate(path, new ComponentReference());
            sa.addListener(listener, cis, childPath, executor);
        }
        if (is.inCompleteComponent()) {
            childPath = ChildReference.concatenate(path, new ComponentReference());
            cis = InterestSet.newInterestSet(this.getContentType(), true, true, true);
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        VariantInterestSet is = (VariantInterestSet)e.interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null && !is.inCompleteComponent()) {
            return;
        }
        JavaObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        if (cis != null) {
            sa.removeListener(listener);
        }
        if (is.inCompleteComponent()) {
            sa.removeListener(listener);
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        try {
            ValueAssigned rollback = null;
            if (e instanceof ValueAssigned) {
                ValueAssigned va = (ValueAssigned)e;
                if (va.newValue == null) {
                    throw new AccessorException("Cannot apply variant assignment event, the value is missing");
                }
                if (makeRollback) {
                    Binding cb = this.getBinding().getContentBinding(this.object);
                    Object cv = this.getBinding().getContent(this.object);
                    rollback = new ValueAssigned(Bindings.MUTABLE_VARIANT, (Object)new MutableVariant(cb, cv));
                }
                this.setValue(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            throw new AccessorException("Invalid event " + e.getClass().getName());
        }
        catch (BindingException be) {
            throw new AccessorException(be);
        }
    }
}

