/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.java;

import java.lang.ref.SoftReference;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ModificationEvent;
import org.simantics.databoard.accessor.event.UnionValueAssigned;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.UnionInterestSet;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.type.UnionType;

public class JavaUnion
extends JavaObject
implements UnionAccessor {
    SoftReference<JavaObject> component;

    public JavaUnion(Accessor parent, UnionBinding binding, Object object, AccessorParams params) {
        super(parent, binding, object, params);
    }

    @Override
    public UnionType type() {
        return (UnionType)this.binding.type();
    }

    @Override
    public UnionBinding getBinding() {
        return (UnionBinding)this.binding;
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        try {
            if (reference == null) {
                return (T)this;
            }
            if (reference instanceof LabelReference) {
                LabelReference lr = (LabelReference)reference;
                Integer tag = this.type().getComponentIndex(lr.label);
                if (tag == null && lr.label.equals("uv")) {
                    T result = this.getComponentAccessor();
                    if (reference.getChildReference() != null) {
                        result = result.getComponent(reference.getChildReference());
                    }
                    return result;
                }
                if (tag == null) {
                    throw new ReferenceException("Tag \"" + lr.label + "\" not found");
                }
                if (tag.intValue() != this.getTag()) {
                    throw new ReferenceException("The union isn't currently assigned with the expected type (" + this.type().getComponent((int)tag.intValue()).name + ")");
                }
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            if (reference instanceof ComponentReference) {
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            if (reference instanceof IndexReference) {
                IndexReference ir = (IndexReference)reference;
                if (ir.index < 0 || ir.index >= this.type().getComponentCount()) {
                    throw new ReferenceException("Tag index out of bounds");
                }
                if (ir.index != this.getTag()) {
                    throw new ReferenceException("The union isn't currently assigned with the expected type (" + this.type().getComponent((int)ir.index).name + ")");
                }
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            if (reference instanceof NameReference) {
                NameReference nr = (NameReference)reference;
                Integer tag = this.type().getComponentIndex(nr.name);
                if (tag == null) {
                    throw new ReferenceException("Tag by name \"" + nr.name + "\" is not found");
                }
                if (tag.intValue() != this.getTag()) {
                    throw new ReferenceException("The union isn't currently assigned with the expected type (" + this.type().getComponent((int)tag.intValue()).name + ")");
                }
                T result = this.getComponentAccessor();
                if (reference.getChildReference() != null) {
                    result = result.getComponent(reference.getChildReference());
                }
                return result;
            }
            throw new ReferenceException(reference.getClass() + " is not a reference of UnionType");
        }
        catch (AccessorException ae) {
            throw new AccessorConstructionException(ae);
        }
    }

    @Override
    public int count() throws AccessorException {
        return this.type().getComponentCount();
    }

    JavaObject getExistingAccessor() {
        SoftReference<JavaObject> c = this.component;
        if (c == null) {
            return null;
        }
        return c.get();
    }

    @Override
    public void setValue(Binding unionBinding, Object newUnionValue) throws AccessorException {
        this.writeLock();
        try {
            try {
                UnionBinding newUb = (UnionBinding)unionBinding;
                int tag = newUb.getTag(newUnionValue);
                Binding cb = newUb.getComponentBinding(tag);
                Object cv = newUb.getValue(newUnionValue);
                this.setComponentValue(tag, cb, cv);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponentAccessor() throws AccessorConstructionException {
        try {
            JavaObject sa = this.getExistingAccessor();
            if (sa == null) {
                this.readLock();
                try {
                    int tag = this.getBinding().getTag(this.object);
                    Binding cb = this.getBinding().getComponentBinding(tag);
                    Object cv = this.getBinding().getValue(this.object);
                    sa = JavaUnion.createSubAccessor(this, cb, cv, this.params);
                    this.component = new SoftReference<JavaObject>(sa);
                    ListenerEntry le = this.listeners;
                    while (le != null) {
                        UnionInterestSet is = (UnionInterestSet)le.getInterestSet();
                        InterestSet cis = is.getComponentInterest(tag);
                        if (cis != null) {
                            try {
                                ChildReference childPath = ChildReference.concatenate(le.path, new ComponentReference());
                                sa.addListener(le.listener, cis, childPath, le.executor);
                            }
                            catch (AccessorException e) {
                                throw new AccessorConstructionException(e);
                            }
                        }
                        le = le.next;
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
            return (T)sa;
        }
        catch (BindingException be) {
            throw new AccessorConstructionException(be);
        }
    }

    @Override
    public Object getComponentValue(Binding componentBinding) throws AccessorException {
        this.readLock();
        try {
            int tag = this.getBinding().getTag(this.object);
            Binding cb = this.getBinding().getComponentBinding(tag);
            Object cv = this.getBinding().getValue(this.object);
            Object object = this.adapt(cv, cb, componentBinding);
            return object;
        }
        catch (AdaptException ae) {
            throw new AccessorException(ae);
        }
        catch (BindingException be) {
            throw new AccessorException(be);
        }
        catch (AdapterConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getTag() throws AccessorException {
        this.readLock();
        try {
            int n = this.getBinding().getTag(this.object);
            return n;
        }
        catch (BindingException bindingException) {
            throw new AccessorException();
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setComponentValue(int tag, Binding componentBinding, Object componentValue) throws AccessorException {
        this.writeLock();
        try {
            int oldTag = this.getBinding().getTag(this.object);
            int newTag = tag;
            boolean hadSameTag = oldTag == newTag;
            JavaObject sa = this.getExistingAccessor();
            if (sa != null && !hadSameTag) {
                this.component = null;
                sa.invalidatedNotification();
            }
            if (sa != null && hadSameTag) {
                sa.setValue(componentBinding, componentValue);
                return;
            }
            try {
                Binding cb = this.getBinding().getComponentBinding(newTag);
                Object cv = this.adapt(componentValue, componentBinding, cb);
                this.getBinding().setValue(this.object, newTag, cv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    UnionInterestSet is = (UnionInterestSet)le.getInterestSet();
                    if (is.inNotificationsOf(tag)) {
                        MutableVariant newComponentValue = null;
                        if (is.inValuesOf(tag)) {
                            newComponentValue = new MutableVariant(cb, cb.isImmutable() ? cv : cb.clone(cv));
                        }
                        UnionValueAssigned e = new UnionValueAssigned(newTag, newComponentValue);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (AdapterConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        super.addListener(listener, interestSet, path, executor);
        UnionInterestSet is = (UnionInterestSet)interestSet;
        if (is.componentInterests != null) {
            int tag = this.getTag();
            InterestSet cis = is.componentInterests[tag];
            if (cis == null) {
                return;
            }
            JavaObject sa = this.getExistingAccessor();
            if (sa == null) {
                return;
            }
            ChildReference childPath = ChildReference.concatenate(path, new IndexReference(tag));
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        UnionInterestSet is = (UnionInterestSet)e.interestSet;
        if (is.componentInterests != null) {
            int i = 0;
            while (i < is.componentInterests.length) {
                InterestSet cis = is.componentInterests[i];
                if (cis != null) {
                    JavaObject sa = this.getExistingAccessor();
                    if (sa == null) {
                        return;
                    }
                    sa.removeListener(listener);
                }
                ++i;
            }
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        try {
            ModificationEvent rollback = null;
            if (e instanceof ValueAssigned) {
                ValueAssigned va = (ValueAssigned)e;
                if (makeRollback) {
                    rollback = new ValueAssigned(this.getBinding(), this.getValue(this.getBinding()));
                }
                this.setValue(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            if (e instanceof UnionValueAssigned) {
                UnionValueAssigned ua = (UnionValueAssigned)e;
                if (ua.tag < 0 || ua.tag >= this.type().getComponentCount()) {
                    throw new AccessorException("Tag index (" + ua.tag + ") out of bounds.");
                }
                if (!ua.newValue.type().equals(this.type().getComponent((int)ua.tag).type)) {
                    throw new AccessorException("Cannot assign " + ua.newValue.type() + " to " + this.type().getComponent((int)ua.tag).type);
                }
                if (makeRollback) {
                    UnionBinding ub = this.getBinding();
                    int tag = this.getTag();
                    Binding cb = ub.getComponentBinding(tag);
                    Object cv = ub.getValue(this.object);
                    MutableVariant v = new MutableVariant(cb, cv);
                    rollback = new UnionValueAssigned(tag, v);
                }
                this.setComponentValue(ua.tag, ua.newValue.getBinding(), ua.newValue.getValue());
                return rollback;
            }
            throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Union Type");
        }
        catch (BindingException be) {
            throw new AccessorException(be);
        }
    }
}

