/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.RecordInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.RecordType;

public class CompositeRecord
implements RecordAccessor {
    protected List<Accessor> fields = new ArrayList<Accessor>();
    protected Map<String, Accessor> names = new HashMap<String, Accessor>();
    protected RecordType type = new RecordType();
    protected Accessor parent;
    protected AccessorParams params;

    public CompositeRecord() {
        this.params = AccessorParams.DEFAULT;
    }

    public CompositeRecord(Accessor parent) {
        this.parent = parent;
        this.params = AccessorParams.DEFAULT;
    }

    public CompositeRecord(Accessor parent, AccessorParams params) {
        this.parent = parent;
        this.params = params;
    }

    public void addField(String name, Accessor field) {
        this.fields.add(field);
        this.names.put(name, field);
        this.type.addComponent(name, field.type());
    }

    public void removeField(String name) {
        Accessor a = this.names.remove(name);
        this.fields.remove(a);
        this.type.removeComponent(name);
    }

    @Override
    public int count() {
        return this.fields.size();
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        RecordInterestSet is = (RecordInterestSet)interestSet;
        try {
            if (is.componentInterests != null) {
                int i = 0;
                while (i < this.count()) {
                    InterestSet cis = is.getComponentInterest(i);
                    if (cis != null) {
                        ChildReference childPath = ChildReference.concatenate(path, new IndexReference(i));
                        Object ca = this.getFieldAccessor(i);
                        ca.addListener(listener, cis, childPath, executor);
                    }
                    ++i;
                }
            }
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        for (Accessor a : this.fields) {
            a.removeListener(listener);
        }
    }

    @Override
    public <T extends Accessor> T getFieldAccessor(int index) throws AccessorConstructionException {
        if (index < 0 || index >= this.fields.size()) {
            throw new AccessorConstructionException("Field index " + index + " does not exist");
        }
        return (T)this.fields.get(index);
    }

    @Override
    public <T extends Accessor> T getFieldAccessor(String fieldName) throws AccessorConstructionException {
        Accessor accessor = this.names.get(fieldName);
        if (accessor == null) {
            throw new AccessorConstructionException("Field by name " + fieldName + " was not found");
        }
        return (T)accessor;
    }

    @Override
    public Object getFieldValue(String fieldName, Binding fieldBinding) throws AccessorException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorException("Field " + fieldName + " does not exist");
        }
        return this.getFieldValue(fieldIndex, fieldBinding);
    }

    @Override
    public Object getFieldValue(int index, Binding fieldBinding) throws AccessorException {
        if (index < 0 || index >= this.fields.size()) {
            throw new AccessorException("Field index " + index + " does not exist");
        }
        return this.fields.get(index).getValue(fieldBinding);
    }

    @Override
    public void setFieldValue(String fieldName, Binding fieldBinding, Object value) throws AccessorException {
        int fieldIndex = this.type().getComponentIndex(fieldName);
        if (fieldIndex < 0) {
            throw new AccessorException("Field " + fieldName + " does not exist");
        }
        this.setFieldValue(fieldIndex, fieldBinding, value);
    }

    @Override
    public boolean setValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.setValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public boolean getValue(ChildReference path, Binding binding, Object obj) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            a.getValue(binding, obj);
            return true;
        }
        catch (ReferenceException referenceException) {
            return false;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getValue(ChildReference path, Binding binding) throws AccessorException {
        try {
            Object a = this.getComponent(path);
            return a.getValue(binding);
        }
        catch (ReferenceException referenceException) {
            return null;
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setFieldValue(int index, Binding fieldBinding, Object value) throws AccessorException {
        if (index < 0 || index >= this.fields.size()) {
            throw new AccessorException("Field index " + index + " does not exist");
        }
        this.fields.get(index).setValue(fieldBinding, value);
    }

    @Override
    public RecordType type() {
        return this.type;
    }

    @Override
    public void apply(List<Event> cs, LinkedList<Event> rollback) throws AccessorException {
        try {
            boolean makeRollback = rollback != null;
            ArrayList<Event> single = new ArrayList<Event>();
            for (Event e : cs) {
                if (e.reference == null) {
                    Event rbe = this.applyLocal(e, makeRollback);
                    if (!makeRollback) continue;
                    rbe.reference = e.reference;
                    rollback.addFirst(rbe);
                    continue;
                }
                Object sa = this.getComponent(e.reference);
                single.clear();
                Event noRefEvent = e.clone(null);
                single.add(noRefEvent);
                sa.apply(single, rollback);
            }
        }
        catch (AccessorConstructionException ae) {
            throw new AccessorException(ae);
        }
    }

    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        try {
            if (e instanceof ValueAssigned) {
                ValueAssigned va = (ValueAssigned)e;
                ValueAssigned rollback = null;
                if (makeRollback) {
                    Binding binding = this.params.bindingScheme.getBinding(this.type());
                    rollback = new ValueAssigned(binding, this.getValue(binding));
                }
                this.setValue(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Record Type");
        }
        catch (BindingConstructionException e2) {
            throw new AccessorException(e2);
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            String fieldName = lr.label;
            Integer index = this.type().getComponentIndex(fieldName);
            if (index == null) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            T sa = this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = sa.getComponent(reference.getChildReference());
            }
            return sa;
        }
        if (reference instanceof IndexReference) {
            IndexReference ref = (IndexReference)reference;
            int index = ref.getIndex();
            T sa = this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = sa.getComponent(reference.getChildReference());
            }
            return sa;
        }
        if (reference instanceof NameReference) {
            NameReference ref = (NameReference)reference;
            String fieldName = ref.getName();
            Integer index = this.type().getComponentIndex(fieldName);
            if (index == null) {
                throw new ReferenceException("RecordType doesn't have field by name \"" + fieldName + "\"");
            }
            T sa = this.getFieldAccessor(index);
            if (reference.getChildReference() != null) {
                sa = sa.getComponent(reference.getChildReference());
            }
            return sa;
        }
        throw new ReferenceException(reference.getClass() + " is not a subreference of RecordType");
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        if (!binding.type().equals(this.type)) {
            throw new AccessorException("Type mismatch");
        }
        RecordBinding rb = (RecordBinding)binding;
        try {
            Object[] values = new Object[rb.getComponentCount()];
            int i = 0;
            while (i < values.length) {
                Object cv;
                Binding cb = rb.getComponentBinding(i);
                values[i] = cv = this.fields.get(i).getValue(cb);
                ++i;
            }
            return rb.create(values);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void getValue(Binding dstBinding, Object dst) throws AccessorException {
        if (!dstBinding.type().equals(this.type)) {
            throw new AccessorException("Type mismatch");
        }
        RecordBinding db = (RecordBinding)dstBinding;
        try {
            int i = 0;
            while (i < db.getComponentCount()) {
                Object c = db.getComponent(dst, i);
                Binding dcb = db.getComponentBinding(i);
                this.fields.get(i).getValue(dcb, c);
                db.setComponent(dst, i, c);
                ++i;
            }
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setValue(Binding binding, Object newValue) throws AccessorException {
        if (!binding.type().equals(this.type)) {
            throw new AccessorException("Type mismatch");
        }
        RecordBinding rb = (RecordBinding)binding;
        try {
            int i = 0;
            while (i < rb.getComponentCount()) {
                Binding cb = rb.getComponentBinding(i);
                Object cv = rb.getComponent(newValue, i);
                this.fields.get(i).setValue(cb, cv);
                ++i;
            }
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }
}

