/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.VariantAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.interestset.VariantInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.binary.Blob;

public class BinaryVariant
extends BinaryObject
implements VariantAccessor,
FileVariantAccessor {
    static Datatype type_type = Datatypes.getDatatypeUnchecked(Datatype.class);
    static Binding type_binding = Bindings.getBindingUnchecked(Datatype.class);
    static Serializer type_serializer = Bindings.getSerializerUnchecked(type_binding);
    SoftReference<BinaryObject> child;

    public BinaryVariant(BinaryObject parent, Blob blob, Datatype type, AccessorParams params) {
        super(parent, blob, type, params);
    }

    @Override
    public VariantType type() {
        return (VariantType)this.type;
    }

    @Override
    public <T extends Accessor> T getContentAccessor() throws AccessorConstructionException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            BinaryObject sa = this.getExistingAccessor();
            if (sa == null) {
                this.b.position(0L);
                ArrayList<Object> ids = new ArrayList<Object>(0);
                Datatype type = (Datatype)type_serializer.deserialize(this.b, ids);
                sa = this.createSubAccessor(type, this.b.position(), this.b.length() - this.b.position(), this.params);
                this.child = new SoftReference<BinaryObject>(sa);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ChildReference childPath;
                    VariantInterestSet is = (VariantInterestSet)le.getInterestSet();
                    InterestSet cis = is.getComponentInterest();
                    if (cis != null) {
                        try {
                            childPath = ChildReference.concatenate(le.path, new ComponentReference());
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    if (is.inCompleteComponent()) {
                        cis = InterestSet.newInterestSet(this.getContentType(), true, true, true);
                        try {
                            childPath = ChildReference.concatenate(le.path, new ComponentReference());
                            sa.addListener(le.listener, cis, childPath, le.executor);
                        }
                        catch (AccessorException e) {
                            throw new AccessorConstructionException(e);
                        }
                    }
                    le = le.next;
                }
            }
            BinaryObject binaryObject = sa;
            return (T)binaryObject;
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
        catch (AccessorException e) {
            throw new AccessorConstructionException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    protected BinaryObject getExistingAccessor() {
        SoftReference<BinaryObject> r = this.child;
        if (r == null) {
            return null;
        }
        BinaryObject sa = r.get();
        return sa;
    }

    @Override
    public void setContentValueNoflush(Binding valueBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            BinaryObject sa = this.getExistingAccessor();
            if (sa != null && valueBinding.type().equals(sa.type())) {
                sa.setValue(valueBinding, value);
                return;
            }
            try {
                if (sa != null) {
                    sa.invalidatedNotification();
                    this.child = null;
                    sa = null;
                }
                Binding cb = valueBinding;
                Serializer cs = this.params.serializerScheme.getSerializer(cb);
                Datatype ct = valueBinding.type();
                Object cv = value;
                TObjectIntHashMap ids = new TObjectIntHashMap(0);
                int len = type_serializer.getSize(ct, (TObjectIntHashMap<Object>)ids);
                this.b.setLength(len += cs.getSize(cv, null));
                this.b.position(0L);
                ids.clear();
                type_serializer.serialize(this.b, (TObjectIntHashMap<Object>)ids, ct);
                cs.serialize(this.b, null, cv);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    VariantInterestSet is = (VariantInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        MutableVariant v = null;
                        if (is.inValues()) {
                            v = new MutableVariant(valueBinding, valueBinding.isImmutable() ? value : valueBinding.clone(value));
                        }
                        ValueAssigned e = new ValueAssigned(Bindings.MUTABLE_VARIANT, v);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
            catch (SerializerConstructionException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setContentValue(Binding valueBinding, Object value) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            this.setContentValueNoflush(valueBinding, value);
            this.flush();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public Datatype getContentType() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            Datatype type;
            this.b.position(0L);
            ArrayList<Object> ids = new ArrayList<Object>(0);
            Datatype datatype = type = (Datatype)type_serializer.deserialize(this.b, ids);
            return datatype;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Object getContentValue(Binding contentBinding) throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            ArrayList<Object> ids = new ArrayList<Object>();
            Datatype type = (Datatype)type_serializer.deserialize(this.b, ids);
            ids.clear();
            if (!contentBinding.type().equals(type)) {
                throw new AccessorException("Arg error, wrong type");
            }
            Serializer value_serializer = this.params.serializerScheme.getSerializer(contentBinding);
            Object object = value_serializer.deserialize(this.b, ids);
            return object;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        catch (SerializerConstructionException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            if (lr.label.equals("v")) {
                T sa = this.getContentAccessor();
                if (reference.getChildReference() != null) {
                    sa = sa.getComponent(reference.getChildReference());
                }
                return sa;
            }
        }
        if (reference instanceof ComponentReference) {
            T sa = this.getContentAccessor();
            if (reference.getChildReference() != null) {
                sa = sa.getComponent(reference.getChildReference());
            }
            return sa;
        }
        throw new AccessorConstructionException("Variant value reference expected, got " + reference.getClass().getName());
    }

    @Override
    public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference path, Executor executor) throws AccessorException {
        ChildReference childPath;
        super.addListener(listener, interestSet, path, executor);
        VariantInterestSet is = (VariantInterestSet)interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null && !is.inCompleteComponent()) {
            return;
        }
        BinaryObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        if (cis != null) {
            childPath = ChildReference.concatenate(path, new ComponentReference());
            sa.addListener(listener, cis, childPath, executor);
        }
        if (is.inCompleteComponent()) {
            childPath = ChildReference.concatenate(path, new ComponentReference());
            cis = InterestSet.newInterestSet(this.getContentType(), true, true, true);
            sa.addListener(listener, cis, childPath, executor);
        }
    }

    @Override
    public void removeListener(Accessor.Listener listener) throws AccessorException {
        ListenerEntry e = this.detachListener(listener);
        if (e == null) {
            return;
        }
        VariantInterestSet is = (VariantInterestSet)e.interestSet;
        InterestSet cis = is.getComponentInterest();
        if (cis == null && !is.inCompleteComponent()) {
            return;
        }
        BinaryObject sa = this.getExistingAccessor();
        if (sa == null) {
            return;
        }
        if (cis != null) {
            sa.removeListener(listener);
        }
        if (is.inCompleteComponent()) {
            sa.removeListener(listener);
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        try {
            if (e instanceof ValueAssigned) {
                ValueAssigned rollback = null;
                ValueAssigned va = (ValueAssigned)e;
                if (va.newValue == null) {
                    throw new AccessorException("Cannot apply variant assignment event, the value is missing");
                }
                if (makeRollback) {
                    this.b.position(0L);
                    ArrayList<Object> ids = new ArrayList<Object>();
                    Datatype type = (Datatype)type_serializer.deserialize(this.b, ids);
                    Binding cb = this.params.bindingScheme.getBinding(type);
                    Serializer value_serializer = this.params.serializerScheme.getSerializer(cb);
                    Object lv = value_serializer.deserialize(this.b, ids);
                    rollback = new ValueAssigned(Bindings.MUTABLE_VARIANT, (Object)new MutableVariant(cb, lv));
                }
                this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
                return rollback;
            }
            throw new AccessorException("Invalid event " + e.getClass().getName());
        }
        catch (IOException ioe) {
            throw new AccessorException(ioe);
        }
        catch (RuntimeSerializerConstructionException rsce) {
            throw new AccessorException(rsce);
        }
        catch (SerializerConstructionException e2) {
            throw new AccessorException(e2);
        }
        catch (BindingConstructionException e2) {
            throw new AccessorException(e2);
        }
    }

    @Override
    public void setValueNoflush(Binding variantBinding, Object variantValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                VariantBinding vb = (VariantBinding)variantBinding;
                Object vv = variantValue;
                Binding cb = vb.getContentBinding(vv);
                Object cv = vb.getContent(vv, cb);
                this.setContentValueNoflush(cb, cv);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }
}

