/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;

public class SetFocusableDynamicMenuContribution {
    public static final String SET_FOCUSABLE_ID = "org.simantics.district.network.ui.setFocusable";
    public static final String FOCUSABLE_ELEMENTS = "org.simantics.district.network.ui.focusableElements";

    @AboutToShow
    public void aboutToShow(IEclipseContext popupContext, @Named(value="org.eclipse.ui.selection") ISelection selection, List<MMenuElement> items, @Named(value="e4ActivePart") MPart part) {
        IEditorPart editorPart = E4WorkbenchUtils.getActiveIEditorPart((MPart)part);
        IDiagram diagram = (IDiagram)editorPart.getAdapter(IDiagram.class);
        if (diagram == null) {
            return;
        }
        PickContext pick = (PickContext)diagram.getDiagramClass().getSingleItem(PickContext.class);
        if (pick == null) {
            return;
        }
        ICanvasContext ctx = (ICanvasContext)editorPart.getAdapter(ICanvasContext.class);
        if (ctx == null) {
            return;
        }
        Point2D canvasPosition = (Point2D)ctx.getHintStack().getHint(DiagramHints.POPUP_MENU_CANVAS_POSITION);
        if (canvasPosition == null) {
            return;
        }
        ArrayList result = new ArrayList();
        ILayersEditor le = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        boolean oldIgnore = le.getIgnoreFocusSettings();
        le.setIgnoreFocusSettings(true);
        pick.pick(diagram, new PickRequest(canvasPosition.getX(), canvasPosition.getY()), result);
        le.setIgnoreFocusSettings(oldIgnore);
        boolean allow = false;
        for (IElement elem : result) {
            ElementLayers el = (ElementLayers)elem.getElementClass().getAtMostOneItemOfClass(ElementLayers.class);
            for (ILayer layer : le.getVisibleLayers()) {
                boolean focusable = el.isFocusable(elem, layer);
                if (focusable) continue;
                allow = true;
            }
        }
        MHandledMenuItem dynamicItem = MMenuFactory.INSTANCE.createHandledMenuItem();
        if (allow) {
            dynamicItem.setLabel("Allow focusing");
        } else {
            dynamicItem.setLabel("Disallow focusing");
        }
        dynamicItem.setContributorURI("platform:/plugin/org.simantics.district.network.ui");
        dynamicItem.setIconURI("platform:/plugin/org.simantics.modeling.ui/icons/shape_handles.png");
        dynamicItem.setCommand(E4WorkbenchUtils.getMCommandById((String)SET_FOCUSABLE_ID));
        items.add((MMenuElement)dynamicItem);
        popupContext.set(FOCUSABLE_ELEMENTS, result);
    }

    @AboutToHide
    public void aboutToHide(IEclipseContext popupContext) {
        popupContext.remove(FOCUSABLE_ELEMENTS);
    }
}

