/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.util.concurrent.TimeUnit;
import org.simantics.district.network.ui.DistrictPanZoomRotateHandler;
import org.simantics.district.network.ui.NetworkDrawingParticipant;
import org.simantics.district.network.ui.participants.DNPointerInteractor;
import org.simantics.district.network.ui.participants.MapRulerPainter;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.DelayedBatchElementPainter;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.maps.MapScalingTransform;
import org.simantics.maps.eclipse.MapPainter;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DistrictDiagramViewer
extends DiagramViewer {
    protected void addDiagramParticipants(ICanvasContext ctx) {
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)new Selection());
        ctx.add((Object)new ElementPainter());
        ctx.add((Object)new DNPointerInteractor());
        ctx.add((Object)new MapPainter(MapScalingTransform.INSTANCE));
        ctx.add((Object)new NetworkDrawingParticipant(MapScalingTransform.INSTANCE));
    }

    protected String getPopupId() {
        return "#DistrictDiagramPopup";
    }

    public void initializeCanvasContext(CanvasContext ctx) {
        super.initializeCanvasContext(ctx);
        IHintContext h = ctx.getDefaultHintContext();
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)1000000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)0.003);
    }

    protected void addPainterParticipants(ICanvasContext ctx) {
        ctx.add((Object)new RenderingQualityInteractor());
        ctx.add((Object)new DelayedBatchElementPainter(PickRequest.PickFilter.FILTER_MONITORS, 500L, TimeUnit.MILLISECONDS));
    }

    protected void addGridRulerBackgroundParticipants(CanvasContext ctx) {
        ctx.add((Object)new GridPainter());
        ctx.add((Object)new MapRulerPainter());
        ctx.add((Object)new BackgroundPainter());
    }

    protected void addViewManipulationParticipants(CanvasContext ctx) {
        ctx.add((Object)new DistrictPanZoomRotateHandler());
        ctx.add((Object)new ZoomToAreaHandler());
    }
}

