/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.wms;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.WebService;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;
import org.simantics.maps.wms.ServiceException;
import org.simantics.maps.wms.WMSGetMapQuery;

public class WMSTileProvider
implements ITileProvider {
    private WebService service;
    private int tileSize;
    private String[] layers;

    public WMSTileProvider(WebService service, int tileSize, String ... layers) {
        this.service = service;
        this.tileSize = tileSize;
        this.layers = layers;
    }

    @Override
    public URI getSource() {
        return this.service.getURI();
    }

    @Override
    public Rectangle2D getExtent() {
        return new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
    }

    @Override
    public Image get(TileKey key) throws ProvisionException {
        int level = key.getLevel();
        int x = key.getX();
        int y = key.getY();
        double xTiles = Math.pow(2.0, level + 1);
        double yTiles = Math.pow(2.0, level);
        if (level < 0) {
            throw new IllegalArgumentException("invalid tile level " + level + " (tile=" + key + ")");
        }
        if (x < 0 || x >= (int)xTiles) {
            throw new IllegalArgumentException("tile x out of bounds " + x + " (tile=" + key + ")");
        }
        if (y < 0 || y >= (int)yTiles) {
            throw new IllegalArgumentException("tile y out of bounds " + y + " (tile=" + key + ")");
        }
        try {
            Rectangle2D.Double r = new Rectangle2D.Double();
            double minx = -180.0;
            double miny = -90.0;
            double w = 360.0;
            double h = 180.0;
            double xdelta = w / xTiles;
            double ydelta = h / yTiles;
            double xx = x;
            double yy = yTiles - (double)y - 1.0;
            r.setFrame(minx + xdelta * xx, miny + ydelta * yy, xdelta, ydelta);
            BufferedImage img = WMSTileProvider.getMap(this.service, this.tileSize, this.tileSize, r, "image/jpeg", this.layers);
            return img;
        }
        catch (MalformedURLException e) {
            throw new ProvisionException(e);
        }
        catch (IOException e) {
            throw new ProvisionException(e);
        }
    }

    public static BufferedImage getMap(WebService service, Dimension rasterSize, Rectangle2D bbox, String format, String ... layers) throws MalformedURLException, IOException {
        return WMSTileProvider.getMap(service, rasterSize.width, rasterSize.height, bbox, format, layers);
    }

    public static BufferedImage getMap(WebService service, int rasterWidth, int rasterHeight, Rectangle2D bbox, String format, String ... layers) throws MalformedURLException, IOException {
        if (rasterWidth == 0 || rasterHeight == 0) {
            return new BufferedImage(0, 0, 2);
        }
        WMSGetMapQuery req = new WMSGetMapQuery(rasterWidth, rasterHeight, bbox, format, layers);
        HttpURLConnection connection = null;
        try {
            String contentType;
            connection = service.openConnection("", req.toString());
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                System.err.println("Method failed: " + connection.getResponseMessage());
            }
            if ((contentType = connection.getHeaderField("Content-Type")) != null && contentType.equals(format)) {
                InputStream response = connection.getInputStream();
                BufferedImage img = ImageIO.read(response);
                if (img == null) {
                    throw new IIOException("ImageIO returned null, unable to decode stream as image data.");
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            StringBuilder sb = new StringBuilder();
            for (String h : connection.getHeaderFields().keySet()) {
                sb.append(h);
                sb.append(": ");
                sb.append(connection.getHeaderField(h));
                sb.append("\n");
            }
            String response = connection.getContent().toString();
            sb.append("Response body:\n");
            sb.append(response);
            throw new ServiceException("WMS GetMap request failed: " + connection.getURL().toString() + "\n" + sb.toString());
        }
        finally {
            connection.disconnect();
        }
    }
}

