/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.tests;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.simantics.maps.WebService;
import org.simantics.maps.wms.WMSGetMapQuery;

public class WMSTest1 {
    private static String serviceUrl = "http://wms.jpl.nasa.gov/wms.cgi";

    public static void main(String[] args) throws MalformedURLException, URISyntaxException {
        WebService service = new WebService(serviceUrl);
        WMSGetMapQuery req = new WMSGetMapQuery(600, 300, new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0), "image/jpeg", "global_mosaic");
        HttpURLConnection connection = null;
        try {
            try {
                connection = service.openConnection("", req.toString());
                int statusCode = connection.getResponseCode();
                if (statusCode != 200) {
                    System.err.println("Method failed: " + connection.getResponseMessage());
                }
                byte[] buf = new byte[16384];
                int read = 0;
                InputStream response = connection.getInputStream();
                FileOutputStream fo = new FileOutputStream(File.createTempFile("wmsresponse", ""));
                try {
                    while ((read = response.read(buf)) != -1) {
                        fo.write(buf, 0, read);
                    }
                }
                finally {
                    fo.close();
                    response.close();
                }
            }
            catch (IOException e) {
                System.err.println("Fatal transport error: " + e.getMessage());
                e.printStackTrace();
                connection.disconnect();
            }
        }
        finally {
            connection.disconnect();
        }
    }
}

